/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.io.IOException;
import java.security.Security;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthenticationException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.AuthenticationProviderFactory;
import org.apache.hive.service.auth.PasswdAuthenticationProvider;
import org.apache.hive.service.auth.PlainSaslServer;
import org.apache.hive.service.auth.TSSLBasedProcessor;
import org.apache.hive.service.auth.TSetIpAddressProcessor;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;

public final class PlainSaslHelper {
    public static TProcessorFactory getPlainProcessorFactory(ThriftCLIService service, HiveConf hiveConf, boolean isHopsSSL) {
        if (isHopsSSL) {
            return new TSSLBasedProcessorFactory(service, hiveConf);
        }
        return new TSetIpAddressProcessorFactory(service);
    }

    public static TTransportFactory getPlainTransportFactory(String authTypeStr) throws LoginException {
        TSaslServerTransport.Factory saslFactory = new TSaslServerTransport.Factory();
        try {
            saslFactory.addServerDefinition("PLAIN", authTypeStr, null, new HashMap(), (CallbackHandler)new PlainServerCallbackHandler(authTypeStr));
        }
        catch (AuthenticationException e) {
            throw new LoginException("Error setting callback handler" + e);
        }
        return saslFactory;
    }

    public static TTransport getPlainTransport(String username, String password, TTransport underlyingTransport) throws SaslException {
        return new TSaslClientTransport("PLAIN", null, null, null, new HashMap(), (CallbackHandler)new PlainCallbackHandler(username, password), underlyingTransport);
    }

    private PlainSaslHelper() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    static {
        Security.addProvider(new PlainSaslServer.SaslPlainProvider());
    }

    private static final class TSSLBasedProcessorFactory
    extends TProcessorFactory {
        private final ThriftCLIService service;
        private final HiveConf hiveConf;

        TSSLBasedProcessorFactory(ThriftCLIService service, HiveConf hiveConf) {
            super(null);
            this.service = service;
            this.hiveConf = hiveConf;
        }

        public TProcessor getProcessor(TTransport trans) {
            return new TSSLBasedProcessor(this.service, this.hiveConf);
        }
    }

    private static final class TSetIpAddressProcessorFactory
    extends TProcessorFactory {
        private final ThriftCLIService service;

        TSetIpAddressProcessorFactory(ThriftCLIService service) {
            super(null);
            this.service = service;
        }

        public TProcessor getProcessor(TTransport trans) {
            return new TSetIpAddressProcessor(this.service);
        }
    }

    public static class PlainCallbackHandler
    implements CallbackHandler {
        private final String username;
        private final String password;

        public PlainCallbackHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)callback;
                    nameCallback.setName(this.username);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback passCallback = (PasswordCallback)callback;
                    passCallback.setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }
    }

    public static final class PlainServerCallbackHandler
    implements CallbackHandler {
        private final AuthenticationProviderFactory.AuthMethods authMethod;

        PlainServerCallbackHandler(String authMethodStr) throws AuthenticationException {
            this.authMethod = AuthenticationProviderFactory.AuthMethods.getValidAuthMethod(authMethodStr);
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            String username = null;
            String password = null;
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    username = nc.getName();
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    password = new String(pc.getPassword());
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    ac = (AuthorizeCallback)callback;
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
            PasswdAuthenticationProvider provider = AuthenticationProviderFactory.getAuthenticationProvider(this.authMethod);
            provider.Authenticate(username, password);
            if (ac != null) {
                ac.setAuthorized(true);
            }
        }
    }
}

