/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import com.google.common.base.Strings;
import io.hops.security.HopsUtil;
import io.hops.security.HopsX509AuthenticationException;
import io.hops.security.HopsX509Authenticator;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.TSetIpAddressProcessor;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSSLBasedProcessor<I extends TCLIService.Iface>
extends TSetIpAddressProcessor<TCLIService.Iface> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TSetIpAddressProcessor.class.getName());
    private static final Pattern PROJECT_USER = Pattern.compile("\\w*__\\w*");
    private final HopsX509Authenticator hopsX509Authenticator;
    private final Set<String> usersAllowedToImpersonateSuperuser;
    private HiveConf hiveConf = null;

    public TSSLBasedProcessor(TCLIService.Iface iface, HiveConf hiveConf) {
        super(iface);
        this.hiveConf = hiveConf;
        this.hopsX509Authenticator = new HopsX509Authenticator((Configuration)hiveConf);
        this.usersAllowedToImpersonateSuperuser = new HashSet<String>(5);
        String defaultAllowedUsersStr = HiveConf.ConfVars.HIVE_SUPERUSER_ALLOWED_IMPERSONATION.defaultStrVal;
        String[] defaultAllowedUsers = !Strings.isNullOrEmpty((String)defaultAllowedUsersStr) ? defaultAllowedUsersStr.split(",") : new String[]{};
        Collections.addAll(this.usersAllowedToImpersonateSuperuser, hiveConf.getTrimmedStrings(HiveConf.ConfVars.HIVE_SUPERUSER_ALLOWED_IMPERSONATION.varname, defaultAllowedUsers));
    }

    @Override
    protected void setUserName(TProtocol in) throws TException {
        if (THREAD_LOCAL_USER_NAME.get() != null) {
            return;
        }
        try {
            TTransport transport = in.getTransport();
            Socket socket = ((TSocket)transport).getSocket();
            X509Certificate[] certs = ((SSLSocket)socket).getSession().getPeerCertificateChain();
            if (certs.length == 0) {
                throw new TException("Missing certificates");
            }
            String DN = certs[0].getSubjectDN().getName();
            String cn = HopsUtil.extractCNFromSubject((String)DN);
            if (cn == null) {
                throw new TException("Cannot authenticate the user: Unrecognized CN format");
            }
            Matcher matcher = PROJECT_USER.matcher(cn);
            if (!matcher.matches()) {
                try {
                    String locality;
                    if (this.hopsX509Authenticator.isTrustedConnection(InetAddress.getByName((String)THREAD_LOCAL_IP_ADDRESS.get()), cn) && this.usersAllowedToImpersonateSuperuser.contains((locality = HopsUtil.extractLFromSubject((String)DN)).trim())) {
                        THREAD_LOCAL_USER_NAME.set(this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SUPER_USER));
                        return;
                    }
                }
                catch (UnknownHostException ex) {
                    LOGGER.error("Cannot resolve machine address: ", (Throwable)ex);
                    throw new TException("Cannot authenticate the user");
                }
                catch (HopsX509AuthenticationException ex) {
                    LOGGER.debug("Cannot authenticate super user", (Throwable)ex);
                    throw new TException("Authentication failure", (Throwable)ex);
                }
                throw new TException("Failed to authenticate superuser");
            }
            THREAD_LOCAL_USER_NAME.set(cn);
        }
        catch (SSLException e) {
            throw new TException((Throwable)e);
        }
    }
}

