/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.TSetIpAddressProcessor;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSSLBasedProcessor<I extends TCLIService.Iface>
extends TSetIpAddressProcessor<TCLIService.Iface> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TSetIpAddressProcessor.class.getName());
    private HiveConf hiveConf = null;

    public TSSLBasedProcessor(TCLIService.Iface iface, HiveConf hiveConf) {
        super(iface);
        this.hiveConf = hiveConf;
    }

    @Override
    protected void setUserName(TProtocol in) throws TException {
        block9: {
            if (THREAD_LOCAL_USER_NAME.get() != null) {
                return;
            }
            try {
                TTransport transport = in.getTransport();
                Socket socket = ((TSocket)transport).getSocket();
                X509Certificate[] certs = ((SSLSocket)socket).getSession().getPeerCertificateChain();
                if (certs.length == 0) {
                    throw new TException("Missing certificates");
                }
                String DN = certs[0].getSubjectDN().getName();
                String[] dnTokens = DN.split(",");
                String[] cnTokens = dnTokens[0].split("=", 2);
                if (cnTokens.length != 2) {
                    throw new TException("Cannot authenticate the user: Unrecognized CN format");
                }
                if (cnTokens[1].contains("__")) {
                    THREAD_LOCAL_USER_NAME.set(cnTokens[1]);
                    break block9;
                }
                InetAddress hostnameIp = null;
                try {
                    hostnameIp = InetAddress.getByName(cnTokens[1]);
                }
                catch (UnknownHostException ex) {
                    LOGGER.error("Cannot resolve machine address: ", (Throwable)ex);
                    throw new TException("Cannot authenticate the user");
                }
                if (!hostnameIp.getHostAddress().equals(THREAD_LOCAL_IP_ADDRESS.get())) {
                    LOGGER.error("Superuser request coming from a different host");
                    throw new TException("Cannot authenticate the user");
                }
                THREAD_LOCAL_USER_NAME.set(this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SUPER_USER));
            }
            catch (SSLException e) {
                throw new TException((Throwable)e);
            }
        }
    }
}

