/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.auth.TServerSocketFactory;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.thrift.ThreadPoolExecutorWithOomHook;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.server.ThreadFactoryWithGarbageCleanup;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.ServerContext;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;

public class ThriftBinaryCLIService
extends ThriftCLIService {
    private final Runnable oomHook;

    public ThriftBinaryCLIService(CLIService cliService, boolean tls, boolean hops2WayTLS, Runnable oomHook) {
        super(cliService, ThriftBinaryCLIService.class.getSimpleName());
        this.oomHook = oomHook;
        this.tls = tls;
        this.hops2WayTLS = hops2WayTLS;
    }

    @Override
    public void run() {
        try {
            String threadPoolName = "HiveServer2-Handler-Pool";
            ThreadPoolExecutorWithOomHook executorService = new ThreadPoolExecutorWithOomHook(this.minWorkerThreads, this.maxWorkerThreads, this.workerKeepAliveTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new ThreadFactoryWithGarbageCleanup(threadPoolName), this.oomHook);
            this.startThriftBinary(executorService, this.tls, this.hops2WayTLS);
        }
        catch (Throwable t) {
            LOG.error("Error starting HiveServer2: could not start " + ThriftBinaryCLIService.class.getSimpleName(), t);
            System.exit(-1);
        }
    }

    private void startThriftBinary(ExecutorService executorService, boolean tls, boolean hops2WayTLS) throws Throwable {
        hiveAuthFactory = new HiveAuthFactory(this.hiveConf);
        TTransportFactory transportFactory = hiveAuthFactory.getAuthTransFactory();
        TProcessorFactory processorFactory = hiveAuthFactory.getAuthProcFactory(this, this.hiveConf, hops2WayTLS);
        TServerSocket serverSocket = null;
        serverSocket = hops2WayTLS ? TServerSocketFactory.getServerSocket((Configuration)this.hiveConf, (TServerSocketFactory.TSocketType)TServerSocketFactory.TSocketType.TWOWAYTLS, (String)this.hiveHost, (int)this.portNum) : (tls ? TServerSocketFactory.getServerSocket((Configuration)this.hiveConf, (TServerSocketFactory.TSocketType)TServerSocketFactory.TSocketType.TLS, (String)this.hiveHost, (int)this.portNum) : TServerSocketFactory.getServerSocket((Configuration)this.hiveConf, (TServerSocketFactory.TSocketType)TServerSocketFactory.TSocketType.PLAIN, (String)this.hiveHost, (int)this.portNum));
        int maxMessageSize = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_MAX_MESSAGE_SIZE);
        int requestTimeout = (int)this.hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_LOGIN_TIMEOUT, TimeUnit.SECONDS);
        int beBackoffSlotLength = (int)this.hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_LOGIN_BEBACKOFF_SLOT_LENGTH, TimeUnit.MILLISECONDS);
        TThreadPoolServer.Args sargs = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverSocket).processorFactory(processorFactory)).transportFactory(transportFactory)).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).inputProtocolFactory((TProtocolFactory)new TBinaryProtocol.Factory(true, true, (long)maxMessageSize, (long)maxMessageSize))).requestTimeout(requestTimeout).requestTimeoutUnit(TimeUnit.SECONDS).beBackoffSlotLength(beBackoffSlotLength).beBackoffSlotLengthUnit(TimeUnit.MILLISECONDS).executorService(executorService);
        this.server = new TThreadPoolServer(sargs);
        this.server.setServerEventHandler(new TServerEventHandler(){

            public ServerContext createContext(TProtocol input, TProtocol output) {
                Metrics metrics = MetricsFactory.getInstance();
                if (metrics != null) {
                    try {
                        metrics.incrementCounter("open_connections");
                        metrics.incrementCounter("cumulative_connection_count");
                    }
                    catch (Exception e) {
                        ThriftCLIService.LOG.warn("Error Reporting JDO operation to Metrics system", (Throwable)e);
                    }
                }
                return new ThriftCLIService.ThriftCLIServerContext();
            }

            public void deleteContext(ServerContext serverContext, TProtocol input, TProtocol output) {
                ThriftCLIService.ThriftCLIServerContext context;
                SessionHandle sessionHandle;
                Metrics metrics = MetricsFactory.getInstance();
                if (metrics != null) {
                    try {
                        metrics.decrementCounter("open_connections");
                    }
                    catch (Exception e) {
                        ThriftCLIService.LOG.warn("Error Reporting JDO operation to Metrics system", (Throwable)e);
                    }
                }
                if ((sessionHandle = (context = (ThriftCLIService.ThriftCLIServerContext)serverContext).getSessionHandle()) != null) {
                    ThriftCLIService.LOG.info("Session disconnected without closing properly. ");
                    try {
                        boolean close = ThriftBinaryCLIService.this.cliService.getSessionManager().getSession(sessionHandle).getHiveConf().getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_CLOSE_SESSION_ON_DISCONNECT);
                        ThriftCLIService.LOG.info((close ? "" : "Not ") + "Closing the session: " + sessionHandle);
                        if (close) {
                            ThriftBinaryCLIService.this.cliService.closeSession(sessionHandle);
                        }
                    }
                    catch (HiveSQLException e) {
                        ThriftCLIService.LOG.warn("Failed to close session: " + e, (Throwable)e);
                    }
                }
            }

            public void preServe() {
            }

            public void processContext(ServerContext serverContext, TTransport input, TTransport output) {
                ThriftBinaryCLIService.this.currentServerContext.set(serverContext);
            }
        });
        String msg = "Starting " + ThriftBinaryCLIService.class.getSimpleName() + " on port " + this.portNum + " with " + this.minWorkerThreads + "..." + this.maxWorkerThreads + " worker threads";
        LOG.info(msg);
        this.server.serve();
    }
}

