/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.ndv.hll;

import org.apache.hadoop.hive.common.ndv.hll.HyperLogLog;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestHyperLogLog {
    private float longRangeTolerance = 5.0f;
    private float shortRangeTolerance = 2.0f;

    @Test(expected=IllegalArgumentException.class)
    public void testHLLDenseMerge() {
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).build();
        HyperLogLog hll2 = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).build();
        HyperLogLog hll3 = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).build();
        HyperLogLog hll4 = HyperLogLog.builder().setNumRegisterIndexBits(16).setEncoding(HyperLogLog.EncodingType.DENSE).build();
        int size = 1000;
        for (int i = 0; i < size; ++i) {
            hll.addLong((long)i);
            hll2.addLong((long)(size + i));
            hll3.addLong((long)(2 * size + i));
        }
        double threshold = size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)size / 100.0;
        Assert.assertEquals((double)size, (double)hll.count(), (double)delta);
        Assert.assertEquals((double)size, (double)hll2.count(), (double)delta);
        hll.merge(hll2);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll.getEncoding());
        hll.merge(hll2);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll.getEncoding());
        hll.merge(hll3);
        Assert.assertEquals((double)(3.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll.getEncoding());
        hll.merge(hll4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHLLSparseMerge() {
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll2 = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll3 = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll4 = HyperLogLog.builder().setNumRegisterIndexBits(16).setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        int size = 500;
        for (int i = 0; i < size; ++i) {
            hll.addLong((long)i);
            hll2.addLong((long)(size + i));
            hll3.addLong((long)(2 * size + i));
        }
        double threshold = size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)size / 100.0;
        Assert.assertEquals((double)size, (double)hll.count(), (double)delta);
        Assert.assertEquals((double)size, (double)hll2.count(), (double)delta);
        hll.merge(hll2);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.SPARSE, (Object)hll.getEncoding());
        hll.merge(hll2);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.SPARSE, (Object)hll.getEncoding());
        hll.merge(hll3);
        Assert.assertEquals((double)(3.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.SPARSE, (Object)hll.getEncoding());
        hll.merge(hll4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHLLSparseDenseMerge() {
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll2 = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll3 = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).build();
        HyperLogLog hll4 = HyperLogLog.builder().setNumRegisterIndexBits(16).setEncoding(HyperLogLog.EncodingType.DENSE).build();
        int size = 1000;
        for (int i = 0; i < size; ++i) {
            hll.addLong((long)i);
            hll2.addLong((long)(size + i));
            hll3.addLong((long)(2 * size + i));
        }
        double threshold = size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)size / 100.0;
        Assert.assertEquals((double)size, (double)hll.count(), (double)delta);
        Assert.assertEquals((double)size, (double)hll2.count(), (double)delta);
        hll.merge(hll2);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.SPARSE, (Object)hll.getEncoding());
        hll.merge(hll2);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.SPARSE, (Object)hll.getEncoding());
        hll.merge(hll3);
        Assert.assertEquals((double)(3.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll.getEncoding());
        hll.merge(hll4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHLLDenseSparseMerge() {
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).build();
        HyperLogLog hll2 = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).build();
        HyperLogLog hll3 = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll4 = HyperLogLog.builder().setNumRegisterIndexBits(16).setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        int size = 1000;
        for (int i = 0; i < size; ++i) {
            hll.addLong((long)i);
            hll2.addLong((long)(size + i));
            hll3.addLong((long)(2 * size + i));
        }
        double threshold = size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)size / 100.0;
        Assert.assertEquals((double)size, (double)hll.count(), (double)delta);
        Assert.assertEquals((double)size, (double)hll2.count(), (double)delta);
        hll.merge(hll2);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll.getEncoding());
        hll.merge(hll2);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll.getEncoding());
        hll.merge(hll3);
        Assert.assertEquals((double)(3.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll.getEncoding());
        hll.merge(hll4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHLLSparseOverflowMerge() {
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll2 = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll3 = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll4 = HyperLogLog.builder().setNumRegisterIndexBits(16).setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        int size = 1000;
        for (int i = 0; i < size; ++i) {
            hll.addLong((long)i);
            hll2.addLong((long)(size + i));
            hll3.addLong((long)(2 * size + i));
        }
        double threshold = size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)size / 100.0;
        Assert.assertEquals((double)size, (double)hll.count(), (double)delta);
        Assert.assertEquals((double)size, (double)hll2.count(), (double)delta);
        hll.merge(hll2);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.SPARSE, (Object)hll.getEncoding());
        hll.merge(hll2);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.SPARSE, (Object)hll.getEncoding());
        hll.merge(hll3);
        Assert.assertEquals((double)(3.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll.getEncoding());
        hll.merge(hll4);
    }

    @Test
    public void testHLLSparseMoreRegisterBits() {
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).setNumRegisterIndexBits(16).build();
        int size = 1000;
        for (int i = 0; i < size; ++i) {
            hll.addLong((long)i);
        }
        double threshold = size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)size / 100.0;
        Assert.assertEquals((double)size, (double)hll.count(), (double)delta);
    }
}

