/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.MockPartitionExpressionForMetastore;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.partition.spec.CompositePartitionSpecProxy;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MetastoreCheckinTest.class})
public class TestHiveMetaStorePartitionSpecs {
    private static final Logger LOG = LoggerFactory.getLogger(TestHiveMetaStorePartitionSpecs.class);
    private static int msPort;
    private static Configuration conf;
    private static String dbName;
    private static String tableName;
    private static int nDates;
    private static String datePrefix;

    @AfterClass
    public static void tearDown() throws Exception {
        LOG.info("Shutting down metastore.");
        HiveMetaStoreClient hmsc = new HiveMetaStoreClient(conf);
        hmsc.dropDatabase(dbName, true, true, true);
    }

    @BeforeClass
    public static void startMetaStoreServer() throws Exception {
        Configuration metastoreConf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setClass((Configuration)metastoreConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS, MockPartitionExpressionForMetastore.class, PartitionExpressionProxy.class);
        MetaStoreTestUtils.setConfForStandloneMode(metastoreConf);
        msPort = MetaStoreTestUtils.startMetaStoreWithRetry(metastoreConf);
        conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)("thrift://localhost:" + msPort));
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES, (long)3L);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        MetastoreConf.setClass((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS, MockPartitionExpressionForMetastore.class, PartitionExpressionProxy.class);
    }

    private static void createTable(HiveMetaStoreClient hmsc, boolean enablePartitionGrouping) throws Exception {
        ArrayList<FieldSchema> columns = new ArrayList<FieldSchema>();
        columns.add(new FieldSchema("foo", "string", ""));
        columns.add(new FieldSchema("bar", "string", ""));
        ArrayList<FieldSchema> partColumns = new ArrayList<FieldSchema>();
        partColumns.add(new FieldSchema("dt", "string", ""));
        partColumns.add(new FieldSchema("blurb", "string", ""));
        SerDeInfo serdeInfo = new SerDeInfo("LBCSerDe", "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe", new HashMap());
        StorageDescriptor storageDescriptor = new StorageDescriptor(columns, null, "org.apache.hadoop.hive.ql.io.RCFileInputFormat", "org.apache.hadoop.hive.ql.io.RCFileOutputFormat", false, 0, serdeInfo, null, null, null);
        HashMap<String, String> tableParameters = new HashMap<String, String>();
        tableParameters.put("hive.hcatalog.partition.spec.grouping.enabled", enablePartitionGrouping ? "true" : "false");
        Table table = new Table(tableName, dbName, "", 0, 0, 0, storageDescriptor, partColumns, tableParameters, "", "", "");
        hmsc.createTable(table);
        Assert.assertTrue((String)("Table " + dbName + "." + tableName + " does not exist"), (boolean)hmsc.tableExists(dbName, tableName));
    }

    private static void clearAndRecreateDB(HiveMetaStoreClient hmsc) throws Exception {
        hmsc.dropDatabase(dbName, true, true, true);
        new DatabaseBuilder().setName(dbName).create((IMetaStoreClient)hmsc, conf);
    }

    private static String getPartitionPath(Table table, List<String> partValues) {
        return partValues.get(1).equalsIgnoreCase("isLocatedOutsideTablePath") ? table.getSd().getLocation().replace(table.getTableName(), "location_outside_" + table.getTableName()) + "_" + partValues.get(0) + "_" + partValues.get(1) : null;
    }

    private static void populatePartitions(HiveMetaStoreClient hmsc, Table table, List<String> blurbs) throws Exception {
        for (int i = 0; i < nDates; ++i) {
            for (String blurb : blurbs) {
                StorageDescriptor sd = new StorageDescriptor(table.getSd());
                List<String> values = Arrays.asList(datePrefix + i, blurb);
                sd.setLocation(TestHiveMetaStorePartitionSpecs.getPartitionPath(table, values));
                hmsc.add_partition(new Partition(values, dbName, tableName, 0, 0, sd, null));
            }
        }
    }

    private void testGetPartitionSpecs(boolean enablePartitionGrouping) {
        try {
            HiveMetaStoreClient hmsc = new HiveMetaStoreClient(conf);
            TestHiveMetaStorePartitionSpecs.clearAndRecreateDB(hmsc);
            TestHiveMetaStorePartitionSpecs.createTable(hmsc, enablePartitionGrouping);
            Table table = hmsc.getTable(dbName, tableName);
            TestHiveMetaStorePartitionSpecs.populatePartitions(hmsc, table, Arrays.asList("isLocatedInTablePath", "isLocatedOutsideTablePath"));
            PartitionSpecProxy partitionSpecProxy = hmsc.listPartitionSpecs(dbName, tableName, -1);
            Assert.assertEquals((String)"Unexpected number of partitions.", (long)(nDates * 2), (long)partitionSpecProxy.size());
            HashMap locationToDateMap = new HashMap();
            locationToDateMap.put("isLocatedInTablePath", new ArrayList());
            locationToDateMap.put("isLocatedOutsideTablePath", new ArrayList());
            PartitionSpecProxy.PartitionIterator iterator = partitionSpecProxy.getPartitionIterator();
            while (iterator.hasNext()) {
                Partition partition = (Partition)iterator.next();
                ((List)locationToDateMap.get(partition.getValues().get(1))).add(partition.getValues().get(0));
            }
            ArrayList<String> expectedDates = new ArrayList<String>(nDates);
            for (int i = 0; i < nDates; ++i) {
                expectedDates.add(datePrefix + i);
            }
            Assert.assertArrayEquals((String)"Unexpected date-values.", (Object[])expectedDates.toArray(), (Object[])((List)locationToDateMap.get("isLocatedInTablePath")).toArray());
            Assert.assertArrayEquals((String)"Unexpected date-values.", (Object[])expectedDates.toArray(), (Object[])((List)locationToDateMap.get("isLocatedOutsideTablePath")).toArray());
            partitionSpecProxy = hmsc.listPartitionSpecsByFilter(dbName, tableName, "blurb = \"isLocatedOutsideTablePath\"", -1);
            ((List)locationToDateMap.get("isLocatedInTablePath")).clear();
            ((List)locationToDateMap.get("isLocatedOutsideTablePath")).clear();
            iterator = partitionSpecProxy.getPartitionIterator();
            while (iterator.hasNext()) {
                Partition partition = (Partition)iterator.next();
                ((List)locationToDateMap.get(partition.getValues().get(1))).add(partition.getValues().get(0));
            }
            Assert.assertEquals((String)"Unexpected date-values.", (long)0L, (long)((List)locationToDateMap.get("isLocatedInTablePath")).size());
            Assert.assertArrayEquals((String)"Unexpected date-values.", (Object[])expectedDates.toArray(), (Object[])((List)locationToDateMap.get("isLocatedOutsideTablePath")).toArray());
        }
        catch (Throwable t) {
            LOG.error("Unexpected Exception!", t);
            t.printStackTrace();
            Assert.assertTrue((String)"Unexpected Exception!", (boolean)false);
        }
    }

    @Test
    public void testGetPartitionSpecs_WithAndWithoutPartitionGrouping() {
        this.testGetPartitionSpecs(true);
        this.testGetPartitionSpecs(false);
    }

    @Test
    public void testAddPartitions() {
        try {
            HiveMetaStoreClient hmsc = new HiveMetaStoreClient(conf);
            TestHiveMetaStorePartitionSpecs.clearAndRecreateDB(hmsc);
            TestHiveMetaStorePartitionSpecs.createTable(hmsc, true);
            Table table = hmsc.getTable(dbName, tableName);
            TestHiveMetaStorePartitionSpecs.populatePartitions(hmsc, table, Arrays.asList("isLocatedInTablePath", "isLocatedOutsideTablePath"));
            String targetTableName = "cloned_" + tableName;
            Table targetTable = new Table(table);
            targetTable.setTableName(targetTableName);
            StorageDescriptor targetTableSd = new StorageDescriptor(targetTable.getSd());
            targetTableSd.setLocation(targetTableSd.getLocation().replace(tableName, targetTableName));
            hmsc.createTable(targetTable);
            PartitionSpecProxy partitionsForAddition = hmsc.listPartitionSpecsByFilter(dbName, tableName, "blurb = \"isLocatedInTablePath\"", -1);
            partitionsForAddition.setTableName(targetTableName);
            partitionsForAddition.setRootLocation(targetTableSd.getLocation());
            Assert.assertEquals((String)"Unexpected number of partitions added. ", (long)partitionsForAddition.size(), (long)hmsc.add_partitions_pspec(partitionsForAddition));
            PartitionSpecProxy clonedPartitions = hmsc.listPartitionSpecs(dbName, targetTableName, -1);
            Assert.assertEquals((String)"Unexpected number of partitions returned. ", (long)partitionsForAddition.size(), (long)clonedPartitions.size());
            PartitionSpecProxy.PartitionIterator sourceIterator = partitionsForAddition.getPartitionIterator();
            PartitionSpecProxy.PartitionIterator targetIterator = clonedPartitions.getPartitionIterator();
            while (targetIterator.hasNext()) {
                Partition sourcePartition = (Partition)sourceIterator.next();
                Partition targetPartition = (Partition)targetIterator.next();
                Assert.assertEquals((String)"Mismatched values.", (Object)sourcePartition.getValues(), (Object)targetPartition.getValues());
                Assert.assertEquals((String)"Mismatched locations.", (Object)sourcePartition.getSd().getLocation(), (Object)targetPartition.getSd().getLocation());
            }
        }
        catch (Throwable t) {
            LOG.error("Unexpected Exception!", t);
            t.printStackTrace();
            Assert.assertTrue((String)"Unexpected Exception!", (boolean)false);
        }
    }

    @Test
    public void testFetchingPartitionsWithDifferentSchemas() {
        try {
            String tableLocation;
            String partitionLocation;
            HiveMetaStoreClient hmsc = new HiveMetaStoreClient(conf);
            TestHiveMetaStorePartitionSpecs.clearAndRecreateDB(hmsc);
            TestHiveMetaStorePartitionSpecs.createTable(hmsc, true);
            Table table = hmsc.getTable(dbName, tableName);
            TestHiveMetaStorePartitionSpecs.populatePartitions(hmsc, table, Arrays.asList("isLocatedInTablePath", "isLocatedOutsideTablePath"));
            List fields = table.getSd().getCols();
            fields.add(new FieldSchema("goo", "string", "Entirely new column. Doesn't apply to older partitions."));
            table.getSd().setCols(fields);
            hmsc.alter_table(dbName, tableName, table);
            table = hmsc.getTable(dbName, tableName);
            Assert.assertEquals((String)"Unexpected number of table columns.", (long)3L, (long)table.getSd().getColsSize());
            TestHiveMetaStorePartitionSpecs.populatePartitions(hmsc, table, Arrays.asList("hasNewColumn"));
            PartitionSpecProxy partitionSpecProxy = hmsc.listPartitionSpecs(dbName, tableName, -1);
            Assert.assertEquals((String)"Unexpected number of partitions.", (long)(nDates * 3), (long)partitionSpecProxy.size());
            Assert.assertTrue((String)"Unexpected type of PartitionSpecProxy.", (boolean)(partitionSpecProxy instanceof CompositePartitionSpecProxy));
            CompositePartitionSpecProxy compositePartitionSpecProxy = (CompositePartitionSpecProxy)partitionSpecProxy;
            List partitionSpecs = compositePartitionSpecProxy.toPartitionSpec();
            Assert.assertTrue((String)"PartitionSpec[0] should have been a SharedSDPartitionSpec.", (boolean)((PartitionSpec)partitionSpecs.get(0)).isSetSharedSDPartitionSpec());
            Assert.assertEquals((String)"PartitionSpec[0] should use the table-path as the common root location. ", (Object)table.getSd().getLocation(), (Object)((PartitionSpec)partitionSpecs.get(0)).getRootPath());
            Assert.assertTrue((String)"PartitionSpec[1] should have been a SharedSDPartitionSpec.", (boolean)((PartitionSpec)partitionSpecs.get(1)).isSetSharedSDPartitionSpec());
            Assert.assertEquals((String)"PartitionSpec[1] should use the table-path as the common root location. ", (Object)table.getSd().getLocation(), (Object)((PartitionSpec)partitionSpecs.get(1)).getRootPath());
            Assert.assertTrue((String)"PartitionSpec[2] should have been a ListComposingPartitionSpec.", (boolean)((PartitionSpec)partitionSpecs.get(2)).isSetPartitionList());
            PartitionSpecProxy.PartitionIterator iterator = partitionSpecProxy.getPartitionIterator();
            HashMap blurbToPartitionList = new HashMap(3);
            while (iterator.hasNext()) {
                Partition partition = (Partition)iterator.next();
                String blurb = (String)partition.getValues().get(1);
                if (!blurbToPartitionList.containsKey(blurb)) {
                    blurbToPartitionList.put(blurb, new ArrayList(nDates));
                }
                ((List)blurbToPartitionList.get(blurb)).add(partition);
            }
            for (Partition partition : (List)blurbToPartitionList.get("isLocatedOutsideTablePath")) {
                Assert.assertEquals((String)"Unexpected number of columns.", (long)2L, (long)partition.getSd().getCols().size());
                Assert.assertEquals((String)"Unexpected first column.", (Object)"foo", (Object)((FieldSchema)partition.getSd().getCols().get(0)).getName());
                Assert.assertEquals((String)"Unexpected second column.", (Object)"bar", (Object)((FieldSchema)partition.getSd().getCols().get(1)).getName());
                partitionLocation = partition.getSd().getLocation();
                tableLocation = table.getSd().getLocation();
                Assert.assertTrue((String)("Unexpected partition location: " + partitionLocation + ". Partition should have been outside table location: " + tableLocation), (!partitionLocation.startsWith(tableLocation) ? 1 : 0) != 0);
            }
            for (Partition partition : (List)blurbToPartitionList.get("isLocatedInTablePath")) {
                Assert.assertEquals((String)"Unexpected number of columns.", (long)2L, (long)partition.getSd().getCols().size());
                Assert.assertEquals((String)"Unexpected first column.", (Object)"foo", (Object)((FieldSchema)partition.getSd().getCols().get(0)).getName());
                Assert.assertEquals((String)"Unexpected second column.", (Object)"bar", (Object)((FieldSchema)partition.getSd().getCols().get(1)).getName());
                partitionLocation = partition.getSd().getLocation();
                tableLocation = table.getSd().getLocation();
                Assert.assertTrue((String)("Unexpected partition location: " + partitionLocation + ". Partition should have been within table location: " + tableLocation), (boolean)partitionLocation.startsWith(tableLocation));
            }
            for (Partition partition : (List)blurbToPartitionList.get("hasNewColumn")) {
                Assert.assertEquals((String)"Unexpected number of columns.", (long)3L, (long)partition.getSd().getCols().size());
                Assert.assertEquals((String)"Unexpected first column.", (Object)"foo", (Object)((FieldSchema)partition.getSd().getCols().get(0)).getName());
                Assert.assertEquals((String)"Unexpected second column.", (Object)"bar", (Object)((FieldSchema)partition.getSd().getCols().get(1)).getName());
                Assert.assertEquals((String)"Unexpected third column.", (Object)"goo", (Object)((FieldSchema)partition.getSd().getCols().get(2)).getName());
                partitionLocation = partition.getSd().getLocation();
                tableLocation = table.getSd().getLocation();
                Assert.assertTrue((String)("Unexpected partition location: " + partitionLocation + ". Partition should have been within table location: " + tableLocation), (boolean)partitionLocation.startsWith(tableLocation));
            }
        }
        catch (Throwable t) {
            LOG.error("Unexpected Exception!", t);
            t.printStackTrace();
            Assert.assertTrue((String)"Unexpected Exception!", (boolean)false);
        }
    }

    static {
        dbName = "testpartitionspecs_db";
        tableName = "testpartitionspecs_table";
        nDates = 10;
        datePrefix = "2014010";
    }
}

