/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.IMetaStoreSchemaInfo;
import org.apache.hadoop.hive.metastore.MetaStoreSchemaInfoFactory;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.tools.MetastoreSchemaTool;
import org.apache.hadoop.hive.metastore.tools.TestMetastoreSchemaTool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MetastoreCheckinTest.class})
public class TestSchemaToolForMetastore {
    private static final Logger LOG = LoggerFactory.getLogger(TestMetastoreSchemaTool.class);
    private MetastoreSchemaTool schemaTool;
    private Connection conn;
    private Configuration conf;
    private String testMetastoreDB;
    private PrintStream errStream;
    private PrintStream outStream;

    @Before
    public void setUp() throws HiveMetaException, IOException {
        this.testMetastoreDB = System.getProperty("java.io.tmpdir") + File.separator + "test_metastore-" + new Random().nextInt();
        System.setProperty(MetastoreConf.ConfVars.CONNECT_URL_KEY.toString(), "jdbc:derby:" + this.testMetastoreDB + ";create=true");
        this.conf = MetastoreConf.newMetastoreConf();
        this.schemaTool = new MetastoreSchemaTool(System.getProperty("test.tmp.dir", "target/tmp"), this.conf, "derby");
        this.schemaTool.setUserName(MetastoreConf.getVar((Configuration)this.schemaTool.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_USER_NAME));
        this.schemaTool.setPassWord(MetastoreConf.getPassword((Configuration)this.schemaTool.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PWD));
        System.setProperty("beeLine.system.exit", "true");
        this.errStream = System.err;
        this.outStream = System.out;
        this.conn = this.schemaTool.getConnectionToMetastore(false);
    }

    @After
    public void tearDown() throws IOException, SQLException {
        File metaStoreDir = new File(this.testMetastoreDB);
        if (metaStoreDir.exists()) {
            FileUtils.forceDeleteOnExit((File)metaStoreDir);
        }
        System.setOut(this.outStream);
        System.setErr(this.errStream);
        if (this.conn != null) {
            this.conn.close();
        }
    }

    @Test
    public void testValidateSequences() throws Exception {
        this.schemaTool.doInit();
        boolean isValid = this.schemaTool.validateSequences(this.conn);
        Assert.assertTrue((boolean)isValid);
        String[] scripts = new String[]{"insert into SEQUENCE_TABLE values('org.apache.hadoop.hive.metastore.model.MDatabase', 100);", "insert into CTLGS values(37, 'mycat', 'my description', 'hdfs://tmp');", "insert into DBS values(99, 'test db1', 'hdfs:///tmp', 'db1', 'test', 'test', 'mycat');"};
        File scriptFile = this.generateTestScript(scripts);
        this.schemaTool.runSqlLine(scriptFile.getPath());
        isValid = this.schemaTool.validateSequences(this.conn);
        Assert.assertTrue((boolean)isValid);
        scripts = new String[]{"delete from SEQUENCE_TABLE;", "delete from DBS;", "insert into SEQUENCE_TABLE values('org.apache.hadoop.hive.metastore.model.MDatabase', 100);", "insert into DBS values(102, 'test db1', 'hdfs:///tmp', 'db1', 'test', 'test', 'mycat');"};
        scriptFile = this.generateTestScript(scripts);
        this.schemaTool.runSqlLine(scriptFile.getPath());
        isValid = this.schemaTool.validateSequences(this.conn);
        Assert.assertFalse((boolean)isValid);
    }

    @Test
    public void testValidateSchemaTables() throws Exception {
        this.schemaTool.doInit("1.2.0");
        boolean isValid = this.schemaTool.validateSchemaTables(this.conn);
        Assert.assertTrue((boolean)isValid);
        this.schemaTool.doUpgrade("1.2.0");
        isValid = this.schemaTool.validateSchemaTables(this.conn);
        Assert.assertTrue((boolean)isValid);
        String[] scripts = new String[]{"RENAME TABLE SEQUENCE_TABLE to SEQUENCE_TABLE_RENAMED;", "RENAME TABLE NUCLEUS_TABLES to NUCLEUS_TABLES_RENAMED;"};
        File scriptFile = this.generateTestScript(scripts);
        this.schemaTool.runSqlLine(scriptFile.getPath());
        isValid = this.schemaTool.validateSchemaTables(this.conn);
        Assert.assertFalse((boolean)isValid);
        scripts = new String[]{"RENAME TABLE SEQUENCE_TABLE_RENAMED to SEQUENCE_TABLE;", "RENAME TABLE NUCLEUS_TABLES_RENAMED to NUCLEUS_TABLES;"};
        scriptFile = this.generateTestScript(scripts);
        this.schemaTool.runSqlLine(scriptFile.getPath());
        isValid = this.schemaTool.validateSchemaTables(this.conn);
        Assert.assertTrue((boolean)isValid);
    }

    @Test
    public void testValidateNullValues() throws Exception {
        this.schemaTool.doInit();
        boolean isValid = this.schemaTool.validateColumnNullValues(this.conn);
        Assert.assertTrue((boolean)isValid);
        this.createTestHiveTableSchemas();
        isValid = this.schemaTool.validateColumnNullValues(this.conn);
        String[] scripts = new String[]{"update TBLS set SD_ID=null"};
        File scriptFile = this.generateTestScript(scripts);
        this.schemaTool.runSqlLine(scriptFile.getPath());
        isValid = this.schemaTool.validateColumnNullValues(this.conn);
        Assert.assertFalse((boolean)isValid);
    }

    @Test
    public void testSchemaInitDryRun() throws Exception {
        this.schemaTool.setDryRun(true);
        this.schemaTool.doInit("3.0.0");
        this.schemaTool.setDryRun(false);
        try {
            this.schemaTool.verifySchemaVersion();
        }
        catch (HiveMetaException e) {
            return;
        }
        Assert.fail((String)"Dry run shouldn't create actual metastore");
    }

    @Test
    public void testSchemaUpgradeDryRun() throws Exception {
        this.schemaTool.doInit("1.2.0");
        this.schemaTool.setDryRun(true);
        this.schemaTool.doUpgrade("1.2.0");
        this.schemaTool.setDryRun(false);
        try {
            this.schemaTool.verifySchemaVersion();
        }
        catch (HiveMetaException e) {
            return;
        }
        Assert.fail((String)"Dry run shouldn't upgrade metastore schema");
    }

    @Test
    public void testSchemaInit() throws Exception {
        IMetaStoreSchemaInfo metastoreSchemaInfo = MetaStoreSchemaInfoFactory.get((Configuration)this.conf, (String)System.getProperty("test.tmp.dir", "target/tmp"), (String)"derby");
        LOG.info("Starting testSchemaInit");
        this.schemaTool.doInit(metastoreSchemaInfo.getHiveSchemaVersion());
        this.schemaTool.verifySchemaVersion();
    }

    @Test
    public void testValidateSchemaVersions() throws Exception {
        this.schemaTool.doInit();
        boolean isValid = this.schemaTool.validateSchemaVersions();
        String[] scripts = new String[]{"insert into VERSION values(100, '2.2.0', 'Hive release version 2.2.0')"};
        File scriptFile = this.generateTestScript(scripts);
        this.schemaTool.runSqlLine(scriptFile.getPath());
        isValid = this.schemaTool.validateSchemaVersions();
        Assert.assertFalse((boolean)isValid);
        scripts = new String[]{"delete from VERSION where VER_ID = 100"};
        scriptFile = this.generateTestScript(scripts);
        this.schemaTool.runSqlLine(scriptFile.getPath());
        isValid = this.schemaTool.validateSchemaVersions();
        Assert.assertTrue((boolean)isValid);
        scripts = new String[]{"delete from VERSION"};
        scriptFile = this.generateTestScript(scripts);
        this.schemaTool.runSqlLine(scriptFile.getPath());
        isValid = this.schemaTool.validateSchemaVersions();
        Assert.assertFalse((boolean)isValid);
    }

    @Test
    public void testSchemaUpgrade() throws Exception {
        boolean foundException = false;
        this.schemaTool.doInit("1.2.0");
        try {
            this.schemaTool.verifySchemaVersion();
        }
        catch (HiveMetaException e) {
            foundException = true;
        }
        if (!foundException) {
            throw new Exception("Hive operations shouldn't pass with older version schema");
        }
        String invalidPreUpgradeScript = this.writeDummyPreUpgradeScript(0, "upgrade-2.3.0-to-3.0.0.derby.sql", "foo bar;");
        String validPreUpgradeScript0 = this.writeDummyPreUpgradeScript(1, "upgrade-2.3.0-to-3.0.0.derby.sql", "CREATE TABLE schema_test0 (id integer);");
        String validPreUpgradeScript1 = this.writeDummyPreUpgradeScript(2, "upgrade-2.3.0-to-3.0.0.derby.sql", "CREATE TABLE schema_test1 (id integer);");
        this.schemaTool.setVerbose(true);
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        PrintStream errPrintStream = new PrintStream(stderr);
        System.setErr(errPrintStream);
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        PrintStream outPrintStream = new PrintStream(stdout);
        System.setOut(outPrintStream);
        Exception caught = null;
        try {
            this.schemaTool.doUpgrade("1.2.0");
        }
        catch (Exception e) {
            caught = e;
        }
        LOG.info("stdout is " + ((Object)stdout).toString());
        LOG.info("stderr is " + ((Object)stderr).toString());
        if (caught != null) {
            Assert.fail((String)caught.getMessage());
        }
        Assert.assertTrue((boolean)((Object)stderr).toString().contains(invalidPreUpgradeScript));
        Assert.assertTrue((boolean)((Object)stderr).toString().contains("foo"));
        Assert.assertFalse((boolean)((Object)stderr).toString().contains(validPreUpgradeScript0));
        Assert.assertFalse((boolean)((Object)stderr).toString().contains(validPreUpgradeScript1));
        Assert.assertTrue((boolean)((Object)stdout).toString().contains(validPreUpgradeScript0));
        Assert.assertTrue((boolean)((Object)stdout).toString().contains(validPreUpgradeScript1));
        this.schemaTool.verifySchemaVersion();
    }

    @Test
    public void testValidateLocations() throws Exception {
        this.schemaTool.doInit();
        URI defaultRoot = new URI("hdfs://myhost.com:8020");
        URI defaultRoot2 = new URI("s3://myhost2.com:8888");
        boolean isValid = this.schemaTool.validateLocations(this.conn, null);
        Assert.assertTrue((boolean)isValid);
        isValid = this.schemaTool.validateLocations(this.conn, new URI[]{defaultRoot, defaultRoot2});
        Assert.assertTrue((boolean)isValid);
        String[] scripts = new String[]{"insert into CTLGS values (1, 'mycat', 'mydescription', 'hdfs://myhost.com:8020/user/hive/warehouse');", "insert into DBS values(2, 'my db', 'hdfs://myhost.com:8020/user/hive/warehouse/mydb', 'mydb', 'public', 'role', 'mycat');", "insert into DBS values(7, 'db with bad port', 'hdfs://myhost.com:8020/', 'haDB', 'public', 'role', 'mycat');", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (1,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://myhost.com:8020/user/hive/warehouse/mydb',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (2,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://myhost.com:8020/user/admin/2015_11_18',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (3,null,'org.apache.hadoop.mapred.TextInputFormat','N','N',null,-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (4000,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://myhost.com:8020/',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (2 ,1435255431,2,0 ,'hive',0,1,'mytal','MANAGED_TABLE',NULL,NULL,'n');", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (3 ,1435255431,2,0 ,'hive',0,3,'myView','VIRTUAL_VIEW','select a.col1,a.col2 from foo','select * from foo','n');", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (4012 ,1435255431,7,0 ,'hive',0,4000,'mytal4012','MANAGED_TABLE',NULL,NULL,'n');", "insert into PARTITIONS(PART_ID,CREATE_TIME,LAST_ACCESS_TIME, PART_NAME,SD_ID,TBL_ID) values(1, 1441402388,0, 'd1=1/d2=1',2,2);", "insert into SKEWED_STRING_LIST values(1);", "insert into SKEWED_STRING_LIST values(2);", "insert into SKEWED_COL_VALUE_LOC_MAP values(1,1,'hdfs://myhost.com:8020/user/hive/warehouse/mytal/HIVE_DEFAULT_LIST_BUCKETING_DIR_NAME/');", "insert into SKEWED_COL_VALUE_LOC_MAP values(2,2,'s3://myhost.com:8020/user/hive/warehouse/mytal/HIVE_DEFAULT_LIST_BUCKETING_DIR_NAME/');"};
        File scriptFile = this.generateTestScript(scripts);
        this.schemaTool.runSqlLine(scriptFile.getPath());
        isValid = this.schemaTool.validateLocations(this.conn, null);
        Assert.assertTrue((boolean)isValid);
        isValid = this.schemaTool.validateLocations(this.conn, new URI[]{defaultRoot, defaultRoot2});
        Assert.assertTrue((boolean)isValid);
        scripts = new String[]{"delete from SKEWED_COL_VALUE_LOC_MAP;", "delete from SKEWED_STRING_LIST;", "delete from PARTITIONS;", "delete from TBLS;", "delete from SDS;", "delete from DBS;", "insert into DBS values(2, 'my db', '/user/hive/warehouse/mydb', 'mydb', 'public', 'role', 'mycat');", "insert into DBS values(4, 'my db2', 'hdfs://myhost.com:8020', '', 'public', 'role', 'mycat');", "insert into DBS values(6, 'db with bad port', 'hdfs://myhost.com:8020:', 'zDB', 'public', 'role', 'mycat');", "insert into DBS values(7, 'db with bad port', 'hdfs://mynameservice.com/', 'haDB', 'public', 'role', 'mycat');", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (1,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://yourhost.com:8020/user/hive/warehouse/mydb',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (2,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','file:///user/admin/2015_11_18',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (2 ,1435255431,2,0 ,'hive',0,1,'mytal','MANAGED_TABLE',NULL,NULL,'n');", "insert into PARTITIONS(PART_ID,CREATE_TIME,LAST_ACCESS_TIME, PART_NAME,SD_ID,TBL_ID) values(1, 1441402388,0, 'd1=1/d2=1',2,2);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (3000,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','yourhost.com:8020/user/hive/warehouse/mydb',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (4000,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://myhost.com:8020/',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (4001,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://myhost.com:8020',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (4003,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://myhost.com:8020',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (4004,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://myhost.com:8020',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (4002,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://myhost.com:8020/',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (5000,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','file:///user/admin/2016_11_18',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (3000 ,1435255431,2,0 ,'hive',0,3000,'mytal3000','MANAGED_TABLE',NULL,NULL,'n');", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (4011 ,1435255431,4,0 ,'hive',0,4001,'mytal4011','MANAGED_TABLE',NULL,NULL,'n');", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (4012 ,1435255431,4,0 ,'hive',0,4002,'','MANAGED_TABLE',NULL,NULL,'n');", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (4013 ,1435255431,4,0 ,'hive',0,4003,'mytal4013','MANAGED_TABLE',NULL,NULL,'n');", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (4014 ,1435255431,2,0 ,'hive',0,4003,'','MANAGED_TABLE',NULL,NULL,'n');", "insert into PARTITIONS(PART_ID,CREATE_TIME,LAST_ACCESS_TIME, PART_NAME,SD_ID,TBL_ID) values(4001, 1441402388,0, 'd1=1/d2=4001',4001,4011);", "insert into PARTITIONS(PART_ID,CREATE_TIME,LAST_ACCESS_TIME, PART_NAME,SD_ID,TBL_ID) values(4002, 1441402388,0, 'd1=1/d2=4002',4002,4012);", "insert into PARTITIONS(PART_ID,CREATE_TIME,LAST_ACCESS_TIME, PART_NAME,SD_ID,TBL_ID) values(4003, 1441402388,0, 'd1=1/d2=4003',4003,4013);", "insert into PARTITIONS(PART_ID,CREATE_TIME,LAST_ACCESS_TIME, PART_NAME,SD_ID,TBL_ID) values(4004, 1441402388,0, 'd1=1/d2=4004',4004,4014);", "insert into PARTITIONS(PART_ID,CREATE_TIME,LAST_ACCESS_TIME, PART_NAME,SD_ID,TBL_ID) values(5000, 1441402388,0, 'd1=1/d2=5000',5000,2);", "insert into SKEWED_STRING_LIST values(1);", "insert into SKEWED_STRING_LIST values(2);", "insert into SKEWED_COL_VALUE_LOC_MAP values(1,1,'hdfs://yourhost.com:8020/user/hive/warehouse/mytal/HIVE_DEFAULT_LIST_BUCKETING_DIR_NAME/');", "insert into SKEWED_COL_VALUE_LOC_MAP values(2,2,'file:///user/admin/warehouse/mytal/HIVE_DEFAULT_LIST_BUCKETING_DIR_NAME/');"};
        scriptFile = this.generateTestScript(scripts);
        this.schemaTool.runSqlLine(scriptFile.getPath());
        isValid = this.schemaTool.validateLocations(this.conn, null);
        Assert.assertFalse((boolean)isValid);
        isValid = this.schemaTool.validateLocations(this.conn, new URI[]{defaultRoot, defaultRoot2});
        Assert.assertFalse((boolean)isValid);
    }

    @Test
    public void testHiveMetastoreDbPropertiesTable() throws HiveMetaException, IOException {
        this.schemaTool.doInit("3.0.0");
        this.validateMetastoreDbPropertiesTable();
    }

    @Test
    public void testMetastoreDbPropertiesAfterUpgrade() throws HiveMetaException, IOException {
        this.schemaTool.doInit("1.2.0");
        this.schemaTool.doUpgrade();
        this.validateMetastoreDbPropertiesTable();
    }

    private File generateTestScript(String[] stmts) throws IOException {
        File testScriptFile = File.createTempFile("schematest", ".sql");
        testScriptFile.deleteOnExit();
        FileWriter fstream = new FileWriter(testScriptFile.getPath());
        BufferedWriter out = new BufferedWriter(fstream);
        for (String line : stmts) {
            out.write(line);
            out.newLine();
        }
        out.close();
        return testScriptFile;
    }

    private void validateMetastoreDbPropertiesTable() throws HiveMetaException, IOException {
        boolean isValid = this.schemaTool.validateSchemaTables(this.conn);
        Assert.assertTrue((boolean)isValid);
        String[] scripts = new String[]{"insert into METASTORE_DB_PROPERTIES values ('guid', 'test-uuid-1', 'dummy uuid 1')", "insert into METASTORE_DB_PROPERTIES values ('guid', 'test-uuid-2', 'dummy uuid 2')"};
        File scriptFile = this.generateTestScript(scripts);
        Exception ex = null;
        try {
            this.schemaTool.runSqlLine(scriptFile.getPath());
        }
        catch (Exception iox) {
            ex = iox;
        }
        Assert.assertTrue((ex != null && ex instanceof IOException ? 1 : 0) != 0);
    }

    private String writeDummyPreUpgradeScript(int index, String upgradeScriptName, String sql) throws Exception {
        String preUpgradeScript = "pre-" + index + "-" + upgradeScriptName;
        String dummyPreScriptPath = System.getProperty("test.tmp.dir", "target/tmp") + File.separatorChar + "scripts" + File.separatorChar + "metastore" + File.separatorChar + "upgrade" + File.separatorChar + "derby" + File.separatorChar + preUpgradeScript;
        FileWriter fstream = new FileWriter(dummyPreScriptPath);
        BufferedWriter out = new BufferedWriter(fstream);
        out.write(sql + System.getProperty("line.separator"));
        out.close();
        return preUpgradeScript;
    }

    private void createTestHiveTableSchemas() throws IOException {
        String[] scripts = new String[]{"insert into CTLGS values (1, 'mycat', 'my description', 'hdfs://myhost.com:8020/user/hive/warehouse');", "insert into DBS values(2, 'my db', 'hdfs://myhost.com:8020/user/hive/warehouse/mydb', 'mydb', 'public', 'role', 'mycat');", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (1,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://myhost.com:8020/user/hive/warehouse/mydb',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (2,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://myhost.com:8020/user/admin/2015_11_18',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (2 ,1435255431,2,0 ,'hive',0,1,'mytal','MANAGED_TABLE',NULL,NULL,'n');", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (3 ,1435255431,2,0 ,'hive',0,2,'aTable','MANAGED_TABLE',NULL,NULL,'n');", "insert into PARTITIONS(PART_ID,CREATE_TIME,LAST_ACCESS_TIME, PART_NAME,SD_ID,TBL_ID) values(1, 1441402388,0, 'd1=1/d2=1',2,2);"};
        File scriptFile = this.generateTestScript(scripts);
        this.schemaTool.runSqlLine(scriptFile.getPath());
    }
}

