/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import io.hops.security.CertificateLocalizationCtx;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.login.LoginException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.DefaultHiveMetaHook;
import org.apache.hadoop.hive.metastore.DefaultMetaStoreFilterHookImpl;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MaterializationsInvalidationCache;
import org.apache.hadoop.hive.metastore.MetaStoreFilterHook;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AddCheckConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AddDefaultConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.AddForeignKeyRequest;
import org.apache.hadoop.hive.metastore.api.AddNotNullConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AddPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.AddPartitionsResult;
import org.apache.hadoop.hive.metastore.api.AddPrimaryKeyRequest;
import org.apache.hadoop.hive.metastore.api.AddUniqueConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.AlterISchemaRequest;
import org.apache.hadoop.hive.metastore.api.CacheFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.CacheFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.CheckConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.ClearFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.ClientCapabilities;
import org.apache.hadoop.hive.metastore.api.ClientCapability;
import org.apache.hadoop.hive.metastore.api.CmRecycleRequest;
import org.apache.hadoop.hive.metastore.api.CmRecycleResponse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.CreateCatalogRequest;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DefaultConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.DropCatalogRequest;
import org.apache.hadoop.hive.metastore.api.DropConstraintRequest;
import org.apache.hadoop.hive.metastore.api.DropPartitionsExpr;
import org.apache.hadoop.hive.metastore.api.DropPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FindSchemasByColsResp;
import org.apache.hadoop.hive.metastore.api.FindSchemasByColsRqst;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventResponse;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.GetCatalogRequest;
import org.apache.hadoop.hive.metastore.api.GetCatalogResponse;
import org.apache.hadoop.hive.metastore.api.GetCatalogsResponse;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataByExprRequest;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataByExprResult;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleRequest;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleResponse;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.GetRuntimeStatsRequest;
import org.apache.hadoop.hive.metastore.api.GetSerdeRequest;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.GetTablesRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.GrantRevokePrivilegeRequest;
import org.apache.hadoop.hive.metastore.api.GrantRevokePrivilegeResponse;
import org.apache.hadoop.hive.metastore.api.GrantRevokeRoleRequest;
import org.apache.hadoop.hive.metastore.api.GrantRevokeRoleResponse;
import org.apache.hadoop.hive.metastore.api.GrantRevokeType;
import org.apache.hadoop.hive.metastore.api.HeartbeatRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.ISchema;
import org.apache.hadoop.hive.metastore.api.ISchemaName;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.MapSchemaVersionToSerdeRequest;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountResponse;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRequest;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprResult;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PutFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.ReplTblWriteIdStateRequest;
import org.apache.hadoop.hive.metastore.api.RequestPartsSpec;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RuntimeStat;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.SchemaVersion;
import org.apache.hadoop.hive.metastore.api.SchemaVersionDescriptor;
import org.apache.hadoop.hive.metastore.api.SchemaVersionState;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.SetSchemaVersionStateRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.TableStatsRequest;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterPoolRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMAlterTriggerRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateOrDropTriggerToPoolMappingRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateOrUpdateMappingRequest;
import org.apache.hadoop.hive.metastore.api.WMCreatePoolRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateTriggerRequest;
import org.apache.hadoop.hive.metastore.api.WMDropMappingRequest;
import org.apache.hadoop.hive.metastore.api.WMDropPoolRequest;
import org.apache.hadoop.hive.metastore.api.WMDropResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMDropTriggerRequest;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMGetActiveResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetAllResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetTriggersForResourePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMMapping;
import org.apache.hadoop.hive.metastore.api.WMNullablePool;
import org.apache.hadoop.hive.metastore.api.WMNullableResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMPool;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanResponse;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.hooks.URIResolverHook;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.ObjectPair;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.X509SecurityMaterial;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HiveMetaStoreClient
implements IMetaStoreClient,
AutoCloseable {
    public static final ClientCapabilities VERSION = new ClientCapabilities(Lists.newArrayList((Object[])new ClientCapability[]{ClientCapability.INSERT_ONLY_TABLES}));
    public static final ClientCapabilities TEST_VERSION = new ClientCapabilities(Lists.newArrayList((Object[])new ClientCapability[]{ClientCapability.INSERT_ONLY_TABLES, ClientCapability.TEST_CAPABILITY}));
    ThriftHiveMetastore.Iface client = null;
    private TTransport transport = null;
    private boolean isConnected = false;
    private URI[] metastoreUris;
    private final HiveMetaHookLoader hookLoader;
    protected final Configuration conf;
    private String tokenStrForm;
    private final boolean localMetaStore;
    private final MetaStoreFilterHook filterHook;
    private final URIResolverHook uriResolverHook;
    private final int fileMetadataBatchSize;
    private Map<String, String> currentMetaVars;
    private static final AtomicInteger connCount = new AtomicInteger(0);
    private int retries = 5;
    private long retryDelaySeconds = 0L;
    private final ClientCapabilities version;
    private Thread clientCertUpdaterThread = null;
    protected static final Logger LOG = LoggerFactory.getLogger(HiveMetaStoreClient.class);

    public HiveMetaStoreClient(Configuration conf) throws MetaException {
        this(conf, null, true);
    }

    public HiveMetaStoreClient(Configuration conf, HiveMetaHookLoader hookLoader) throws MetaException {
        this(conf, hookLoader, true);
    }

    public HiveMetaStoreClient(Configuration conf, HiveMetaHookLoader hookLoader, Boolean allowEmbedded) throws MetaException {
        this.hookLoader = hookLoader;
        this.conf = conf == null ? (conf = MetastoreConf.newMetastoreConf()) : new Configuration(conf);
        this.version = MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.HIVE_IN_TEST) ? TEST_VERSION : VERSION;
        this.filterHook = this.loadFilterHooks();
        this.uriResolverHook = this.loadUriResolverHook();
        this.fileMetadataBatchSize = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.BATCH_RETRIEVE_OBJECTS_MAX);
        String msUri = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.THRIFT_URIS);
        this.localMetaStore = MetastoreConf.isEmbeddedMetaStore(msUri);
        if (this.localMetaStore) {
            if (!allowEmbedded.booleanValue()) {
                throw new MetaException("Embedded metastore is not allowed here. Please configure " + MetastoreConf.ConfVars.THRIFT_URIS.toString() + "; it is currently set to [" + msUri + "]");
            }
            this.client = HiveMetaStore.newRetryingHMSHandler("hive client", this.conf, true);
            MaterializationsInvalidationCache.get().init(conf, (IHMSHandler)this.client);
            this.isConnected = true;
            this.snapshotActiveConf();
            return;
        }
        this.retries = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES);
        this.retryDelaySeconds = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.CLIENT_CONNECT_RETRY_DELAY, TimeUnit.SECONDS);
        if (MetastoreConf.getVar(conf, MetastoreConf.ConfVars.THRIFT_URIS) == null) {
            LOG.error("NOT getting uris from conf");
            throw new MetaException("MetaStoreURIs not found in conf file");
        }
        this.resolveUris();
        String HADOOP_PROXY_USER = "HADOOP_PROXY_USER";
        String proxyUser = System.getenv(HADOOP_PROXY_USER);
        if (proxyUser == null) {
            proxyUser = System.getProperty(HADOOP_PROXY_USER);
        }
        if (proxyUser != null) {
            LOG.info(HADOOP_PROXY_USER + " is set. Using delegation token for HiveMetaStore connection.");
            try {
                UserGroupInformation.getLoginUser().getRealUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        HiveMetaStoreClient.this.open();
                        return null;
                    }
                });
                String delegationTokenPropString = "DelegationTokenForHiveMetaStoreServer";
                String delegationTokenStr = this.getDelegationToken(proxyUser, proxyUser);
                SecurityUtils.setTokenStr(UserGroupInformation.getCurrentUser(), delegationTokenStr, delegationTokenPropString);
                MetastoreConf.setVar(this.conf, MetastoreConf.ConfVars.TOKEN_SIGNATURE, delegationTokenPropString);
                this.close();
            }
            catch (Exception e) {
                LOG.error("Error while setting delegation token for " + proxyUser, (Throwable)e);
                if (e instanceof MetaException) {
                    throw (MetaException)((Object)e);
                }
                throw new MetaException(e.getMessage());
            }
        }
        this.open();
    }

    private void resolveUris() throws MetaException {
        String[] metastoreUrisString = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.THRIFT_URIS).split(",");
        ArrayList<URI> metastoreURIArray = new ArrayList<URI>();
        try {
            boolean i = false;
            for (String s : metastoreUrisString) {
                URI tmpUri = new URI(s);
                if (tmpUri.getScheme() == null) {
                    throw new IllegalArgumentException("URI: " + s + " does not have a scheme");
                }
                if (this.uriResolverHook != null) {
                    metastoreURIArray.addAll(this.uriResolverHook.resolveURI(tmpUri));
                    continue;
                }
                metastoreURIArray.add(new URI(tmpUri.getScheme(), tmpUri.getUserInfo(), HadoopThriftAuthBridge.getBridge().getCanonicalHostName(tmpUri.getHost()), tmpUri.getPort(), tmpUri.getPath(), tmpUri.getQuery(), tmpUri.getFragment()));
            }
            this.metastoreUris = new URI[metastoreURIArray.size()];
            for (int j = 0; j < metastoreURIArray.size(); ++j) {
                this.metastoreUris[j] = (URI)metastoreURIArray.get(j);
            }
            if (MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.THRIFT_URI_SELECTION).equalsIgnoreCase("RANDOM")) {
                List<URI> uriList = Arrays.asList(this.metastoreUris);
                Collections.shuffle(uriList);
                this.metastoreUris = (URI[])uriList.toArray();
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
        }
    }

    private MetaStoreFilterHook loadFilterHooks() throws IllegalStateException {
        Class<MetaStoreFilterHook> authProviderClass = MetastoreConf.getClass(this.conf, MetastoreConf.ConfVars.FILTER_HOOK, DefaultMetaStoreFilterHookImpl.class, MetaStoreFilterHook.class);
        String msg = "Unable to create instance of " + authProviderClass.getName() + ": ";
        try {
            Constructor<MetaStoreFilterHook> constructor = authProviderClass.getConstructor(Configuration.class);
            return constructor.newInstance(this.conf);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
    }

    private synchronized URIResolverHook loadUriResolverHook() throws IllegalStateException {
        String uriResolverClassName = MetastoreConf.getAsString(this.conf, MetastoreConf.ConfVars.URI_RESOLVER);
        if (uriResolverClassName.equals("")) {
            return null;
        }
        LOG.info("Loading uri resolver" + uriResolverClassName);
        try {
            Class<?> uriResolverClass = Class.forName(uriResolverClassName, true, JavaUtils.getClassLoader());
            return (URIResolverHook)ReflectionUtils.newInstance(uriResolverClass, null);
        }
        catch (Exception e) {
            LOG.error("Exception loading uri resolver hook" + e);
            return null;
        }
    }

    private void promoteRandomMetaStoreURI() {
        if (this.metastoreUris.length <= 1) {
            return;
        }
        Random rng = new Random();
        int index = rng.nextInt(this.metastoreUris.length - 1) + 1;
        URI tmp = this.metastoreUris[0];
        this.metastoreUris[0] = this.metastoreUris[index];
        this.metastoreUris[index] = tmp;
    }

    @VisibleForTesting
    public TTransport getTTransport() {
        return this.transport;
    }

    @Override
    public boolean isLocalMetaStore() {
        return this.localMetaStore;
    }

    @Override
    public boolean isCompatibleWith(Configuration conf) {
        Map<String, String> currentMetaVarsCopy = this.currentMetaVars;
        if (currentMetaVarsCopy == null) {
            return false;
        }
        boolean compatible = true;
        for (MetastoreConf.ConfVars oneVar : MetastoreConf.metaVars) {
            String oldVar = currentMetaVarsCopy.get(oneVar.getVarname());
            String newVar = MetastoreConf.getAsString(conf, oneVar);
            if (oldVar != null && !(oneVar.isCaseSensitive() ? !oldVar.equals(newVar) : !oldVar.equalsIgnoreCase(newVar))) continue;
            LOG.info("Mestastore configuration " + oneVar.toString() + " changed from " + oldVar + " to " + newVar);
            compatible = false;
        }
        return compatible;
    }

    @Override
    public void setHiveAddedJars(String addedJars) {
        MetastoreConf.setVar(this.conf, MetastoreConf.ConfVars.ADDED_JARS, addedJars);
    }

    @Override
    public void reconnect() throws MetaException {
        if (this.localMetaStore) {
            throw new MetaException("For direct MetaStore DB connections, we don't support retries at the client level.");
        }
        this.close();
        if (this.uriResolverHook != null) {
            this.resolveUris();
        }
        if (MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.THRIFT_URI_SELECTION).equalsIgnoreCase("RANDOM")) {
            this.promoteRandomMetaStoreURI();
        }
        this.open();
    }

    @Override
    public void alter_table(String dbname, String tbl_name, Table new_tbl) throws TException {
        this.alter_table_with_environmentContext(dbname, tbl_name, new_tbl, null);
    }

    @Override
    public void alter_table(String defaultDatabaseName, String tblName, Table table, boolean cascade) throws TException {
        EnvironmentContext environmentContext = new EnvironmentContext();
        if (cascade) {
            environmentContext.putToProperties("CASCADE", "true");
        }
        this.alter_table_with_environmentContext(defaultDatabaseName, tblName, table, environmentContext);
    }

    @Override
    public void alter_table_with_environmentContext(String dbname, String tbl_name, Table new_tbl, EnvironmentContext envContext) throws InvalidOperationException, MetaException, TException {
        HiveMetaHook hook = this.getHook(new_tbl);
        if (hook != null) {
            hook.preAlterTable(new_tbl, envContext);
        }
        this.client.alter_table_with_environment_context(MetaStoreUtils.prependCatalogToDbName(dbname, this.conf), tbl_name, new_tbl, envContext);
    }

    @Override
    public void alter_table(String catName, String dbName, String tblName, Table newTable, EnvironmentContext envContext) throws TException {
        this.client.alter_table_with_environment_context(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tblName, newTable, envContext);
    }

    @Override
    public void renamePartition(String dbname, String tableName, List<String> part_vals, Partition newPart) throws TException {
        this.renamePartition(MetaStoreUtils.getDefaultCatalog(this.conf), dbname, tableName, part_vals, newPart);
    }

    @Override
    public void renamePartition(String catName, String dbname, String tableName, List<String> part_vals, Partition newPart) throws TException {
        this.client.rename_partition(MetaStoreUtils.prependCatalogToDbName(catName, dbname, this.conf), tableName, part_vals, newPart);
    }

    private void open() throws MetaException {
        this.isConnected = false;
        TTransportException tte = null;
        boolean hopsTLS = this.conf.getBoolean("ipc.server.ssl.enabled", false);
        boolean useSasl = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.USE_THRIFT_SASL);
        boolean useFramedTransport = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.USE_THRIFT_FRAMED_TRANSPORT);
        boolean useCompactProtocol = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.USE_THRIFT_COMPACT_PROTOCOL);
        int clientSocketTimeout = (int)MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.CLIENT_SOCKET_TIMEOUT, TimeUnit.MILLISECONDS);
        HopsSecurityMaterial hopsSecurityMaterial = null;
        for (int attempt = 0; !this.isConnected && attempt < this.retries; ++attempt) {
            for (URI store : this.metastoreUris) {
                block31: {
                    LOG.info("Trying to connect to metastore with URI " + store);
                    try {
                        if (useSasl) {
                            try {
                                HadoopThriftAuthBridge.Client authBridge = HadoopThriftAuthBridge.getBridge().createClient();
                                String tokenSig = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.TOKEN_SIGNATURE);
                                this.tokenStrForm = SecurityUtils.getTokenStrForm(tokenSig);
                                if (this.tokenStrForm != null) {
                                    LOG.info("HMSC::open(): Found delegation token. Creating DIGEST-based thrift connection.");
                                    this.transport = authBridge.createClientTransport(null, store.getHost(), "DIGEST", this.tokenStrForm, this.transport, MetaStoreUtils.getMetaStoreSaslProperties(this.conf, false));
                                }
                                LOG.info("HMSC::open(): Could not find delegation token. Creating KERBEROS-based thrift connection.");
                                String principalConfig = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.KERBEROS_PRINCIPAL);
                                this.transport = authBridge.createClientTransport(principalConfig, store.getHost(), "KERBEROS", null, this.transport, MetaStoreUtils.getMetaStoreSaslProperties(this.conf, false));
                            }
                            catch (IOException ioe) {
                                LOG.error("Couldn't create client transport", (Throwable)ioe);
                                throw new MetaException(ioe.toString());
                            }
                        } else {
                            if (hopsTLS) {
                                try {
                                    hopsSecurityMaterial = this.getHopsSecurityMaterial();
                                    TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
                                    params.setTrustStore(hopsSecurityMaterial.getTrustStorePath(), hopsSecurityMaterial.getTrustStorePassword());
                                    params.setKeyStore(hopsSecurityMaterial.getKeyStorePath(), hopsSecurityMaterial.getKeyStorePassword());
                                    this.transport = TSSLTransportFactory.getClientSocket((String)store.getHost(), (int)store.getPort(), (int)clientSocketTimeout, (TSSLTransportFactory.TSSLTransportParameters)params);
                                }
                                catch (IOException | LoginException e) {
                                    throw new MetaException(e.toString());
                                }
                                catch (TTransportException e) {
                                    tte = e;
                                    throw new MetaException(e.toString());
                                }
                            } else {
                                this.transport = new TSocket(store.getHost(), store.getPort(), clientSocketTimeout);
                            }
                            if (useFramedTransport) {
                                this.transport = new TFramedTransport(this.transport);
                            }
                        }
                        Object protocol = useCompactProtocol ? new TCompactProtocol(this.transport) : new TBinaryProtocol(this.transport);
                        this.client = new ThriftHiveMetastore.Client((TProtocol)protocol);
                        try {
                            if (!this.transport.isOpen()) {
                                this.transport.open();
                                LOG.info("Opened a connection to metastore, current connections: " + connCount.incrementAndGet());
                            }
                            this.isConnected = true;
                        }
                        catch (TTransportException e) {
                            tte = e;
                            if (LOG.isDebugEnabled()) {
                                LOG.warn("Failed to connect to the MetaStore Server...", (Throwable)e);
                            }
                            LOG.warn("Failed to connect to the MetaStore Server...");
                        }
                        if (this.isConnected && !useSasl && MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.EXECUTE_SET_UGI)) {
                            try {
                                UserGroupInformation ugi = SecurityUtils.getUGI();
                                this.client.set_ugi(ugi.getUserName(), new ArrayList<String>());
                            }
                            catch (LoginException e) {
                                LOG.warn("Failed to do login. set_ugi() is not successful, Continuing without it.", (Throwable)e);
                            }
                            catch (IOException e) {
                                LOG.warn("Failed to find ugi of client set_ugi() is not successful, Continuing without it.", (Throwable)e);
                            }
                            catch (TTransportException e) {
                                tte = e;
                                this.isConnected = false;
                            }
                            catch (TException e) {
                                tte = new TTransportException(e.getCause());
                                this.isConnected = false;
                            }
                        }
                        if (!this.isConnected || !hopsTLS) break block31;
                        try {
                            String username = UserGroupInformation.getCurrentUser().getUserName();
                            if (!username.equals(MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.HIVE_SUPER_USER))) {
                                this.client.set_crypto(hopsSecurityMaterial.getKeyStore(), hopsSecurityMaterial.getKeyStorePassword(), hopsSecurityMaterial.getTrustStore(), hopsSecurityMaterial.getTrustStorePassword(), false);
                            }
                        }
                        catch (IOException | TException e) {
                            tte = new TTransportException(e.getCause());
                            LOG.error("set_crypto() not successful", e);
                            throw new MetaException(e.getMessage());
                        }
                    }
                    catch (MetaException e) {
                        LOG.error("Unable to connect to metastore with URI " + store + " in attempt " + attempt, (Throwable)((Object)e));
                    }
                }
                if (this.isConnected) break;
            }
            if (this.isConnected || this.retryDelaySeconds <= 0L) continue;
            try {
                LOG.info("Waiting " + this.retryDelaySeconds + " seconds before next connection attempt.");
                Thread.sleep(this.retryDelaySeconds * 1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.isConnected) {
            throw new MetaException("Could not connect to meta store using any of the URIs provided. Most recent failure: " + org.apache.hadoop.util.StringUtils.stringifyException(tte));
        }
        this.snapshotActiveConf();
        LOG.info("Connected to metastore.");
    }

    private HopsSecurityMaterial getHopsSecurityMaterial() throws IOException, LoginException, MetaException {
        String username = UserGroupInformation.getCurrentUser().getUserName();
        HopsSecurityMaterial securityMaterial = username.equals(MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.HIVE_SUPER_USER)) ? this.getMaterialForSuperuser() : this.getMaterialForUser(username);
        return securityMaterial;
    }

    private HopsSecurityMaterial getMaterialForSuperuser() {
        return new HopsSecurityMaterial(CertificateLocalizationCtx.getInstance().getCertificateLocalization().getSuperKeystoreLocation(), null, CertificateLocalizationCtx.getInstance().getCertificateLocalization().getSuperKeystorePass(), CertificateLocalizationCtx.getInstance().getCertificateLocalization().getSuperTruststoreLocation(), null, CertificateLocalizationCtx.getInstance().getCertificateLocalization().getSuperKeyPassword());
    }

    private HopsSecurityMaterial getMaterialForUser(String username) throws IOException, MetaException {
        HopsSecurityMaterial securityMaterial = null;
        if (CertificateLocalizationCtx.getInstance().getCertificateLocalization() != null) {
            try {
                securityMaterial = this.readFromCertLocService(username);
            }
            catch (InterruptedException e) {
                throw new MetaException(e.toString());
            }
            catch (FileNotFoundException e) {
                securityMaterial = this.readClientMaterial();
                this.clientCertUpdaterThread = new Thread(new ClientCertUpdater(this.client, securityMaterial));
                this.clientCertUpdaterThread.start();
            }
        } else {
            securityMaterial = this.readClientMaterial();
            this.clientCertUpdaterThread = new Thread(new ClientCertUpdater(this.client, securityMaterial));
            this.clientCertUpdaterThread.start();
        }
        return securityMaterial;
    }

    private HopsSecurityMaterial readFromCertLocService(String username) throws InterruptedException, FileNotFoundException {
        X509SecurityMaterial userCryptoMaterial = CertificateLocalizationCtx.getInstance().getCertificateLocalization().getX509MaterialLocation(username);
        return new HopsSecurityMaterial(userCryptoMaterial.getKeyStoreLocation().toString(), userCryptoMaterial.getKeyStoreMem(), userCryptoMaterial.getKeyStorePass(), userCryptoMaterial.getTrustStoreLocation().toString(), userCryptoMaterial.getTrustStoreMem(), userCryptoMaterial.getTrustStorePass());
    }

    private HopsSecurityMaterial readClientMaterial() throws IOException {
        String key = FileUtils.readFileToString((File)new File("material_passwd"));
        ByteBuffer keyStore = ByteBuffer.wrap(FileUtils.readFileToByteArray((File)new File("k_certificate")));
        ByteBuffer trustStore = ByteBuffer.wrap(FileUtils.readFileToByteArray((File)new File("t_certificate")));
        return new HopsSecurityMaterial("k_certificate", keyStore, key, "t_certificate", trustStore, key);
    }

    private void snapshotActiveConf() {
        this.currentMetaVars = new HashMap<String, String>(MetastoreConf.metaVars.length);
        for (MetastoreConf.ConfVars oneVar : MetastoreConf.metaVars) {
            this.currentMetaVars.put(oneVar.getVarname(), MetastoreConf.getAsString(this.conf, oneVar));
        }
    }

    @Override
    public String getTokenStrForm() throws IOException {
        return this.tokenStrForm;
    }

    @Override
    public void close() {
        this.isConnected = false;
        this.currentMetaVars = null;
        try {
            if (this.clientCertUpdaterThread != null) {
                this.clientCertUpdaterThread.interrupt();
            }
            if (null != this.client) {
                this.client.shutdown();
            }
        }
        catch (TException e) {
            LOG.debug("Unable to shutdown metastore client. Will try closing transport directly.", (Throwable)e);
        }
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
            LOG.info("Closed a connection to metastore, current connections: " + connCount.decrementAndGet());
        }
    }

    @Override
    public void setMetaConf(String key, String value) throws TException {
        this.client.setMetaConf(key, value);
    }

    @Override
    public String getMetaConf(String key) throws TException {
        return this.client.getMetaConf(key);
    }

    @Override
    public void createCatalog(Catalog catalog) throws TException {
        this.client.create_catalog(new CreateCatalogRequest(catalog));
    }

    @Override
    public Catalog getCatalog(String catName) throws TException {
        GetCatalogResponse rsp = this.client.get_catalog(new GetCatalogRequest(catName));
        return rsp == null ? null : this.filterHook.filterCatalog(rsp.getCatalog());
    }

    @Override
    public List<String> getCatalogs() throws TException {
        GetCatalogsResponse rsp = this.client.get_catalogs();
        return rsp == null ? null : this.filterHook.filterCatalogs(rsp.getNames());
    }

    @Override
    public void dropCatalog(String catName) throws TException {
        this.client.drop_catalog(new DropCatalogRequest(catName));
    }

    @Override
    public Partition add_partition(Partition new_part) throws TException {
        return this.add_partition(new_part, null);
    }

    public Partition add_partition(Partition new_part, EnvironmentContext envContext) throws TException {
        if (!new_part.isSetCatName()) {
            new_part.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        Partition p = this.client.add_partition_with_environment_context(new_part, envContext);
        return this.deepCopy(p);
    }

    @Override
    public int add_partitions(List<Partition> new_parts) throws TException {
        if (new_parts != null && !new_parts.isEmpty() && !new_parts.get(0).isSetCatName()) {
            String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
            new_parts.forEach(p -> p.setCatName(defaultCat));
        }
        return this.client.add_partitions(new_parts);
    }

    @Override
    public List<Partition> add_partitions(List<Partition> parts, boolean ifNotExists, boolean needResults) throws TException {
        if (parts.isEmpty()) {
            return needResults ? new ArrayList() : null;
        }
        Partition part = parts.get(0);
        if (!part.isSetCatName()) {
            String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
            parts.forEach(p -> p.setCatName(defaultCat));
        }
        AddPartitionsRequest req = new AddPartitionsRequest(part.getDbName(), part.getTableName(), parts, ifNotExists);
        req.setCatName(part.isSetCatName() ? part.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf));
        req.setNeedResult(needResults);
        AddPartitionsResult result = this.client.add_partitions_req(req);
        return needResults ? this.filterHook.filterPartitions(result.getPartitions()) : null;
    }

    @Override
    public int add_partitions_pspec(PartitionSpecProxy partitionSpec) throws TException {
        if (partitionSpec.getCatName() == null) {
            partitionSpec.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.add_partitions_pspec(partitionSpec.toPartitionSpec());
    }

    @Override
    public Partition appendPartition(String db_name, String table_name, List<String> part_vals) throws TException {
        return this.appendPartition(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, table_name, part_vals);
    }

    @Override
    public Partition appendPartition(String dbName, String tableName, String partName) throws TException {
        return this.appendPartition(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, partName);
    }

    @Override
    public Partition appendPartition(String catName, String dbName, String tableName, String name) throws TException {
        Partition p = this.client.append_partition_by_name(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tableName, name);
        return this.deepCopy(p);
    }

    @Override
    public Partition appendPartition(String catName, String dbName, String tableName, List<String> partVals) throws TException {
        Partition p = this.client.append_partition(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tableName, partVals);
        return this.deepCopy(p);
    }

    @Deprecated
    public Partition appendPartition(String dbName, String tableName, List<String> partVals, EnvironmentContext ec) throws TException {
        return this.client.append_partition_with_environment_context(MetaStoreUtils.prependCatalogToDbName(dbName, this.conf), tableName, partVals, ec).deepCopy();
    }

    @Override
    public Partition exchange_partition(Map<String, String> partitionSpecs, String sourceDb, String sourceTable, String destDb, String destinationTableName) throws TException {
        return this.exchange_partition(partitionSpecs, MetaStoreUtils.getDefaultCatalog(this.conf), sourceDb, sourceTable, MetaStoreUtils.getDefaultCatalog(this.conf), destDb, destinationTableName);
    }

    @Override
    public Partition exchange_partition(Map<String, String> partitionSpecs, String sourceCat, String sourceDb, String sourceTable, String destCat, String destDb, String destTableName) throws TException {
        return this.client.exchange_partition(partitionSpecs, MetaStoreUtils.prependCatalogToDbName(sourceCat, sourceDb, this.conf), sourceTable, MetaStoreUtils.prependCatalogToDbName(destCat, destDb, this.conf), destTableName);
    }

    @Override
    public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceDb, String sourceTable, String destDb, String destinationTableName) throws TException {
        return this.exchange_partitions(partitionSpecs, MetaStoreUtils.getDefaultCatalog(this.conf), sourceDb, sourceTable, MetaStoreUtils.getDefaultCatalog(this.conf), destDb, destinationTableName);
    }

    @Override
    public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceCat, String sourceDb, String sourceTable, String destCat, String destDb, String destTableName) throws TException {
        return this.client.exchange_partitions(partitionSpecs, MetaStoreUtils.prependCatalogToDbName(sourceCat, sourceDb, this.conf), sourceTable, MetaStoreUtils.prependCatalogToDbName(destCat, destDb, this.conf), destTableName);
    }

    @Override
    public void validatePartitionNameCharacters(List<String> partVals) throws TException, MetaException {
        this.client.partition_name_has_valid_characters(partVals, true);
    }

    @Override
    public void createDatabase(Database db) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        if (!db.isSetCatalogName()) {
            db.setCatalogName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        this.client.create_database(db);
    }

    @Override
    public void createTable(Table tbl) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.createTable(tbl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable(Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        HiveMetaHook hook;
        if (!tbl.isSetCatName()) {
            tbl.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        if ((hook = this.getHook(tbl)) != null) {
            hook.preCreateTable(tbl);
        }
        boolean success = false;
        try {
            this.create_table_with_environment_context(tbl, envContext);
            if (hook != null) {
                hook.commitCreateTable(tbl);
            }
            success = true;
        }
        finally {
            if (!success && hook != null) {
                try {
                    hook.rollbackCreateTable(tbl);
                }
                catch (Exception e) {
                    LOG.error("Create rollback failed with", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTableWithConstraints(Table tbl, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        HiveMetaHook hook;
        if (!tbl.isSetCatName()) {
            String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
            tbl.setCatName(defaultCat);
            if (primaryKeys != null) {
                primaryKeys.forEach(pk -> pk.setCatName(defaultCat));
            }
            if (foreignKeys != null) {
                foreignKeys.forEach(fk -> fk.setCatName(defaultCat));
            }
            if (uniqueConstraints != null) {
                uniqueConstraints.forEach(uc -> uc.setCatName(defaultCat));
            }
            if (notNullConstraints != null) {
                notNullConstraints.forEach(nn -> nn.setCatName(defaultCat));
            }
            if (defaultConstraints != null) {
                defaultConstraints.forEach(def -> def.setCatName(defaultCat));
            }
            if (checkConstraints != null) {
                checkConstraints.forEach(cc -> cc.setCatName(defaultCat));
            }
        }
        if ((hook = this.getHook(tbl)) != null) {
            hook.preCreateTable(tbl);
        }
        boolean success = false;
        try {
            this.client.create_table_with_constraints(tbl, primaryKeys, foreignKeys, uniqueConstraints, notNullConstraints, defaultConstraints, checkConstraints);
            if (hook != null) {
                hook.commitCreateTable(tbl);
            }
            success = true;
        }
        finally {
            if (!success && hook != null) {
                hook.rollbackCreateTable(tbl);
            }
        }
    }

    @Override
    public void dropConstraint(String dbName, String tableName, String constraintName) throws TException {
        this.dropConstraint(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, constraintName);
    }

    @Override
    public void dropConstraint(String catName, String dbName, String tableName, String constraintName) throws TException {
        DropConstraintRequest rqst = new DropConstraintRequest(dbName, tableName, constraintName);
        rqst.setCatName(catName);
        this.client.drop_constraint(rqst);
    }

    @Override
    public void addPrimaryKey(List<SQLPrimaryKey> primaryKeyCols) throws TException {
        if (!primaryKeyCols.isEmpty() && !primaryKeyCols.get(0).isSetCatName()) {
            String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
            primaryKeyCols.forEach(pk -> pk.setCatName(defaultCat));
        }
        this.client.add_primary_key(new AddPrimaryKeyRequest(primaryKeyCols));
    }

    @Override
    public void addForeignKey(List<SQLForeignKey> foreignKeyCols) throws TException {
        if (!foreignKeyCols.isEmpty() && !foreignKeyCols.get(0).isSetCatName()) {
            String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
            foreignKeyCols.forEach(fk -> fk.setCatName(defaultCat));
        }
        this.client.add_foreign_key(new AddForeignKeyRequest(foreignKeyCols));
    }

    @Override
    public void addUniqueConstraint(List<SQLUniqueConstraint> uniqueConstraintCols) throws NoSuchObjectException, MetaException, TException {
        if (!uniqueConstraintCols.isEmpty() && !uniqueConstraintCols.get(0).isSetCatName()) {
            String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
            uniqueConstraintCols.forEach(uc -> uc.setCatName(defaultCat));
        }
        this.client.add_unique_constraint(new AddUniqueConstraintRequest(uniqueConstraintCols));
    }

    @Override
    public void addNotNullConstraint(List<SQLNotNullConstraint> notNullConstraintCols) throws NoSuchObjectException, MetaException, TException {
        if (!notNullConstraintCols.isEmpty() && !notNullConstraintCols.get(0).isSetCatName()) {
            String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
            notNullConstraintCols.forEach(nn -> nn.setCatName(defaultCat));
        }
        this.client.add_not_null_constraint(new AddNotNullConstraintRequest(notNullConstraintCols));
    }

    @Override
    public void addDefaultConstraint(List<SQLDefaultConstraint> defaultConstraints) throws NoSuchObjectException, MetaException, TException {
        if (!defaultConstraints.isEmpty() && !defaultConstraints.get(0).isSetCatName()) {
            String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
            defaultConstraints.forEach(def -> def.setCatName(defaultCat));
        }
        this.client.add_default_constraint(new AddDefaultConstraintRequest(defaultConstraints));
    }

    @Override
    public void addCheckConstraint(List<SQLCheckConstraint> checkConstraints) throws NoSuchObjectException, MetaException, TException {
        if (!checkConstraints.isEmpty() && !checkConstraints.get(0).isSetCatName()) {
            String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
            checkConstraints.forEach(cc -> cc.setCatName(defaultCat));
        }
        this.client.add_check_constraint(new AddCheckConstraintRequest(checkConstraints));
    }

    public boolean createType(Type type) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        return this.client.create_type(type);
    }

    @Override
    public void dropDatabase(String name) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(MetaStoreUtils.getDefaultCatalog(this.conf), name, true, false, false);
    }

    @Override
    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(MetaStoreUtils.getDefaultCatalog(this.conf), name, deleteData, ignoreUnknownDb, false);
    }

    @Override
    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(MetaStoreUtils.getDefaultCatalog(this.conf), name, deleteData, ignoreUnknownDb, cascade);
    }

    @Override
    public void dropDatabase(String catalogName, String dbName, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        try {
            this.getDatabase(catalogName, dbName);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownDb) {
                throw e;
            }
            return;
        }
        if (cascade) {
            List<String> materializedViews = this.getTables(dbName, ".*", TableType.MATERIALIZED_VIEW);
            for (String table : materializedViews) {
                this.dropTable(dbName, table, deleteData, true);
            }
            List<String> tableList = this.getAllTables(dbName);
            for (String table : tableList) {
                try {
                    this.dropTable(dbName, table, deleteData, true);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }
        this.client.drop_database(MetaStoreUtils.prependCatalogToDbName(catalogName, dbName, this.conf), deleteData, cascade);
    }

    @Override
    public boolean dropPartition(String dbName, String tableName, String partName, boolean deleteData) throws TException {
        return this.dropPartition(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, partName, deleteData);
    }

    @Override
    public boolean dropPartition(String catName, String db_name, String tbl_name, String name, boolean deleteData) throws TException {
        return this.client.drop_partition_by_name_with_environment_context(MetaStoreUtils.prependCatalogToDbName(catName, db_name, this.conf), tbl_name, name, deleteData, null);
    }

    private static EnvironmentContext getEnvironmentContextWithIfPurgeSet() {
        HashMap<String, String> warehouseOptions = new HashMap<String, String>();
        warehouseOptions.put("ifPurge", "TRUE");
        return new EnvironmentContext(warehouseOptions);
    }

    @Deprecated
    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, EnvironmentContext env_context) throws TException {
        return this.client.drop_partition_with_environment_context(MetaStoreUtils.prependCatalogToDbName(db_name, this.conf), tbl_name, part_vals, true, env_context);
    }

    @Deprecated
    public boolean dropPartition(String dbName, String tableName, String partName, boolean dropData, EnvironmentContext ec) throws TException {
        return this.client.drop_partition_by_name_with_environment_context(MetaStoreUtils.prependCatalogToDbName(dbName, this.conf), tableName, partName, dropData, ec);
    }

    @Deprecated
    public boolean dropPartition(String dbName, String tableName, List<String> partVals) throws TException {
        return this.client.drop_partition(MetaStoreUtils.prependCatalogToDbName(dbName, this.conf), tableName, partVals, true);
    }

    @Override
    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws TException {
        return this.dropPartition(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, part_vals, PartitionDropOptions.instance().deleteData(deleteData));
    }

    @Override
    public boolean dropPartition(String catName, String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws TException {
        return this.dropPartition(catName, db_name, tbl_name, part_vals, PartitionDropOptions.instance().deleteData(deleteData));
    }

    @Override
    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, PartitionDropOptions options) throws TException {
        return this.dropPartition(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, part_vals, options);
    }

    @Override
    public boolean dropPartition(String catName, String db_name, String tbl_name, List<String> part_vals, PartitionDropOptions options) throws TException {
        if (options == null) {
            options = PartitionDropOptions.instance();
        }
        if (part_vals != null) {
            for (String partVal : part_vals) {
                if (partVal != null) continue;
                throw new MetaException("The partition value must not be null.");
            }
        }
        return this.client.drop_partition_with_environment_context(MetaStoreUtils.prependCatalogToDbName(catName, db_name, this.conf), tbl_name, part_vals, options.deleteData, options.purgeData ? HiveMetaStoreClient.getEnvironmentContextWithIfPurgeSet() : null);
    }

    @Override
    public List<Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, PartitionDropOptions options) throws TException {
        return this.dropPartitions(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tblName, partExprs, options);
    }

    @Override
    public List<Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists, boolean needResult) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartitions(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tblName, partExprs, PartitionDropOptions.instance().deleteData(deleteData).ifExists(ifExists).returnResults(needResult));
    }

    @Override
    public List<Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartitions(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tblName, partExprs, PartitionDropOptions.instance().deleteData(deleteData).ifExists(ifExists));
    }

    @Override
    public List<Partition> dropPartitions(String catName, String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, PartitionDropOptions options) throws TException {
        RequestPartsSpec rps = new RequestPartsSpec();
        ArrayList<DropPartitionsExpr> exprs = new ArrayList<DropPartitionsExpr>(partExprs.size());
        for (ObjectPair<Integer, byte[]> partExpr : partExprs) {
            DropPartitionsExpr dpe = new DropPartitionsExpr();
            dpe.setExpr(partExpr.getSecond());
            dpe.setPartArchiveLevel(partExpr.getFirst());
            exprs.add(dpe);
        }
        rps.setExprs(exprs);
        DropPartitionsRequest req = new DropPartitionsRequest(dbName, tblName, rps);
        req.setCatName(catName);
        req.setDeleteData(options.deleteData);
        req.setNeedResult(options.returnResults);
        req.setIfExists(options.ifExists);
        if (options.purgeData) {
            LOG.info("Dropped partitions will be purged!");
            req.setEnvironmentContext(HiveMetaStoreClient.getEnvironmentContextWithIfPurgeSet());
        }
        return this.client.drop_partitions_req(req).getPartitions();
    }

    @Override
    public void dropTable(String dbname, String name, boolean deleteData, boolean ignoreUnknownTab) throws MetaException, TException, NoSuchObjectException, UnsupportedOperationException {
        this.dropTable(MetaStoreUtils.getDefaultCatalog(this.conf), dbname, name, deleteData, ignoreUnknownTab, null);
    }

    @Override
    public void dropTable(String dbname, String name, boolean deleteData, boolean ignoreUnknownTab, boolean ifPurge) throws TException {
        this.dropTable(MetaStoreUtils.getDefaultCatalog(this.conf), dbname, name, deleteData, ignoreUnknownTab, ifPurge);
    }

    @Override
    public void dropTable(String dbname, String name) throws TException {
        this.dropTable(MetaStoreUtils.getDefaultCatalog(this.conf), dbname, name, true, true, null);
    }

    @Override
    public void dropTable(String catName, String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTable, boolean ifPurge) throws TException {
        EnvironmentContext envContext = null;
        if (ifPurge) {
            HashMap<String, String> warehouseOptions = new HashMap<String, String>();
            warehouseOptions.put("ifPurge", "TRUE");
            envContext = new EnvironmentContext(warehouseOptions);
        }
        this.dropTable(catName, dbName, tableName, deleteData, ignoreUnknownTable, envContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable(String catName, String dbname, String name, boolean deleteData, boolean ignoreUnknownTab, EnvironmentContext envContext) throws MetaException, TException, NoSuchObjectException, UnsupportedOperationException {
        Table tbl;
        try {
            tbl = this.getTable(catName, dbname, name);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownTab) {
                throw e;
            }
            return;
        }
        HiveMetaHook hook = this.getHook(tbl);
        if (hook != null) {
            hook.preDropTable(tbl);
        }
        boolean success = false;
        try {
            this.drop_table_with_environment_context(catName, dbname, name, deleteData, envContext);
            if (hook != null) {
                hook.commitDropTable(tbl, deleteData || envContext != null && "TRUE".equals(envContext.getProperties().get("ifPurge")));
            }
            success = true;
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownTab) {
                throw e;
            }
        }
        finally {
            if (!success && hook != null) {
                hook.rollbackDropTable(tbl);
            }
        }
    }

    @Override
    public void truncateTable(String dbName, String tableName, List<String> partNames) throws TException {
        this.truncateTable(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, partNames);
    }

    @Override
    public void truncateTable(String catName, String dbName, String tableName, List<String> partNames) throws TException {
        this.client.truncate_table(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tableName, partNames);
    }

    @Override
    public CmRecycleResponse recycleDirToCmPath(CmRecycleRequest request) throws MetaException, TException {
        return this.client.cm_recycle(request);
    }

    public boolean dropType(String type) throws NoSuchObjectException, MetaException, TException {
        return this.client.drop_type(type);
    }

    public Map<String, Type> getTypeAll(String name) throws MetaException, TException {
        LinkedHashMap<String, Type> result = null;
        Map<String, Type> fromClient = this.client.get_type_all(name);
        if (fromClient != null) {
            result = new LinkedHashMap<String, Type>();
            for (String key : fromClient.keySet()) {
                result.put(key, this.deepCopy(fromClient.get(key)));
            }
        }
        return result;
    }

    @Override
    public List<String> getDatabases(String databasePattern) throws TException {
        return this.getDatabases(MetaStoreUtils.getDefaultCatalog(this.conf), databasePattern);
    }

    @Override
    public List<String> getDatabases(String catName, String databasePattern) throws TException {
        return this.filterHook.filterDatabases(this.client.get_databases(MetaStoreUtils.prependCatalogToDbName(catName, databasePattern, this.conf)));
    }

    @Override
    public List<String> getAllDatabases() throws TException {
        return this.getAllDatabases(MetaStoreUtils.getDefaultCatalog(this.conf));
    }

    @Override
    public List<String> getAllDatabases(String catName) throws TException {
        return this.filterHook.filterDatabases(this.client.get_databases(MetaStoreUtils.prependCatalogToDbName(catName, null, this.conf)));
    }

    @Override
    public List<Partition> listPartitions(String db_name, String tbl_name, short max_parts) throws TException {
        return this.listPartitions(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, (int)max_parts);
    }

    @Override
    public List<Partition> listPartitions(String catName, String db_name, String tbl_name, int max_parts) throws TException {
        List<Partition> parts = this.client.get_partitions(MetaStoreUtils.prependCatalogToDbName(catName, db_name, this.conf), tbl_name, this.shrinkMaxtoShort(max_parts));
        return this.deepCopyPartitions(this.filterHook.filterPartitions(parts));
    }

    @Override
    public PartitionSpecProxy listPartitionSpecs(String dbName, String tableName, int maxParts) throws TException {
        return this.listPartitionSpecs(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, maxParts);
    }

    @Override
    public PartitionSpecProxy listPartitionSpecs(String catName, String dbName, String tableName, int maxParts) throws TException {
        return PartitionSpecProxy.Factory.get(this.filterHook.filterPartitionSpecs(this.client.get_partitions_pspec(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tableName, maxParts)));
    }

    @Override
    public List<Partition> listPartitions(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws TException {
        return this.listPartitions(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, part_vals, max_parts);
    }

    @Override
    public List<Partition> listPartitions(String catName, String db_name, String tbl_name, List<String> part_vals, int max_parts) throws TException {
        List<Partition> parts = this.client.get_partitions_ps(MetaStoreUtils.prependCatalogToDbName(catName, db_name, this.conf), tbl_name, part_vals, this.shrinkMaxtoShort(max_parts));
        return this.deepCopyPartitions(this.filterHook.filterPartitions(parts));
    }

    @Override
    public List<Partition> listPartitionsWithAuthInfo(String db_name, String tbl_name, short max_parts, String user_name, List<String> group_names) throws TException {
        return this.listPartitionsWithAuthInfo(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, (int)max_parts, user_name, group_names);
    }

    @Override
    public List<Partition> listPartitionsWithAuthInfo(String catName, String dbName, String tableName, int maxParts, String userName, List<String> groupNames) throws TException {
        List<Partition> parts = this.client.get_partitions_with_auth(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tableName, this.shrinkMaxtoShort(maxParts), userName, groupNames);
        return this.deepCopyPartitions(this.filterHook.filterPartitions(parts));
    }

    @Override
    public List<Partition> listPartitionsWithAuthInfo(String db_name, String tbl_name, List<String> part_vals, short max_parts, String user_name, List<String> group_names) throws TException {
        return this.listPartitionsWithAuthInfo(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, part_vals, max_parts, user_name, group_names);
    }

    @Override
    public List<Partition> listPartitionsWithAuthInfo(String catName, String dbName, String tableName, List<String> partialPvals, int maxParts, String userName, List<String> groupNames) throws TException {
        List<Partition> parts = this.client.get_partitions_ps_with_auth(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tableName, partialPvals, this.shrinkMaxtoShort(maxParts), userName, groupNames);
        return this.deepCopyPartitions(this.filterHook.filterPartitions(parts));
    }

    @Override
    public List<Partition> listPartitionsByFilter(String db_name, String tbl_name, String filter, short max_parts) throws TException {
        return this.listPartitionsByFilter(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, filter, max_parts);
    }

    @Override
    public List<Partition> listPartitionsByFilter(String catName, String db_name, String tbl_name, String filter, int max_parts) throws TException {
        List<Partition> parts = this.client.get_partitions_by_filter(MetaStoreUtils.prependCatalogToDbName(catName, db_name, this.conf), tbl_name, filter, this.shrinkMaxtoShort(max_parts));
        return this.deepCopyPartitions(this.filterHook.filterPartitions(parts));
    }

    @Override
    public PartitionSpecProxy listPartitionSpecsByFilter(String db_name, String tbl_name, String filter, int max_parts) throws TException {
        return this.listPartitionSpecsByFilter(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, filter, max_parts);
    }

    @Override
    public PartitionSpecProxy listPartitionSpecsByFilter(String catName, String db_name, String tbl_name, String filter, int max_parts) throws TException {
        return PartitionSpecProxy.Factory.get(this.filterHook.filterPartitionSpecs(this.client.get_part_specs_by_filter(MetaStoreUtils.prependCatalogToDbName(catName, db_name, this.conf), tbl_name, filter, max_parts)));
    }

    @Override
    public boolean listPartitionsByExpr(String db_name, String tbl_name, byte[] expr, String default_partition_name, short max_parts, List<Partition> result) throws TException {
        return this.listPartitionsByExpr(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, expr, default_partition_name, max_parts, result);
    }

    @Override
    public boolean listPartitionsByExpr(String catName, String db_name, String tbl_name, byte[] expr, String default_partition_name, int max_parts, List<Partition> result) throws TException {
        PartitionsByExprResult r;
        assert (result != null);
        PartitionsByExprRequest req = new PartitionsByExprRequest(db_name, tbl_name, ByteBuffer.wrap(expr));
        if (default_partition_name != null) {
            req.setDefaultPartitionName(default_partition_name);
        }
        if (max_parts >= 0) {
            req.setMaxParts(this.shrinkMaxtoShort(max_parts));
        }
        try {
            r = this.client.get_partitions_by_expr(req);
        }
        catch (TApplicationException te) {
            if (te.getType() != 1 && te.getType() != 3) {
                throw te;
            }
            throw new IMetaStoreClient.IncompatibleMetastoreException("Metastore doesn't support listPartitionsByExpr: " + te.getMessage());
        }
        r.setPartitions(this.filterHook.filterPartitions(r.getPartitions()));
        this.deepCopyPartitions(r.getPartitions(), result);
        return !r.isSetHasUnknownPartitions() || r.isHasUnknownPartitions();
    }

    @Override
    public Database getDatabase(String name) throws TException {
        return this.getDatabase(MetaStoreUtils.getDefaultCatalog(this.conf), name);
    }

    @Override
    public Database getDatabase(String catalogName, String databaseName) throws TException {
        Database d = this.client.get_database(MetaStoreUtils.prependCatalogToDbName(catalogName, databaseName, this.conf));
        return this.deepCopy(this.filterHook.filterDatabase(d));
    }

    @Override
    public Partition getPartition(String db_name, String tbl_name, List<String> part_vals) throws TException {
        return this.getPartition(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, part_vals);
    }

    @Override
    public Partition getPartition(String catName, String dbName, String tblName, List<String> partVals) throws TException {
        Partition p = this.client.get_partition(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tblName, partVals);
        return this.deepCopy(this.filterHook.filterPartition(p));
    }

    @Override
    public List<Partition> getPartitionsByNames(String db_name, String tbl_name, List<String> part_names) throws TException {
        return this.getPartitionsByNames(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, part_names);
    }

    @Override
    public List<Partition> getPartitionsByNames(String catName, String db_name, String tbl_name, List<String> part_names) throws TException {
        List<Partition> parts = this.client.get_partitions_by_names(MetaStoreUtils.prependCatalogToDbName(catName, db_name, this.conf), tbl_name, part_names);
        return this.deepCopyPartitions(this.filterHook.filterPartitions(parts));
    }

    @Override
    public PartitionValuesResponse listPartitionValues(PartitionValuesRequest request) throws MetaException, TException, NoSuchObjectException {
        if (!request.isSetCatName()) {
            request.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.get_partition_values(request);
    }

    @Override
    public Partition getPartitionWithAuthInfo(String db_name, String tbl_name, List<String> part_vals, String user_name, List<String> group_names) throws TException {
        return this.getPartitionWithAuthInfo(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, part_vals, user_name, group_names);
    }

    @Override
    public Partition getPartitionWithAuthInfo(String catName, String dbName, String tableName, List<String> pvals, String userName, List<String> groupNames) throws TException {
        Partition p = this.client.get_partition_with_auth(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tableName, pvals, userName, groupNames);
        return this.deepCopy(this.filterHook.filterPartition(p));
    }

    @Override
    public Table getTable(String dbname, String name) throws TException {
        return this.getTable(MetaStoreUtils.getDefaultCatalog(this.conf), dbname, name);
    }

    @Override
    public Table getTable(String catName, String dbName, String tableName) throws TException {
        GetTableRequest req = new GetTableRequest(dbName, tableName);
        req.setCatName(catName);
        req.setCapabilities(this.version);
        Table t = this.client.get_table_req(req).getTable();
        return this.deepCopy(this.filterHook.filterTable(t));
    }

    @Override
    public List<Table> getTableObjectsByName(String dbName, List<String> tableNames) throws TException {
        return this.getTableObjectsByName(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableNames);
    }

    @Override
    public List<Table> getTableObjectsByName(String catName, String dbName, List<String> tableNames) throws TException {
        GetTablesRequest req = new GetTablesRequest(dbName);
        req.setCatName(catName);
        req.setTblNames(tableNames);
        req.setCapabilities(this.version);
        List<Table> tabs = this.client.get_table_objects_by_name_req(req).getTables();
        return this.deepCopyTables(this.filterHook.filterTables(tabs));
    }

    @Override
    public Map<String, Materialization> getMaterializationsInvalidationInfo(String dbName, List<String> viewNames) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        return this.client.get_materialization_invalidation_info(dbName, this.filterHook.filterTableNames(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, viewNames));
    }

    @Override
    public void updateCreationMetadata(String dbName, String tableName, CreationMetadata cm) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        this.client.update_creation_metadata(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, cm);
    }

    @Override
    public void updateCreationMetadata(String catName, String dbName, String tableName, CreationMetadata cm) throws MetaException, TException {
        this.client.update_creation_metadata(catName, dbName, tableName, cm);
    }

    @Override
    public List<String> listTableNamesByFilter(String dbName, String filter, short maxTables) throws TException {
        return this.listTableNamesByFilter(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, filter, maxTables);
    }

    @Override
    public List<String> listTableNamesByFilter(String catName, String dbName, String filter, int maxTables) throws TException {
        return this.filterHook.filterTableNames(catName, dbName, this.client.get_table_names_by_filter(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), filter, this.shrinkMaxtoShort(maxTables)));
    }

    public Type getType(String name) throws NoSuchObjectException, MetaException, TException {
        return this.deepCopy(this.client.get_type(name));
    }

    @Override
    public List<String> getTables(String dbname, String tablePattern) throws MetaException {
        try {
            return this.getTables(MetaStoreUtils.getDefaultCatalog(this.conf), dbname, tablePattern);
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    @Override
    public List<String> getTables(String catName, String dbName, String tablePattern) throws TException {
        return this.filterHook.filterTableNames(catName, dbName, this.client.get_tables(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tablePattern));
    }

    @Override
    public List<String> getTables(String dbname, String tablePattern, TableType tableType) throws MetaException {
        try {
            return this.getTables(MetaStoreUtils.getDefaultCatalog(this.conf), dbname, tablePattern, tableType);
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    @Override
    public List<String> getTables(String catName, String dbName, String tablePattern, TableType tableType) throws TException {
        return this.filterHook.filterTableNames(catName, dbName, this.client.get_tables_by_type(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tablePattern, tableType.toString()));
    }

    @Override
    public List<String> getMaterializedViewsForRewriting(String dbName) throws TException {
        return this.getMaterializedViewsForRewriting(MetaStoreUtils.getDefaultCatalog(this.conf), dbName);
    }

    @Override
    public List<String> getMaterializedViewsForRewriting(String catName, String dbname) throws MetaException {
        try {
            return this.filterHook.filterTableNames(catName, dbname, this.client.get_materialized_views_for_rewriting(MetaStoreUtils.prependCatalogToDbName(catName, dbname, this.conf)));
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    @Override
    public List<TableMeta> getTableMeta(String dbPatterns, String tablePatterns, List<String> tableTypes) throws MetaException {
        try {
            return this.getTableMeta(MetaStoreUtils.getDefaultCatalog(this.conf), dbPatterns, tablePatterns, tableTypes);
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    @Override
    public List<TableMeta> getTableMeta(String catName, String dbPatterns, String tablePatterns, List<String> tableTypes) throws TException {
        return this.filterHook.filterTableMetas(this.client.get_table_meta(MetaStoreUtils.prependCatalogToDbName(catName, dbPatterns, this.conf), tablePatterns, tableTypes));
    }

    @Override
    public List<String> getAllTables(String dbname) throws MetaException {
        try {
            return this.getAllTables(MetaStoreUtils.getDefaultCatalog(this.conf), dbname);
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    @Override
    public List<String> getAllTables(String catName, String dbName) throws TException {
        return this.filterHook.filterTableNames(catName, dbName, this.client.get_all_tables(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf)));
    }

    @Override
    public boolean tableExists(String databaseName, String tableName) throws TException {
        return this.tableExists(MetaStoreUtils.getDefaultCatalog(this.conf), databaseName, tableName);
    }

    @Override
    public boolean tableExists(String catName, String dbName, String tableName) throws TException {
        try {
            GetTableRequest req = new GetTableRequest(dbName, tableName);
            req.setCatName(catName);
            req.setCapabilities(this.version);
            return this.filterHook.filterTable(this.client.get_table_req(req).getTable()) != null;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    @Override
    public List<String> listPartitionNames(String dbName, String tblName, short max) throws NoSuchObjectException, MetaException, TException {
        return this.listPartitionNames(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tblName, (int)max);
    }

    @Override
    public List<String> listPartitionNames(String catName, String dbName, String tableName, int maxParts) throws TException {
        return this.filterHook.filterPartitionNames(catName, dbName, tableName, this.client.get_partition_names(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tableName, this.shrinkMaxtoShort(maxParts)));
    }

    @Override
    public List<String> listPartitionNames(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws TException {
        return this.listPartitionNames(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, part_vals, max_parts);
    }

    @Override
    public List<String> listPartitionNames(String catName, String db_name, String tbl_name, List<String> part_vals, int max_parts) throws TException {
        return this.filterHook.filterPartitionNames(catName, db_name, tbl_name, this.client.get_partition_names_ps(MetaStoreUtils.prependCatalogToDbName(catName, db_name, this.conf), tbl_name, part_vals, this.shrinkMaxtoShort(max_parts)));
    }

    @Override
    public int getNumPartitionsByFilter(String db_name, String tbl_name, String filter) throws TException {
        return this.getNumPartitionsByFilter(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, filter);
    }

    @Override
    public int getNumPartitionsByFilter(String catName, String dbName, String tableName, String filter) throws TException {
        return this.client.get_num_partitions_by_filter(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tableName, filter);
    }

    @Override
    public void alter_partition(String dbName, String tblName, Partition newPart) throws InvalidOperationException, MetaException, TException {
        this.alter_partition(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tblName, newPart, null);
    }

    @Override
    public void alter_partition(String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.alter_partition(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tblName, newPart, environmentContext);
    }

    @Override
    public void alter_partition(String catName, String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext) throws TException {
        this.client.alter_partition_with_environment_context(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tblName, newPart, environmentContext);
    }

    @Override
    public void alter_partitions(String dbName, String tblName, List<Partition> newParts) throws TException {
        this.alter_partitions(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tblName, newParts, null);
    }

    @Override
    public void alter_partitions(String dbName, String tblName, List<Partition> newParts, EnvironmentContext environmentContext) throws TException {
        this.alter_partitions(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tblName, newParts, environmentContext);
    }

    @Override
    public void alter_partitions(String catName, String dbName, String tblName, List<Partition> newParts, EnvironmentContext environmentContext) throws TException {
        this.client.alter_partitions_with_environment_context(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tblName, newParts, environmentContext);
    }

    @Override
    public void alterDatabase(String dbName, Database db) throws TException {
        this.alterDatabase(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, db);
    }

    @Override
    public void alterDatabase(String catName, String dbName, Database newDb) throws TException {
        this.client.alter_database(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), newDb);
    }

    @Override
    public List<FieldSchema> getFields(String db, String tableName) throws TException {
        return this.getFields(MetaStoreUtils.getDefaultCatalog(this.conf), db, tableName);
    }

    @Override
    public List<FieldSchema> getFields(String catName, String db, String tableName) throws TException {
        List<FieldSchema> fields = this.client.get_fields(MetaStoreUtils.prependCatalogToDbName(catName, db, this.conf), tableName);
        return this.deepCopyFieldSchemas(fields);
    }

    @Override
    public List<SQLPrimaryKey> getPrimaryKeys(PrimaryKeysRequest req) throws TException {
        if (!req.isSetCatName()) {
            req.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.get_primary_keys(req).getPrimaryKeys();
    }

    @Override
    public List<SQLForeignKey> getForeignKeys(ForeignKeysRequest req) throws MetaException, NoSuchObjectException, TException {
        if (!req.isSetCatName()) {
            req.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.get_foreign_keys(req).getForeignKeys();
    }

    @Override
    public List<SQLUniqueConstraint> getUniqueConstraints(UniqueConstraintsRequest req) throws MetaException, NoSuchObjectException, TException {
        if (!req.isSetCatName()) {
            req.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.get_unique_constraints(req).getUniqueConstraints();
    }

    @Override
    public List<SQLNotNullConstraint> getNotNullConstraints(NotNullConstraintsRequest req) throws MetaException, NoSuchObjectException, TException {
        if (!req.isSetCatName()) {
            req.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.get_not_null_constraints(req).getNotNullConstraints();
    }

    @Override
    public List<SQLDefaultConstraint> getDefaultConstraints(DefaultConstraintsRequest req) throws MetaException, NoSuchObjectException, TException {
        if (!req.isSetCatName()) {
            req.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.get_default_constraints(req).getDefaultConstraints();
    }

    @Override
    public List<SQLCheckConstraint> getCheckConstraints(CheckConstraintsRequest req) throws MetaException, NoSuchObjectException, TException {
        if (!req.isSetCatName()) {
            req.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.get_check_constraints(req).getCheckConstraints();
    }

    @Override
    public boolean updateTableColumnStatistics(ColumnStatistics statsObj) throws TException {
        if (!statsObj.getStatsDesc().isSetCatName()) {
            statsObj.getStatsDesc().setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.update_table_column_statistics(statsObj);
    }

    @Override
    public boolean updatePartitionColumnStatistics(ColumnStatistics statsObj) throws TException {
        if (!statsObj.getStatsDesc().isSetCatName()) {
            statsObj.getStatsDesc().setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.update_partition_column_statistics(statsObj);
    }

    @Override
    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws TException {
        String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
        for (ColumnStatistics stats : request.getColStats()) {
            if (stats.getStatsDesc().isSetCatName()) continue;
            stats.getStatsDesc().setCatName(defaultCat);
        }
        return this.client.set_aggr_stats_for(request);
    }

    @Override
    public void flushCache() {
        try {
            this.client.flushCache();
        }
        catch (TException e) {
            LOG.warn("Got error flushing the cache", (Throwable)e);
        }
    }

    @Override
    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames) throws TException {
        return this.getTableColumnStatistics(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, colNames);
    }

    @Override
    public List<ColumnStatisticsObj> getTableColumnStatistics(String catName, String dbName, String tableName, List<String> colNames) throws TException {
        TableStatsRequest rqst = new TableStatsRequest(dbName, tableName, colNames);
        rqst.setCatName(catName);
        return this.client.get_table_statistics_req(rqst).getTableStats();
    }

    @Override
    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partNames, List<String> colNames) throws TException {
        return this.getPartitionColumnStatistics(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, partNames, colNames);
    }

    @Override
    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames) throws TException {
        PartitionsStatsRequest rqst = new PartitionsStatsRequest(dbName, tableName, colNames, partNames);
        rqst.setCatName(catName);
        return this.client.get_partitions_statistics_req(rqst).getPartStats();
    }

    @Override
    public boolean deletePartitionColumnStatistics(String dbName, String tableName, String partName, String colName) throws TException {
        return this.deletePartitionColumnStatistics(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, partName, colName);
    }

    @Override
    public boolean deletePartitionColumnStatistics(String catName, String dbName, String tableName, String partName, String colName) throws TException {
        return this.client.delete_partition_column_statistics(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tableName, partName, colName);
    }

    @Override
    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName) throws TException {
        return this.deleteTableColumnStatistics(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, colName);
    }

    @Override
    public boolean deleteTableColumnStatistics(String catName, String dbName, String tableName, String colName) throws TException {
        return this.client.delete_table_column_statistics(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tableName, colName);
    }

    @Override
    public List<FieldSchema> getSchema(String db, String tableName) throws TException {
        return this.getSchema(MetaStoreUtils.getDefaultCatalog(this.conf), db, tableName);
    }

    @Override
    public List<FieldSchema> getSchema(String catName, String db, String tableName) throws TException {
        EnvironmentContext envCxt = null;
        String addedJars = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.ADDED_JARS);
        if (StringUtils.isNotBlank((String)addedJars)) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("hive.added.jars.path", addedJars);
            envCxt = new EnvironmentContext(props);
        }
        List<FieldSchema> fields = this.client.get_schema_with_environment_context(MetaStoreUtils.prependCatalogToDbName(catName, db, this.conf), tableName, envCxt);
        return this.deepCopyFieldSchemas(fields);
    }

    @Override
    public String getConfigValue(String name, String defaultValue) throws TException, ConfigValSecurityException {
        return this.client.get_config_value(name, defaultValue);
    }

    @Override
    public Partition getPartition(String db, String tableName, String partName) throws TException {
        return this.getPartition(MetaStoreUtils.getDefaultCatalog(this.conf), db, tableName, partName);
    }

    @Override
    public Partition getPartition(String catName, String dbName, String tblName, String name) throws TException {
        Partition p = this.client.get_partition_by_name(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tblName, name);
        return this.deepCopy(this.filterHook.filterPartition(p));
    }

    public Partition appendPartitionByName(String dbName, String tableName, String partName) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.appendPartitionByName(dbName, tableName, partName, null);
    }

    public Partition appendPartitionByName(String dbName, String tableName, String partName, EnvironmentContext envContext) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        Partition p = this.client.append_partition_by_name_with_environment_context(dbName, tableName, partName, envContext);
        return this.deepCopy(p);
    }

    public boolean dropPartitionByName(String dbName, String tableName, String partName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartitionByName(dbName, tableName, partName, deleteData, null);
    }

    public boolean dropPartitionByName(String dbName, String tableName, String partName, boolean deleteData, EnvironmentContext envContext) throws NoSuchObjectException, MetaException, TException {
        return this.client.drop_partition_by_name_with_environment_context(dbName, tableName, partName, deleteData, envContext);
    }

    private HiveMetaHook getHook(Table tbl) throws MetaException {
        if (this.hookLoader == null) {
            return null;
        }
        return this.hookLoader.getHook(tbl);
    }

    @Override
    public List<String> partitionNameToVals(String name) throws MetaException, TException {
        return this.client.partition_name_to_vals(name);
    }

    @Override
    public Map<String, String> partitionNameToSpec(String name) throws MetaException, TException {
        return this.client.partition_name_to_spec(name);
    }

    protected Partition deepCopy(Partition partition) {
        Partition copy = null;
        if (partition != null) {
            copy = new Partition(partition);
        }
        return copy;
    }

    private Database deepCopy(Database database) {
        Database copy = null;
        if (database != null) {
            copy = new Database(database);
        }
        return copy;
    }

    protected Table deepCopy(Table table) {
        Table copy = null;
        if (table != null) {
            copy = new Table(table);
        }
        return copy;
    }

    private Type deepCopy(Type type) {
        Type copy = null;
        if (type != null) {
            copy = new Type(type);
        }
        return copy;
    }

    private FieldSchema deepCopy(FieldSchema schema) {
        FieldSchema copy = null;
        if (schema != null) {
            copy = new FieldSchema(schema);
        }
        return copy;
    }

    private Function deepCopy(Function func) {
        Function copy = null;
        if (func != null) {
            copy = new Function(func);
        }
        return copy;
    }

    protected PrincipalPrivilegeSet deepCopy(PrincipalPrivilegeSet pps) {
        PrincipalPrivilegeSet copy = null;
        if (pps != null) {
            copy = new PrincipalPrivilegeSet(pps);
        }
        return copy;
    }

    private List<Partition> deepCopyPartitions(List<Partition> partitions) {
        return this.deepCopyPartitions(partitions, null);
    }

    private List<Partition> deepCopyPartitions(Collection<Partition> src, List<Partition> dest) {
        if (src == null) {
            return dest;
        }
        if (dest == null) {
            dest = new ArrayList<Partition>(src.size());
        }
        for (Partition part : src) {
            dest.add(this.deepCopy(part));
        }
        return dest;
    }

    private List<Table> deepCopyTables(List<Table> tables) {
        ArrayList<Table> copy = null;
        if (tables != null) {
            copy = new ArrayList<Table>();
            for (Table tab : tables) {
                copy.add(this.deepCopy(tab));
            }
        }
        return copy;
    }

    protected List<FieldSchema> deepCopyFieldSchemas(List<FieldSchema> schemas) {
        ArrayList<FieldSchema> copy = null;
        if (schemas != null) {
            copy = new ArrayList<FieldSchema>();
            for (FieldSchema schema : schemas) {
                copy.add(this.deepCopy(schema));
            }
        }
        return copy;
    }

    @Override
    public boolean grant_role(String roleName, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws MetaException, TException {
        GrantRevokeRoleRequest req = new GrantRevokeRoleRequest();
        req.setRequestType(GrantRevokeType.GRANT);
        req.setRoleName(roleName);
        req.setPrincipalName(userName);
        req.setPrincipalType(principalType);
        req.setGrantor(grantor);
        req.setGrantorType(grantorType);
        req.setGrantOption(grantOption);
        GrantRevokeRoleResponse res = this.client.grant_revoke_role(req);
        if (!res.isSetSuccess()) {
            throw new MetaException("GrantRevokeResponse missing success field");
        }
        return res.isSuccess();
    }

    @Override
    public boolean create_role(Role role) throws MetaException, TException {
        return this.client.create_role(role);
    }

    @Override
    public boolean drop_role(String roleName) throws MetaException, TException {
        return this.client.drop_role(roleName);
    }

    @Override
    public List<Role> list_roles(String principalName, PrincipalType principalType) throws MetaException, TException {
        return this.client.list_roles(principalName, principalType);
    }

    @Override
    public List<String> listRoleNames() throws MetaException, TException {
        return this.client.get_role_names();
    }

    @Override
    public GetPrincipalsInRoleResponse get_principals_in_role(GetPrincipalsInRoleRequest req) throws MetaException, TException {
        return this.client.get_principals_in_role(req);
    }

    @Override
    public GetRoleGrantsForPrincipalResponse get_role_grants_for_principal(GetRoleGrantsForPrincipalRequest getRolePrincReq) throws MetaException, TException {
        return this.client.get_role_grants_for_principal(getRolePrincReq);
    }

    @Override
    public boolean grant_privileges(PrivilegeBag privileges) throws MetaException, TException {
        String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
        for (HiveObjectPrivilege priv : privileges.getPrivileges()) {
            if (priv.getHiveObject().isSetCatName()) continue;
            priv.getHiveObject().setCatName(defaultCat);
        }
        GrantRevokePrivilegeRequest req = new GrantRevokePrivilegeRequest();
        req.setRequestType(GrantRevokeType.GRANT);
        req.setPrivileges(privileges);
        GrantRevokePrivilegeResponse res = this.client.grant_revoke_privileges(req);
        if (!res.isSetSuccess()) {
            throw new MetaException("GrantRevokePrivilegeResponse missing success field");
        }
        return res.isSuccess();
    }

    @Override
    public boolean revoke_role(String roleName, String userName, PrincipalType principalType, boolean grantOption) throws MetaException, TException {
        GrantRevokeRoleRequest req = new GrantRevokeRoleRequest();
        req.setRequestType(GrantRevokeType.REVOKE);
        req.setRoleName(roleName);
        req.setPrincipalName(userName);
        req.setPrincipalType(principalType);
        req.setGrantOption(grantOption);
        GrantRevokeRoleResponse res = this.client.grant_revoke_role(req);
        if (!res.isSetSuccess()) {
            throw new MetaException("GrantRevokeResponse missing success field");
        }
        return res.isSuccess();
    }

    @Override
    public boolean revoke_privileges(PrivilegeBag privileges, boolean grantOption) throws MetaException, TException {
        String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
        for (HiveObjectPrivilege priv : privileges.getPrivileges()) {
            if (priv.getHiveObject().isSetCatName()) continue;
            priv.getHiveObject().setCatName(defaultCat);
        }
        GrantRevokePrivilegeRequest req = new GrantRevokePrivilegeRequest();
        req.setRequestType(GrantRevokeType.REVOKE);
        req.setPrivileges(privileges);
        req.setRevokeGrantOption(grantOption);
        GrantRevokePrivilegeResponse res = this.client.grant_revoke_privileges(req);
        if (!res.isSetSuccess()) {
            throw new MetaException("GrantRevokePrivilegeResponse missing success field");
        }
        return res.isSuccess();
    }

    @Override
    public boolean refresh_privileges(HiveObjectRef objToRefresh, PrivilegeBag grantPrivileges) throws MetaException, TException {
        String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
        objToRefresh.setCatName(defaultCat);
        if (grantPrivileges.getPrivileges() != null) {
            for (HiveObjectPrivilege priv : grantPrivileges.getPrivileges()) {
                if (priv.getHiveObject().isSetCatName()) continue;
                priv.getHiveObject().setCatName(defaultCat);
            }
        }
        GrantRevokePrivilegeRequest grantReq = new GrantRevokePrivilegeRequest();
        grantReq.setRequestType(GrantRevokeType.GRANT);
        grantReq.setPrivileges(grantPrivileges);
        GrantRevokePrivilegeResponse res = this.client.refresh_privileges(objToRefresh, grantReq);
        if (!res.isSetSuccess()) {
            throw new MetaException("GrantRevokePrivilegeResponse missing success field");
        }
        return res.isSuccess();
    }

    @Override
    public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef hiveObject, String userName, List<String> groupNames) throws MetaException, TException {
        if (!hiveObject.isSetCatName()) {
            hiveObject.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.get_privilege_set(hiveObject, userName, groupNames);
    }

    @Override
    public List<HiveObjectPrivilege> list_privileges(String principalName, PrincipalType principalType, HiveObjectRef hiveObject) throws MetaException, TException {
        if (!hiveObject.isSetCatName()) {
            hiveObject.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.list_privileges(principalName, principalType, hiveObject);
    }

    public String getDelegationToken(String renewerKerberosPrincipalName) throws MetaException, TException, IOException {
        String owner = SecurityUtils.getUser();
        return this.getDelegationToken(owner, renewerKerberosPrincipalName);
    }

    @Override
    public String getDelegationToken(String owner, String renewerKerberosPrincipalName) throws MetaException, TException {
        if (this.localMetaStore) {
            return null;
        }
        return this.client.get_delegation_token(owner, renewerKerberosPrincipalName);
    }

    @Override
    public long renewDelegationToken(String tokenStrForm) throws MetaException, TException {
        if (this.localMetaStore) {
            return 0L;
        }
        return this.client.renew_delegation_token(tokenStrForm);
    }

    @Override
    public void cancelDelegationToken(String tokenStrForm) throws MetaException, TException {
        if (this.localMetaStore) {
            return;
        }
        this.client.cancel_delegation_token(tokenStrForm);
    }

    @Override
    public boolean addToken(String tokenIdentifier, String delegationToken) throws TException {
        return this.client.add_token(tokenIdentifier, delegationToken);
    }

    @Override
    public boolean removeToken(String tokenIdentifier) throws TException {
        return this.client.remove_token(tokenIdentifier);
    }

    @Override
    public String getToken(String tokenIdentifier) throws TException {
        return this.client.get_token(tokenIdentifier);
    }

    @Override
    public List<String> getAllTokenIdentifiers() throws TException {
        return this.client.get_all_token_identifiers();
    }

    @Override
    public int addMasterKey(String key) throws MetaException, TException {
        return this.client.add_master_key(key);
    }

    @Override
    public void updateMasterKey(Integer seqNo, String key) throws NoSuchObjectException, MetaException, TException {
        this.client.update_master_key(seqNo, key);
    }

    @Override
    public boolean removeMasterKey(Integer keySeq) throws TException {
        return this.client.remove_master_key(keySeq);
    }

    @Override
    public String[] getMasterKeys() throws TException {
        List<String> keyList = this.client.get_master_keys();
        return keyList.toArray(new String[keyList.size()]);
    }

    @Override
    public ValidTxnList getValidTxns() throws TException {
        return TxnUtils.createValidReadTxnList(this.client.get_open_txns(), 0L);
    }

    @Override
    public ValidTxnList getValidTxns(long currentTxn) throws TException {
        return TxnUtils.createValidReadTxnList(this.client.get_open_txns(), currentTxn);
    }

    @Override
    public ValidWriteIdList getValidWriteIds(String fullTableName) throws TException {
        GetValidWriteIdsRequest rqst = new GetValidWriteIdsRequest(Collections.singletonList(fullTableName), null);
        GetValidWriteIdsResponse validWriteIds = this.client.get_valid_write_ids(rqst);
        return TxnUtils.createValidReaderWriteIdList(validWriteIds.getTblValidWriteIds().get(0));
    }

    @Override
    public List<TableValidWriteIds> getValidWriteIds(List<String> tablesList, String validTxnList) throws TException {
        GetValidWriteIdsRequest rqst = new GetValidWriteIdsRequest(tablesList, validTxnList);
        return this.client.get_valid_write_ids(rqst).getTblValidWriteIds();
    }

    @Override
    public long openTxn(String user) throws TException {
        OpenTxnsResponse txns = this.openTxnsIntr(user, 1, null, null);
        return txns.getTxn_ids().get(0);
    }

    @Override
    public List<Long> replOpenTxn(String replPolicy, List<Long> srcTxnIds, String user) throws TException {
        OpenTxnsResponse txns = this.openTxnsIntr(user, srcTxnIds.size(), replPolicy, srcTxnIds);
        return txns.getTxn_ids();
    }

    @Override
    public OpenTxnsResponse openTxns(String user, int numTxns) throws TException {
        return this.openTxnsIntr(user, numTxns, null, null);
    }

    private OpenTxnsResponse openTxnsIntr(String user, int numTxns, String replPolicy, List<Long> srcTxnIds) throws TException {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to resolve my host name " + e.getMessage());
            throw new RuntimeException(e);
        }
        OpenTxnRequest rqst = new OpenTxnRequest(numTxns, user, hostname);
        if (replPolicy != null) {
            assert (srcTxnIds != null);
            assert (numTxns == srcTxnIds.size());
            rqst.setReplPolicy(replPolicy);
            rqst.setReplSrcTxnIds(srcTxnIds);
        } else assert (srcTxnIds == null);
        return this.client.open_txns(rqst);
    }

    @Override
    public void rollbackTxn(long txnid) throws NoSuchTxnException, TException {
        this.client.abort_txn(new AbortTxnRequest(txnid));
    }

    @Override
    public void replRollbackTxn(long srcTxnId, String replPolicy) throws NoSuchTxnException, TException {
        AbortTxnRequest rqst = new AbortTxnRequest(srcTxnId);
        rqst.setReplPolicy(replPolicy);
        this.client.abort_txn(rqst);
    }

    @Override
    public void commitTxn(long txnid) throws NoSuchTxnException, TxnAbortedException, TException {
        this.client.commit_txn(new CommitTxnRequest(txnid));
    }

    @Override
    public void replCommitTxn(long srcTxnId, String replPolicy) throws NoSuchTxnException, TxnAbortedException, TException {
        CommitTxnRequest rqst = new CommitTxnRequest(srcTxnId);
        rqst.setReplPolicy(replPolicy);
        this.client.commit_txn(rqst);
    }

    @Override
    public GetOpenTxnsInfoResponse showTxns() throws TException {
        return this.client.get_open_txns_info();
    }

    @Override
    public void abortTxns(List<Long> txnids) throws NoSuchTxnException, TException {
        this.client.abort_txns(new AbortTxnsRequest(txnids));
    }

    @Override
    public void replTableWriteIdState(String validWriteIdList, String dbName, String tableName, List<String> partNames) throws TException {
        String hostName;
        String user;
        try {
            user = UserGroupInformation.getCurrentUser().getUserName();
        }
        catch (IOException e) {
            LOG.error("Unable to resolve current user name " + e.getMessage());
            throw new RuntimeException(e);
        }
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to resolve my host name " + e.getMessage());
            throw new RuntimeException(e);
        }
        ReplTblWriteIdStateRequest rqst = new ReplTblWriteIdStateRequest(validWriteIdList, user, hostName, dbName, tableName);
        if (partNames != null) {
            rqst.setPartNames(partNames);
        }
        this.client.repl_tbl_writeid_state(rqst);
    }

    @Override
    public long allocateTableWriteId(long txnId, String dbName, String tableName) throws TException {
        return this.allocateTableWriteIdsBatch(Collections.singletonList(txnId), dbName, tableName).get(0).getWriteId();
    }

    @Override
    public List<TxnToWriteId> allocateTableWriteIdsBatch(List<Long> txnIds, String dbName, String tableName) throws TException {
        AllocateTableWriteIdsRequest rqst = new AllocateTableWriteIdsRequest(dbName, tableName);
        rqst.setTxnIds(txnIds);
        return this.allocateTableWriteIdsBatchIntr(rqst);
    }

    @Override
    public List<TxnToWriteId> replAllocateTableWriteIdsBatch(String dbName, String tableName, String replPolicy, List<TxnToWriteId> srcTxnToWriteIdList) throws TException {
        AllocateTableWriteIdsRequest rqst = new AllocateTableWriteIdsRequest(dbName, tableName);
        rqst.setReplPolicy(replPolicy);
        rqst.setSrcTxnToWriteIdList(srcTxnToWriteIdList);
        return this.allocateTableWriteIdsBatchIntr(rqst);
    }

    private List<TxnToWriteId> allocateTableWriteIdsBatchIntr(AllocateTableWriteIdsRequest rqst) throws TException {
        return this.client.allocate_table_write_ids(rqst).getTxnToWriteIds();
    }

    @Override
    public LockResponse lock(LockRequest request) throws NoSuchTxnException, TxnAbortedException, TException {
        return this.client.lock(request);
    }

    @Override
    public LockResponse checkLock(long lockid) throws NoSuchTxnException, TxnAbortedException, NoSuchLockException, TException {
        return this.client.check_lock(new CheckLockRequest(lockid));
    }

    @Override
    public void unlock(long lockid) throws NoSuchLockException, TxnOpenException, TException {
        this.client.unlock(new UnlockRequest(lockid));
    }

    @Override
    @Deprecated
    public ShowLocksResponse showLocks() throws TException {
        return this.client.show_locks(new ShowLocksRequest());
    }

    @Override
    public ShowLocksResponse showLocks(ShowLocksRequest request) throws TException {
        return this.client.show_locks(request);
    }

    @Override
    public void heartbeat(long txnid, long lockid) throws NoSuchLockException, NoSuchTxnException, TxnAbortedException, TException {
        HeartbeatRequest hb = new HeartbeatRequest();
        hb.setLockid(lockid);
        hb.setTxnid(txnid);
        this.client.heartbeat(hb);
    }

    @Override
    public HeartbeatTxnRangeResponse heartbeatTxnRange(long min, long max) throws NoSuchTxnException, TxnAbortedException, TException {
        HeartbeatTxnRangeRequest rqst = new HeartbeatTxnRangeRequest(min, max);
        return this.client.heartbeat_txn_range(rqst);
    }

    @Override
    @Deprecated
    public void compact(String dbname, String tableName, String partitionName, CompactionType type) throws TException {
        CompactionRequest cr = new CompactionRequest();
        if (dbname == null) {
            cr.setDbname("default");
        } else {
            cr.setDbname(dbname);
        }
        cr.setTablename(tableName);
        if (partitionName != null) {
            cr.setPartitionname(partitionName);
        }
        cr.setType(type);
        this.client.compact(cr);
    }

    @Override
    @Deprecated
    public void compact(String dbname, String tableName, String partitionName, CompactionType type, Map<String, String> tblproperties) throws TException {
        this.compact2(dbname, tableName, partitionName, type, tblproperties);
    }

    @Override
    public CompactionResponse compact2(String dbname, String tableName, String partitionName, CompactionType type, Map<String, String> tblproperties) throws TException {
        CompactionRequest cr = new CompactionRequest();
        if (dbname == null) {
            cr.setDbname("default");
        } else {
            cr.setDbname(dbname);
        }
        cr.setTablename(tableName);
        if (partitionName != null) {
            cr.setPartitionname(partitionName);
        }
        cr.setType(type);
        cr.setProperties(tblproperties);
        return this.client.compact2(cr);
    }

    @Override
    public ShowCompactResponse showCompactions() throws TException {
        return this.client.show_compact(new ShowCompactRequest());
    }

    @Override
    @Deprecated
    public void addDynamicPartitions(long txnId, long writeId, String dbName, String tableName, List<String> partNames) throws TException {
        this.client.add_dynamic_partitions(new AddDynamicPartitions(txnId, writeId, dbName, tableName, partNames));
    }

    @Override
    public void addDynamicPartitions(long txnId, long writeId, String dbName, String tableName, List<String> partNames, DataOperationType operationType) throws TException {
        AddDynamicPartitions adp = new AddDynamicPartitions(txnId, writeId, dbName, tableName, partNames);
        adp.setOperationType(operationType);
        this.client.add_dynamic_partitions(adp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertTable(Table table, boolean overwrite) throws MetaException {
        boolean failed = true;
        HiveMetaHook hook = this.getHook(table);
        if (hook == null || !(hook instanceof DefaultHiveMetaHook)) {
            return;
        }
        DefaultHiveMetaHook hiveMetaHook = (DefaultHiveMetaHook)hook;
        try {
            hiveMetaHook.commitInsertTable(table, overwrite);
            failed = false;
        }
        finally {
            if (failed) {
                hiveMetaHook.rollbackInsertTable(table, overwrite);
            }
        }
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    public NotificationEventResponse getNextNotification(long lastEventId, int maxEvents, IMetaStoreClient.NotificationFilter filter) throws TException {
        NotificationEventRequest rqst = new NotificationEventRequest(lastEventId);
        rqst.setMaxEvents(maxEvents);
        NotificationEventResponse rsp = this.client.get_next_notification(rqst);
        LOG.debug("Got back " + rsp.getEventsSize() + " events");
        NotificationEventResponse filtered = new NotificationEventResponse();
        if (rsp != null && rsp.getEvents() != null) {
            long nextEventId = lastEventId + 1L;
            for (NotificationEvent e : rsp.getEvents()) {
                if (e.getEventId() != nextEventId) {
                    LOG.error("Requested events are found missing in NOTIFICATION_LOG table. Expected: {}, Actual: {}. Probably, cleaner would've cleaned it up. Try setting higher value for hive.metastore.event.db.listener.timetolive. Also, bootstrap the system again to get back the consistent replicated state.", (Object)nextEventId, (Object)e.getEventId());
                    throw new IllegalStateException("Notification events are missing.");
                }
                if (filter != null && filter.accept(e)) {
                    filtered.addToEvents(e);
                }
                ++nextEventId;
            }
        }
        return filter != null ? filtered : rsp;
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    public CurrentNotificationEventId getCurrentNotificationEventId() throws TException {
        return this.client.get_current_notificationEventId();
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    public NotificationEventsCountResponse getNotificationEventsCount(NotificationEventsCountRequest rqst) throws TException {
        if (!rqst.isSetCatName()) {
            rqst.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.get_notification_events_count(rqst);
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"Apache Hive, HCatalog"})
    public FireEventResponse fireListenerEvent(FireEventRequest rqst) throws TException {
        if (!rqst.isSetCatName()) {
            rqst.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        return this.client.fire_listener_event(rqst);
    }

    public static IMetaStoreClient newSynchronizedClient(IMetaStoreClient client) {
        return (IMetaStoreClient)Proxy.newProxyInstance(HiveMetaStoreClient.class.getClassLoader(), new Class[]{IMetaStoreClient.class}, (InvocationHandler)new SynchronizedHandler(client));
    }

    @Override
    public void markPartitionForEvent(String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws TException {
        this.markPartitionForEvent(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, partKVs, eventType);
    }

    @Override
    public void markPartitionForEvent(String catName, String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws TException {
        this.client.markPartitionForEvent(MetaStoreUtils.prependCatalogToDbName(catName, db_name, this.conf), tbl_name, partKVs, eventType);
    }

    @Override
    public boolean isPartitionMarkedForEvent(String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws TException {
        return this.isPartitionMarkedForEvent(MetaStoreUtils.getDefaultCatalog(this.conf), db_name, tbl_name, partKVs, eventType);
    }

    @Override
    public boolean isPartitionMarkedForEvent(String catName, String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws TException {
        return this.client.isPartitionMarkedForEvent(MetaStoreUtils.prependCatalogToDbName(catName, db_name, this.conf), tbl_name, partKVs, eventType);
    }

    @Override
    public void createFunction(Function func) throws TException {
        if (!func.isSetCatName()) {
            func.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        this.client.create_function(func);
    }

    @Override
    public void alterFunction(String dbName, String funcName, Function newFunction) throws TException {
        this.alterFunction(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, funcName, newFunction);
    }

    @Override
    public void alterFunction(String catName, String dbName, String funcName, Function newFunction) throws TException {
        this.client.alter_function(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), funcName, newFunction);
    }

    @Override
    public void dropFunction(String dbName, String funcName) throws TException {
        this.dropFunction(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, funcName);
    }

    @Override
    public void dropFunction(String catName, String dbName, String funcName) throws TException {
        this.client.drop_function(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), funcName);
    }

    @Override
    public Function getFunction(String dbName, String funcName) throws TException {
        return this.getFunction(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, funcName);
    }

    @Override
    public Function getFunction(String catName, String dbName, String funcName) throws TException {
        return this.deepCopy(this.client.get_function(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), funcName));
    }

    @Override
    public List<String> getFunctions(String dbName, String pattern) throws TException {
        return this.getFunctions(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, pattern);
    }

    @Override
    public List<String> getFunctions(String catName, String dbName, String pattern) throws TException {
        return this.client.get_functions(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), pattern);
    }

    @Override
    public GetAllFunctionsResponse getAllFunctions() throws TException {
        return this.client.get_all_functions();
    }

    protected void create_table_with_environment_context(Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.client.create_table_with_environment_context(tbl, envContext);
    }

    protected void drop_table_with_environment_context(String catName, String dbname, String name, boolean deleteData, EnvironmentContext envContext) throws TException {
        this.client.drop_table_with_environment_context(MetaStoreUtils.prependCatalogToDbName(catName, dbname, this.conf), name, deleteData, envContext);
    }

    @Override
    public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partNames) throws NoSuchObjectException, MetaException, TException {
        return this.getAggrColStatsFor(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tblName, colNames, partNames);
    }

    @Override
    public AggrStats getAggrColStatsFor(String catName, String dbName, String tblName, List<String> colNames, List<String> partNames) throws TException {
        if (colNames.isEmpty() || partNames.isEmpty()) {
            LOG.debug("Columns is empty or partNames is empty : Short-circuiting stats eval on client side.");
            return new AggrStats(new ArrayList<ColumnStatisticsObj>(), 0L);
        }
        PartitionsStatsRequest req = new PartitionsStatsRequest(dbName, tblName, colNames, partNames);
        req.setCatName(catName);
        return this.client.get_aggr_stats_for(req);
    }

    @Override
    public Iterable<Map.Entry<Long, ByteBuffer>> getFileMetadata(final List<Long> fileIds) throws TException {
        return new MetastoreMapIterable<Long, ByteBuffer>(){
            private int listIndex = 0;

            @Override
            protected Map<Long, ByteBuffer> fetchNextBatch() throws TException {
                if (this.listIndex == fileIds.size()) {
                    return null;
                }
                int endIndex = Math.min(this.listIndex + HiveMetaStoreClient.this.fileMetadataBatchSize, fileIds.size());
                List subList = fileIds.subList(this.listIndex, endIndex);
                GetFileMetadataResult resp = HiveMetaStoreClient.this.sendGetFileMetadataReq(subList);
                if (!resp.isIsSupported()) {
                    return null;
                }
                this.listIndex = endIndex;
                return resp.getMetadata();
            }
        };
    }

    private GetFileMetadataResult sendGetFileMetadataReq(List<Long> fileIds) throws TException {
        return this.client.get_file_metadata(new GetFileMetadataRequest(fileIds));
    }

    @Override
    public Iterable<Map.Entry<Long, MetadataPpdResult>> getFileMetadataBySarg(final List<Long> fileIds, final ByteBuffer sarg, final boolean doGetFooters) throws TException {
        return new MetastoreMapIterable<Long, MetadataPpdResult>(){
            private int listIndex = 0;

            @Override
            protected Map<Long, MetadataPpdResult> fetchNextBatch() throws TException {
                if (this.listIndex == fileIds.size()) {
                    return null;
                }
                int endIndex = Math.min(this.listIndex + HiveMetaStoreClient.this.fileMetadataBatchSize, fileIds.size());
                List subList = fileIds.subList(this.listIndex, endIndex);
                GetFileMetadataByExprResult resp = HiveMetaStoreClient.this.sendGetFileMetadataBySargReq(sarg, subList, doGetFooters);
                if (!resp.isIsSupported()) {
                    return null;
                }
                this.listIndex = endIndex;
                return resp.getMetadata();
            }
        };
    }

    private GetFileMetadataByExprResult sendGetFileMetadataBySargReq(ByteBuffer sarg, List<Long> fileIds, boolean doGetFooters) throws TException {
        GetFileMetadataByExprRequest req = new GetFileMetadataByExprRequest(fileIds, sarg);
        req.setDoGetFooters(doGetFooters);
        return this.client.get_file_metadata_by_expr(req);
    }

    @Override
    public void clearFileMetadata(List<Long> fileIds) throws TException {
        ClearFileMetadataRequest req = new ClearFileMetadataRequest();
        req.setFileIds(fileIds);
        this.client.clear_file_metadata(req);
    }

    @Override
    public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata) throws TException {
        PutFileMetadataRequest req = new PutFileMetadataRequest();
        req.setFileIds(fileIds);
        req.setMetadata(metadata);
        this.client.put_file_metadata(req);
    }

    @Override
    public boolean isSameConfObj(Configuration c) {
        return this.conf == c;
    }

    @Override
    public boolean cacheFileMetadata(String dbName, String tableName, String partName, boolean allParts) throws TException {
        CacheFileMetadataRequest req = new CacheFileMetadataRequest();
        req.setDbName(dbName);
        req.setTblName(tableName);
        if (partName != null) {
            req.setPartName(partName);
        } else {
            req.setIsAllParts(allParts);
        }
        CacheFileMetadataResult result = this.client.cache_file_metadata(req);
        return result.isIsSupported();
    }

    @Override
    public String getMetastoreDbUuid() throws TException {
        return this.client.get_metastore_db_uuid();
    }

    @Override
    public void createResourcePlan(WMResourcePlan resourcePlan, String copyFromName) throws InvalidObjectException, MetaException, TException {
        WMCreateResourcePlanRequest request = new WMCreateResourcePlanRequest();
        request.setResourcePlan(resourcePlan);
        request.setCopyFrom(copyFromName);
        this.client.create_resource_plan(request);
    }

    @Override
    public WMFullResourcePlan getResourcePlan(String resourcePlanName) throws NoSuchObjectException, MetaException, TException {
        WMGetResourcePlanRequest request = new WMGetResourcePlanRequest();
        request.setResourcePlanName(resourcePlanName);
        return this.client.get_resource_plan(request).getResourcePlan();
    }

    @Override
    public List<WMResourcePlan> getAllResourcePlans() throws NoSuchObjectException, MetaException, TException {
        WMGetAllResourcePlanRequest request = new WMGetAllResourcePlanRequest();
        return this.client.get_all_resource_plans(request).getResourcePlans();
    }

    @Override
    public void dropResourcePlan(String resourcePlanName) throws NoSuchObjectException, MetaException, TException {
        WMDropResourcePlanRequest request = new WMDropResourcePlanRequest();
        request.setResourcePlanName(resourcePlanName);
        this.client.drop_resource_plan(request);
    }

    @Override
    public WMFullResourcePlan alterResourcePlan(String resourcePlanName, WMNullableResourcePlan resourcePlan, boolean canActivateDisabled, boolean isForceDeactivate, boolean isReplace) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMAlterResourcePlanRequest request = new WMAlterResourcePlanRequest();
        request.setResourcePlanName(resourcePlanName);
        request.setResourcePlan(resourcePlan);
        request.setIsEnableAndActivate(canActivateDisabled);
        request.setIsForceDeactivate(isForceDeactivate);
        request.setIsReplace(isReplace);
        WMAlterResourcePlanResponse resp = this.client.alter_resource_plan(request);
        return resp.isSetFullResourcePlan() ? resp.getFullResourcePlan() : null;
    }

    @Override
    public WMFullResourcePlan getActiveResourcePlan() throws MetaException, TException {
        return this.client.get_active_resource_plan(new WMGetActiveResourcePlanRequest()).getResourcePlan();
    }

    @Override
    public WMValidateResourcePlanResponse validateResourcePlan(String resourcePlanName) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMValidateResourcePlanRequest request = new WMValidateResourcePlanRequest();
        request.setResourcePlanName(resourcePlanName);
        return this.client.validate_resource_plan(request);
    }

    @Override
    public void createWMTrigger(WMTrigger trigger) throws InvalidObjectException, MetaException, TException {
        WMCreateTriggerRequest request = new WMCreateTriggerRequest();
        request.setTrigger(trigger);
        this.client.create_wm_trigger(request);
    }

    @Override
    public void alterWMTrigger(WMTrigger trigger) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMAlterTriggerRequest request = new WMAlterTriggerRequest();
        request.setTrigger(trigger);
        this.client.alter_wm_trigger(request);
    }

    @Override
    public void dropWMTrigger(String resourcePlanName, String triggerName) throws NoSuchObjectException, MetaException, TException {
        WMDropTriggerRequest request = new WMDropTriggerRequest();
        request.setResourcePlanName(resourcePlanName);
        request.setTriggerName(triggerName);
        this.client.drop_wm_trigger(request);
    }

    @Override
    public List<WMTrigger> getTriggersForResourcePlan(String resourcePlan) throws NoSuchObjectException, MetaException, TException {
        WMGetTriggersForResourePlanRequest request = new WMGetTriggersForResourePlanRequest();
        request.setResourcePlanName(resourcePlan);
        return this.client.get_triggers_for_resourceplan(request).getTriggers();
    }

    @Override
    public void createWMPool(WMPool pool) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMCreatePoolRequest request = new WMCreatePoolRequest();
        request.setPool(pool);
        this.client.create_wm_pool(request);
    }

    @Override
    public void alterWMPool(WMNullablePool pool, String poolPath) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMAlterPoolRequest request = new WMAlterPoolRequest();
        request.setPool(pool);
        request.setPoolPath(poolPath);
        this.client.alter_wm_pool(request);
    }

    @Override
    public void dropWMPool(String resourcePlanName, String poolPath) throws NoSuchObjectException, MetaException, TException {
        WMDropPoolRequest request = new WMDropPoolRequest();
        request.setResourcePlanName(resourcePlanName);
        request.setPoolPath(poolPath);
        this.client.drop_wm_pool(request);
    }

    @Override
    public void createOrUpdateWMMapping(WMMapping mapping, boolean isUpdate) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMCreateOrUpdateMappingRequest request = new WMCreateOrUpdateMappingRequest();
        request.setMapping(mapping);
        request.setUpdate(isUpdate);
        this.client.create_or_update_wm_mapping(request);
    }

    @Override
    public void dropWMMapping(WMMapping mapping) throws NoSuchObjectException, MetaException, TException {
        WMDropMappingRequest request = new WMDropMappingRequest();
        request.setMapping(mapping);
        this.client.drop_wm_mapping(request);
    }

    @Override
    public void createOrDropTriggerToPoolMapping(String resourcePlanName, String triggerName, String poolPath, boolean shouldDrop) throws AlreadyExistsException, NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMCreateOrDropTriggerToPoolMappingRequest request = new WMCreateOrDropTriggerToPoolMappingRequest();
        request.setResourcePlanName(resourcePlanName);
        request.setTriggerName(triggerName);
        request.setPoolPath(poolPath);
        request.setDrop(shouldDrop);
        this.client.create_or_drop_wm_trigger_to_pool_mapping(request);
    }

    @Override
    public void createISchema(ISchema schema) throws TException {
        if (!schema.isSetCatName()) {
            schema.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        this.client.create_ischema(schema);
    }

    @Override
    public void alterISchema(String catName, String dbName, String schemaName, ISchema newSchema) throws TException {
        this.client.alter_ischema(new AlterISchemaRequest(new ISchemaName(catName, dbName, schemaName), newSchema));
    }

    @Override
    public ISchema getISchema(String catName, String dbName, String name) throws TException {
        return this.client.get_ischema(new ISchemaName(catName, dbName, name));
    }

    @Override
    public void dropISchema(String catName, String dbName, String name) throws TException {
        this.client.drop_ischema(new ISchemaName(catName, dbName, name));
    }

    @Override
    public void addSchemaVersion(SchemaVersion schemaVersion) throws TException {
        if (!schemaVersion.getSchema().isSetCatName()) {
            schemaVersion.getSchema().setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
        }
        this.client.add_schema_version(schemaVersion);
    }

    @Override
    public SchemaVersion getSchemaVersion(String catName, String dbName, String schemaName, int version) throws TException {
        return this.client.get_schema_version(new SchemaVersionDescriptor(new ISchemaName(catName, dbName, schemaName), version));
    }

    @Override
    public SchemaVersion getSchemaLatestVersion(String catName, String dbName, String schemaName) throws TException {
        return this.client.get_schema_latest_version(new ISchemaName(catName, dbName, schemaName));
    }

    @Override
    public List<SchemaVersion> getSchemaAllVersions(String catName, String dbName, String schemaName) throws TException {
        return this.client.get_schema_all_versions(new ISchemaName(catName, dbName, schemaName));
    }

    @Override
    public void dropSchemaVersion(String catName, String dbName, String schemaName, int version) throws TException {
        this.client.drop_schema_version(new SchemaVersionDescriptor(new ISchemaName(catName, dbName, schemaName), version));
    }

    @Override
    public FindSchemasByColsResp getSchemaByCols(FindSchemasByColsRqst rqst) throws TException {
        return this.client.get_schemas_by_cols(rqst);
    }

    @Override
    public void mapSchemaVersionToSerde(String catName, String dbName, String schemaName, int version, String serdeName) throws TException {
        this.client.map_schema_version_to_serde(new MapSchemaVersionToSerdeRequest(new SchemaVersionDescriptor(new ISchemaName(catName, dbName, schemaName), version), serdeName));
    }

    @Override
    public void setSchemaVersionState(String catName, String dbName, String schemaName, int version, SchemaVersionState state) throws TException {
        this.client.set_schema_version_state(new SetSchemaVersionStateRequest(new SchemaVersionDescriptor(new ISchemaName(catName, dbName, schemaName), version), state));
    }

    @Override
    public void addSerDe(SerDeInfo serDeInfo) throws TException {
        this.client.add_serde(serDeInfo);
    }

    @Override
    public SerDeInfo getSerDe(String serDeName) throws TException {
        return this.client.get_serde(new GetSerdeRequest(serDeName));
    }

    private short shrinkMaxtoShort(int max) {
        if (max < 0) {
            return -1;
        }
        if (max <= Short.MAX_VALUE) {
            return (short)max;
        }
        return Short.MAX_VALUE;
    }

    @Override
    public LockResponse lockMaterializationRebuild(String dbName, String tableName, long txnId) throws TException {
        return this.client.get_lock_materialization_rebuild(dbName, tableName, txnId);
    }

    @Override
    public boolean heartbeatLockMaterializationRebuild(String dbName, String tableName, long txnId) throws TException {
        return this.client.heartbeat_lock_materialization_rebuild(dbName, tableName, txnId);
    }

    @Override
    public void addRuntimeStat(RuntimeStat stat) throws TException {
        this.client.add_runtime_stats(stat);
    }

    @Override
    public List<RuntimeStat> getRuntimeStats(int maxWeight, int maxCreateTime) throws TException {
        GetRuntimeStatsRequest req = new GetRuntimeStatsRequest();
        req.setMaxWeight(maxWeight);
        req.setMaxCreateTime(maxCreateTime);
        return this.client.get_runtime_stats(req);
    }

    public static abstract class MetastoreMapIterable<K, V>
    implements Iterable<Map.Entry<K, V>>,
    Iterator<Map.Entry<K, V>> {
        private Iterator<Map.Entry<K, V>> currentIter;

        protected abstract Map<K, V> fetchNextBatch() throws TException;

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            this.ensureCurrentBatch();
            return this.currentIter != null;
        }

        private void ensureCurrentBatch() {
            Map<K, V> currentBatch;
            if (this.currentIter != null && this.currentIter.hasNext()) {
                return;
            }
            this.currentIter = null;
            do {
                try {
                    currentBatch = this.fetchNextBatch();
                }
                catch (TException ex) {
                    throw new RuntimeException(ex);
                }
                if (currentBatch != null) continue;
                return;
            } while (currentBatch.isEmpty());
            this.currentIter = currentBatch.entrySet().iterator();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.ensureCurrentBatch();
            if (this.currentIter == null) {
                throw new NoSuchElementException();
            }
            return this.currentIter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SynchronizedHandler
    implements InvocationHandler {
        private final IMetaStoreClient client;

        SynchronizedHandler(IMetaStoreClient client) {
            this.client = client;
        }

        @Override
        public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this.client, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    private class ClientCertUpdater
    implements Runnable {
        private HopsSecurityMaterial securityMaterial;
        private long lastLoaded = -1L;

        ClientCertUpdater(ThriftHiveMetastore.Iface client, HopsSecurityMaterial securityMaterial) {
            this.securityMaterial = securityMaterial;
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(MetastoreConf.getLongVar(HiveMetaStoreClient.this.conf, MetastoreConf.ConfVars.CERT_RELOAD_THREAD_SLEEP));
                    File trustStore = new File(this.securityMaterial.getTrustStorePath());
                    if (trustStore.lastModified() == this.lastLoaded) continue;
                    this.securityMaterial = HiveMetaStoreClient.this.readClientMaterial();
                    HiveMetaStoreClient.this.client.set_crypto(this.securityMaterial.getKeyStore(), this.securityMaterial.getKeyStorePassword(), this.securityMaterial.getTrustStore(), this.securityMaterial.getTrustStorePassword(), true);
                    this.lastLoaded = trustStore.lastModified();
                }
                catch (Exception exception) {}
            }
        }
    }

    public class HopsSecurityMaterial {
        private String keyStorePath;
        private ByteBuffer keyStore;
        private String keyStorePassword;
        private String trustStorePath;
        private ByteBuffer trustStore;
        private String trustStorePassword;

        HopsSecurityMaterial(String keyStorePath, ByteBuffer keyStore, String keyStorePassword, String trustStorePath, ByteBuffer trustStore, String trustStorePassword) {
            this.keyStorePath = keyStorePath;
            this.keyStore = keyStore;
            this.keyStorePassword = keyStorePassword;
            this.trustStorePath = trustStorePath;
            this.trustStore = trustStore;
            this.trustStorePassword = trustStorePassword;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public String getKeyStorePath() {
            return this.keyStorePath;
        }

        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public String getTrustStorePath() {
            return this.trustStorePath;
        }

        public ByteBuffer getKeyStore() {
            return this.keyStore;
        }

        public ByteBuffer getTrustStore() {
            return this.trustStore;
        }
    }
}

