/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.model.helper;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.model.helper.InodePK;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InodeHelper
implements Configurable {
    private int ROOT_DIR_PARTITION_KEY = 0;
    private short ROOT_DIR_DEPTH = 0;
    private int RANDOM_PARTITIONING_MAX_LEVEL = 1;
    private long ROOT_INODE_ID = 1L;
    private final Logger logger = LoggerFactory.getLogger((String)InodeHelper.class.getName());
    private static InodeHelper instance = null;
    private static DataSource connPool = null;
    private Configuration metastoreConf = null;

    public static InodeHelper getInstance() {
        if (instance == null) {
            instance = new InodeHelper();
        }
        return instance;
    }

    public void setConf(Configuration metastoreConf) {
        this.metastoreConf = metastoreConf;
        this.ROOT_DIR_PARTITION_KEY = MetastoreConf.getIntVar(metastoreConf, MetastoreConf.ConfVars.HOPSROOTDIRPARTITIONKEY);
        this.ROOT_DIR_DEPTH = (short)MetastoreConf.getIntVar(metastoreConf, MetastoreConf.ConfVars.HOPSROOTDIRDEPTH);
        this.RANDOM_PARTITIONING_MAX_LEVEL = MetastoreConf.getIntVar(metastoreConf, MetastoreConf.ConfVars.HOPSRANDOMPARTITIONINGMAXLEVEL);
        this.ROOT_INODE_ID = MetastoreConf.getIntVar(metastoreConf, MetastoreConf.ConfVars.HOPSROOTINODEID);
        if (connPool == null && MetastoreConf.getBoolVar(metastoreConf, MetastoreConf.ConfVars.METADATACONSISTENCY)) {
            this.initConnections();
        }
    }

    public Configuration getConf() {
        return this.metastoreConf;
    }

    private synchronized void initConnections() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(MetastoreConf.getVar(this.metastoreConf, MetastoreConf.ConfVars.HOPSDBURLKEY));
        config.setUsername(MetastoreConf.getVar(this.metastoreConf, MetastoreConf.ConfVars.CONNECTION_USER_NAME));
        config.setPassword(MetastoreConf.getVar(this.metastoreConf, MetastoreConf.ConfVars.PWD));
        connPool = new HikariDataSource(config);
    }

    private Connection getDbConn() throws SQLException {
        int rc = 10;
        Connection dbConn = null;
        while (true) {
            try {
                dbConn = connPool.getConnection();
                return dbConn;
            }
            catch (SQLException e) {
                if (dbConn != null && !dbConn.isClosed()) {
                    dbConn.close();
                }
                if (--rc <= 0) {
                    throw e;
                }
                this.logger.error("There is a problem with a connection from the pool, retrying", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public InodePK getInodePK(String path) throws MetaException {
        if (!MetastoreConf.getBoolVar(this.metastoreConf, MetastoreConf.ConfVars.METADATACONSISTENCY)) {
            return new InodePK();
        }
        if (path == null || path.isEmpty()) {
            return new InodePK();
        }
        Path p = new Path(path);
        path = p.toUri().getPath();
        Connection dbConn = null;
        try {
            dbConn = this.getDbConn();
        }
        catch (SQLException e) {
            throw new MetaException(e.getMessage());
        }
        InodePK pk = this.getInodePK(dbConn, path);
        try {
            dbConn.close();
        }
        catch (SQLException e) {
            throw new MetaException(e.getMessage());
        }
        return pk;
    }

    private InodePK getInodePK(Connection dbConn, String path) throws MetaException {
        String[] p = path.charAt(0) == '/' ? path.substring(1).split("/") : path.split("/");
        if (p.length < 1) {
            throw new MetaException("Invalid Path");
        }
        long parentId = this.ROOT_INODE_ID;
        long partitionId = this.calculatePartitionId(this.ROOT_INODE_ID, p[0], this.ROOT_DIR_DEPTH + 1);
        long curr = this.findByInodePK(dbConn, parentId, p[0], partitionId);
        if (curr == -1L) {
            try {
                dbConn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new MetaException("Could not resolve inode at path: " + path);
        }
        for (int i = 1; i < p.length; ++i) {
            partitionId = this.calculatePartitionId(curr, p[i], i + 1);
            long next = this.findByInodePK(dbConn, curr, p[i], partitionId);
            if (next == -1L) {
                try {
                    dbConn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw new MetaException("Could not resolve inode at path: " + path);
            }
            parentId = curr;
            curr = next;
        }
        return new InodePK(partitionId, parentId, p[p.length - 1]);
    }

    private long findByInodePK(Connection conn, long parentId, String name, long partitionId) throws MetaException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT id FROM hdfs_inodes WHERE partition_id = ?  and parent_id = ?  and name = ?");
            stmt.setLong(1, partitionId);
            stmt.setLong(2, parentId);
            stmt.setString(3, name);
            rs = stmt.executeQuery();
            if (rs.next()) {
                long l = rs.getLong("id");
                return l;
            }
        }
        catch (SQLException e) {
            throw new MetaException(e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                throw new MetaException(e.getMessage());
            }
        }
        return -1L;
    }

    private long calculatePartitionId(long parentId, String name, int depth) {
        if (depth <= this.RANDOM_PARTITIONING_MAX_LEVEL) {
            if (depth == this.ROOT_DIR_DEPTH) {
                return this.ROOT_DIR_PARTITION_KEY;
            }
            return (name + parentId).hashCode();
        }
        return parentId;
    }
}

