/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyingObjectStore
extends ObjectStore {
    private static final Logger LOG = LoggerFactory.getLogger(VerifyingObjectStore.class);

    public VerifyingObjectStore() {
        LOG.warn(((Object)((Object)this)).getClass().getSimpleName() + " is being used - test run");
    }

    public List<Partition> getPartitionsByFilter(String catName, String dbName, String tblName, String filter, short maxParts) throws MetaException, NoSuchObjectException {
        List sqlResults = this.getPartitionsByFilterInternal(catName, dbName, tblName, filter, maxParts, true, false);
        List ormResults = this.getPartitionsByFilterInternal(catName, dbName, tblName, filter, maxParts, false, true);
        this.verifyLists(sqlResults, ormResults, Partition.class);
        return sqlResults;
    }

    public List<Partition> getPartitionsByNames(String catName, String dbName, String tblName, List<String> partNames) throws MetaException, NoSuchObjectException {
        List sqlResults = this.getPartitionsByNamesInternal(catName, dbName, tblName, partNames, true, false);
        List ormResults = this.getPartitionsByNamesInternal(catName, dbName, tblName, partNames, false, true);
        this.verifyLists(sqlResults, ormResults, Partition.class);
        return sqlResults;
    }

    public boolean getPartitionsByExpr(String catName, String dbName, String tblName, byte[] expr, String defaultPartitionName, short maxParts, List<Partition> result) throws TException {
        boolean ormResult;
        LinkedList ormParts = new LinkedList();
        boolean sqlResult = this.getPartitionsByExprInternal(catName, dbName, tblName, expr, defaultPartitionName, maxParts, result, true, false);
        if (sqlResult != (ormResult = this.getPartitionsByExprInternal(catName, dbName, tblName, expr, defaultPartitionName, maxParts, ormParts, false, true))) {
            String msg = "The unknown flag is different - SQL " + sqlResult + ", ORM " + ormResult;
            LOG.error(msg);
            throw new MetaException(msg);
        }
        this.verifyLists(result, ormParts, Partition.class);
        return sqlResult;
    }

    public List<Partition> getPartitions(String catName, String dbName, String tableName, int maxParts) throws MetaException, NoSuchObjectException {
        List sqlResults = this.getPartitionsInternal(catName, dbName, tableName, maxParts, true, false);
        List ormResults = this.getPartitionsInternal(catName, dbName, tableName, maxParts, false, true);
        this.verifyLists(sqlResults, ormResults, Partition.class);
        return sqlResults;
    }

    public ColumnStatistics getTableColumnStatistics(String catName, String dbName, String tableName, List<String> colNames) throws MetaException, NoSuchObjectException {
        ColumnStatistics sqlResult = this.getTableColumnStatisticsInternal(catName, dbName, tableName, colNames, true, false);
        ColumnStatistics jdoResult = this.getTableColumnStatisticsInternal(catName, dbName, tableName, colNames, false, true);
        this.verifyObjects(sqlResult, jdoResult, ColumnStatistics.class);
        return sqlResult;
    }

    public List<ColumnStatistics> getPartitionColumnStatistics(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames) throws MetaException, NoSuchObjectException {
        List sqlResult = this.getPartitionColumnStatisticsInternal(catName, dbName, tableName, partNames, colNames, true, false);
        List jdoResult = this.getPartitionColumnStatisticsInternal(catName, dbName, tableName, partNames, colNames, false, true);
        this.verifyLists(sqlResult, jdoResult, ColumnStatistics.class);
        return sqlResult;
    }

    private void verifyObjects(Object sqlResult, Object jdoResult, Class<?> clazz) throws MetaException {
        if (EqualsBuilder.reflectionEquals((Object)sqlResult, (Object)jdoResult)) {
            return;
        }
        StringBuilder errorStr = new StringBuilder("Objects are different: \n");
        try {
            VerifyingObjectStore.dumpObject(errorStr, "SQL", sqlResult, clazz, 0);
            errorStr.append("\n");
            VerifyingObjectStore.dumpObject(errorStr, "ORM", jdoResult, clazz, 0);
        }
        catch (Throwable t) {
            errorStr.append("Error getting the diff: " + t);
        }
        LOG.error("Different results: \n" + errorStr.toString());
        throw new MetaException("Different results from SQL and ORM, see log for details");
    }

    private <T> void verifyLists(Collection<T> sqlResults, Collection<T> ormResults, Class<?> clazz) throws MetaException {
        int MAX_DIFFS = 5;
        if (sqlResults.size() != ormResults.size()) {
            String msg = "Lists are not the same size: SQL " + sqlResults.size() + ", ORM " + ormResults.size();
            LOG.error(msg);
            throw new MetaException(msg);
        }
        Iterator<T> sqlIter = sqlResults.iterator();
        Iterator<T> ormIter = ormResults.iterator();
        StringBuilder errorStr = new StringBuilder();
        int errors = 0;
        for (int partIx = 0; partIx < sqlResults.size(); ++partIx) {
            T p2;
            assert (sqlIter.hasNext() && ormIter.hasNext());
            T p1 = sqlIter.next();
            if (EqualsBuilder.reflectionEquals(p1, p2 = ormIter.next())) continue;
            errorStr.append("Results are different at list index " + partIx + ": \n");
            try {
                VerifyingObjectStore.dumpObject(errorStr, "SQL", p1, clazz, 0);
                errorStr.append("\n");
                VerifyingObjectStore.dumpObject(errorStr, "ORM", p2, clazz, 0);
                errorStr.append("\n\n");
            }
            catch (Throwable t) {
                String msg = "Error getting the diff at list index " + partIx;
                errorStr.append("\n\n" + msg);
                LOG.error(msg, t);
                break;
            }
            if (++errors != 5) continue;
            errorStr.append("\n\nToo many diffs, giving up (lists might be sorted differently)");
            break;
        }
        if (errorStr.length() > 0) {
            LOG.error("Different results: \n" + errorStr.toString());
            throw new MetaException("Different results from SQL and ORM, see log for details");
        }
    }

    private static void dumpObject(StringBuilder errorStr, String name, Object p, Class<?> c, int level) throws IllegalAccessException {
        String offsetStr = StringUtils.repeat((String)"  ", (int)level);
        if (p == null || c == String.class || c.isPrimitive() || ClassUtils.wrapperToPrimitive(c) != null) {
            errorStr.append(offsetStr).append(name + ": [" + p + "]\n");
        } else if (ClassUtils.isAssignable(c, Iterable.class)) {
            errorStr.append(offsetStr).append(name + " is an iterable\n");
            Iterator i1 = ((Iterable)p).iterator();
            int i = 0;
            while (i1.hasNext()) {
                Object o1 = i1.next();
                Class t = o1 == null ? Object.class : o1.getClass();
                VerifyingObjectStore.dumpObject(errorStr, name + "[" + i++ + "]", o1, t, level + 1);
            }
        } else if (c.isArray()) {
            int len = Array.getLength(p);
            Class<?> t = c.getComponentType();
            errorStr.append(offsetStr).append(name + " is an array\n");
            for (int i = 0; i < len; ++i) {
                VerifyingObjectStore.dumpObject(errorStr, name + "[" + i + "]", Array.get(p, i), t, level + 1);
            }
        } else if (ClassUtils.isAssignable(c, Map.class)) {
            Map c1 = (Map)p;
            errorStr.append(offsetStr).append(name + " is a map\n");
            VerifyingObjectStore.dumpObject(errorStr, name + ".keys", c1.keySet(), Set.class, level + 1);
            VerifyingObjectStore.dumpObject(errorStr, name + ".vals", c1.values(), Collection.class, level + 1);
        } else {
            errorStr.append(offsetStr).append(name + " is of type " + c.getCanonicalName() + "\n");
            AccessibleObject[] fields = c.getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            for (int i = 0; i < fields.length; ++i) {
                AccessibleObject f = fields[i];
                if (((Field)f).getName().indexOf(36) != -1 || Modifier.isStatic(((Field)f).getModifiers())) continue;
                VerifyingObjectStore.dumpObject(errorStr, name + "." + ((Field)f).getName(), ((Field)f).get(p), ((Field)f).getType(), level + 1);
            }
        }
    }
}

