/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.security;

import com.google.common.base.Strings;
import io.hops.security.HopsX509AuthenticationException;
import io.hops.security.HopsX509Authenticator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.TUGIBasedProcessor;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.TUGIContainingTransport;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.ProcessFunction;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSSLBasedProcessor<I extends ThriftHiveMetastore.Iface>
extends TUGIBasedProcessor<ThriftHiveMetastore.Iface> {
    private final I iface;
    private final Map<String, ProcessFunction<ThriftHiveMetastore.Iface, ? extends TBase>> functions;
    private final HopsX509Authenticator hopsX509Authenticator;
    private final Set<String> usersAllowedToImpersonateSuperuser;
    static final Logger LOG = LoggerFactory.getLogger(TSSLBasedProcessor.class);
    private Configuration metastoreConf = null;

    public TSSLBasedProcessor(I iface, Configuration metastoreConf) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        super(iface);
        this.iface = iface;
        this.functions = this.getProcessMapView();
        this.metastoreConf = metastoreConf;
        this.hopsX509Authenticator = new HopsX509Authenticator(metastoreConf);
        this.usersAllowedToImpersonateSuperuser = new HashSet<String>(5);
        String defaultAllowedUsersStr = (String)MetastoreConf.ConfVars.HIVE_SUPERUSER_ALLOWED_IMPERSONATION.getDefaultVal();
        String[] defaultAllowedUsers = !Strings.isNullOrEmpty((String)defaultAllowedUsersStr) ? defaultAllowedUsersStr.split(",") : new String[]{};
        Collections.addAll(this.usersAllowedToImpersonateSuperuser, metastoreConf.getTrimmedStrings(MetastoreConf.ConfVars.HIVE_SUPERUSER_ALLOWED_IMPERSONATION.getVarname(), defaultAllowedUsers));
    }

    @Override
    public boolean process(final TProtocol in, final TProtocol out) throws TException {
        this.setIpAddress(in);
        final TMessage msg = in.readMessageBegin();
        final ProcessFunction<ThriftHiveMetastore.Iface, ? extends TBase> fn = this.functions.get(msg.name);
        if (fn == null) {
            TProtocolUtil.skip((TProtocol)in, (byte)12);
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(1, "Invalid method name: '" + msg.name + "'");
            out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
            x.write(out);
            out.writeMessageEnd();
            out.getTransport().flush();
            return true;
        }
        TUGIContainingTransport ugiTrans = (TUGIContainingTransport)in.getTransport();
        if (msg.name.equalsIgnoreCase("set_ugi")) {
            try {
                this.handleSetUGISSL(ugiTrans, (ThriftHiveMetastore.Processor.set_ugi)fn, msg, in, out);
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TException(e.getCause());
            }
            return true;
        }
        UserGroupInformation clientUgi = ugiTrans.getClientUGI();
        if (null == clientUgi) {
            throw new TException("UGI missing from the request");
        }
        try {
            PrivilegedExceptionAction<Void> pvea = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() {
                    try {
                        fn.process(msg.seqid, in, out, (Object)TSSLBasedProcessor.this.iface);
                        return null;
                    }
                    catch (TException te) {
                        throw new RuntimeException(te);
                    }
                }
            };
            clientUgi.doAs((PrivilegedExceptionAction)pvea);
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException rte) {
            if (rte.getCause() instanceof TException) {
                throw (TException)rte.getCause();
            }
            throw rte;
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                FileSystem.closeAllForUGI((UserGroupInformation)clientUgi);
            }
            catch (IOException e) {
                LOG.error("Could not clean up file-system handles for UGI: " + clientUgi, (Throwable)e);
            }
        }
    }

    protected void handleSetUGISSL(TUGIContainingTransport ugiTrans, ThriftHiveMetastore.Processor.set_ugi<ThriftHiveMetastore.Iface> fn, TMessage msg, TProtocol iprot, TProtocol oprot) throws TException, SecurityException, SSLException, IllegalArgumentException {
        UserGroupInformation clientUgi = ugiTrans.getClientUGI();
        if (null != clientUgi) {
            throw new TException((Throwable)new IllegalStateException("UGI is already set. Resetting is not allowed. Current ugi is: " + clientUgi.getUserName()));
        }
        ThriftHiveMetastore.set_ugi_args args = fn.getEmptyArgsInstance();
        try {
            args.read(iprot);
        }
        catch (TProtocolException e) {
            iprot.readMessageEnd();
            TApplicationException x = new TApplicationException(7, e.getMessage());
            oprot.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
            x.write(oprot);
            oprot.writeMessageEnd();
            oprot.getTransport().flush();
            return;
        }
        iprot.readMessageEnd();
        ThriftHiveMetastore.set_ugi_result result = fn.getResult((ThriftHiveMetastore.Iface)this.iface, args);
        List<String> principals = result.getSuccess();
        String user = principals.remove(principals.size() - 1);
        TTransport tTransport = iprot.getTransport();
        Socket socket = ((TUGIContainingTransport)tTransport).getSocket();
        X509Certificate[] certs = (X509Certificate[])((SSLSocket)socket).getSession().getPeerCertificates();
        if (certs.length == 0) {
            LOG.error("Client certificate not available");
            throw new SSLException("Client certificate not available");
        }
        UserGroupInformation tmpUGI = UserGroupInformation.createRemoteUser((String)user);
        try {
            InetAddress address = InetAddress.getByName(HiveMetaStore.HMSHandler.getThreadLocalIpAddress());
            this.hopsX509Authenticator.authenticateConnection(tmpUGI, certs[0], address, "hive-metastore");
        }
        catch (UnknownHostException ex) {
            LOG.error("Cannot validate client IP address: " + HiveMetaStore.HMSHandler.getThreadLocalIpAddress());
            throw new TTransportException("Cannot validate client IP address", (Throwable)ex);
        }
        catch (HopsX509AuthenticationException ex) {
            throw new TTransportException("Client not authorized", (Throwable)ex);
        }
        clientUgi = this.usersAllowedToImpersonateSuperuser.contains(user.trim()) ? UserGroupInformation.createRemoteUser((String)MetastoreConf.getVar(this.metastoreConf, MetastoreConf.ConfVars.HIVE_SUPER_USER)) : tmpUGI;
        ugiTrans.setClientUGI(clientUgi);
        oprot.writeMessageBegin(new TMessage(msg.name, 2, msg.seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
    }
}

