/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.ndv.hll;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import org.apache.hadoop.hive.common.ndv.hll.HyperLogLog;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreUnitTest.class})
public class TestHLLNoBias {
    private float noBiaslongRangeTolerance = 2.0f;
    private float biasedlongRangeTolerance = 5.0f;
    private float shortRangeTolerance = 0.5f;
    private int size;

    public TestHLLNoBias(int n) {
        this.size = n;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{30000}, {41000}, {50000}, {60000}, {75000}, {80000}, {81920}};
        return Arrays.asList(data);
    }

    @Test
    public void testHLLAdd() {
        Random rand = new Random(this.size);
        HyperLogLog hll = HyperLogLog.builder().build();
        int size = 100;
        for (int i = 0; i < size; ++i) {
            hll.addLong(rand.nextLong());
        }
        double threshold = size > 40000 ? (double)this.noBiaslongRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)size / 100.0;
        Assert.assertEquals((double)size, (double)hll.count(), (double)delta);
    }

    @Test
    public void testHLLAddHalfDistinct() {
        Random rand = new Random(this.size);
        HyperLogLog hll = HyperLogLog.builder().build();
        int unique = this.size / 2;
        HashSet<Long> hashset = new HashSet<Long>();
        for (int i = 0; i < this.size; ++i) {
            long val = rand.nextInt(unique);
            hashset.add(val);
            hll.addLong(val);
        }
        double threshold = this.size > 40000 ? (double)this.noBiaslongRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)hashset.size() / 100.0;
        Assert.assertEquals((double)hashset.size(), (double)hll.count(), (double)delta);
    }

    @Test
    public void testHLLNoBiasDisabled() {
        Random rand = new Random(this.size);
        HyperLogLog hll = HyperLogLog.builder().enableNoBias(false).build();
        int size = 100;
        for (int i = 0; i < size; ++i) {
            hll.addLong(rand.nextLong());
        }
        double threshold = size > 40000 ? (double)this.biasedlongRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)size / 100.0;
        Assert.assertEquals((double)size, (double)hll.count(), (double)delta);
    }

    @Test
    public void testHLLNoBiasDisabledHalfDistinct() {
        Random rand = new Random(this.size);
        HyperLogLog hll = HyperLogLog.builder().enableNoBias(false).build();
        int unique = this.size / 2;
        HashSet<Long> hashset = new HashSet<Long>();
        for (int i = 0; i < this.size; ++i) {
            long val = rand.nextInt(unique);
            hashset.add(val);
            hll.addLong(val);
        }
        double threshold = this.size > 40000 ? (double)this.biasedlongRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)hashset.size() / 100.0;
        Assert.assertEquals((double)hashset.size(), (double)hll.count(), (double)delta);
    }
}

