/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.ndv.hll;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import org.apache.hadoop.hive.common.ndv.hll.HyperLogLog;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreUnitTest.class})
public class TestHyperLogLogDense {
    private float longRangeTolerance = 5.0f;
    private float shortRangeTolerance = 3.0f;
    private int size;

    public TestHyperLogLogDense(int n) {
        this.size = n;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{2}, {10}, {100}, {1000}, {10000}, {100000}, {1000000}};
        return Arrays.asList(data);
    }

    @Test
    public void testHLLAdd() {
        Random rand = new Random(this.size);
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).build();
        int size = 100;
        for (int i = 0; i < size; ++i) {
            hll.addLong(rand.nextLong());
        }
        double threshold = size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)size / 100.0;
        Assert.assertEquals((double)size, (double)hll.count(), (double)delta);
    }

    @Test
    public void testHLLAddHalfDistinct() {
        Random rand = new Random(this.size);
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).build();
        int unique = this.size / 2;
        HashSet<Long> hashset = new HashSet<Long>();
        for (int i = 0; i < this.size; ++i) {
            long val = rand.nextInt(unique);
            hashset.add(val);
            hll.addLong(val);
        }
        double threshold = this.size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)hashset.size() / 100.0;
        Assert.assertEquals((double)hashset.size(), (double)hll.count(), (double)delta);
    }
}

