/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.model.helper.InodeHelper;
import org.apache.hadoop.hive.metastore.model.helper.InodePK;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestInodeHelper {
    private InodeHelper inodeHelper = null;
    private Configuration hiveConf = null;

    @Before
    public void setUp() throws Exception {
        this.hiveConf = MetastoreConf.newMetastoreConf();
        this.inodeHelper = InodeHelper.getInstance();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void TestTmp() throws MetaException {
        InodePK inodePk = this.inodeHelper.getInodePK("hdfs://0.0.0.0:0/tmp");
        Assert.assertEquals((Object)"tmp", (Object)inodePk.name);
        Assert.assertEquals((Object)new Long(1L), (Object)inodePk.parentId);
    }

    @Test
    public void TestEmpty() throws MetaException {
        InodePK inodePk = this.inodeHelper.getInodePK(null);
        Assert.assertEquals((Object)inodePk, (Object)new InodePK());
    }

    @Test
    public void TestRandom() throws MetaException, SQLException {
        Warehouse wh = new Warehouse(this.hiveConf);
        Path path = new Path(wh.getWhRoot(), "testdir");
        wh.mkdirs(path);
        InodePK inodePk = this.inodeHelper.getInodePK(path.toString());
        Assert.assertEquals((Object)"testdir", (Object)inodePk.name);
        Connection conn = DriverManager.getConnection(MetastoreConf.getVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HOPSDBURLKEY), MetastoreConf.getVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_USER_NAME), MetastoreConf.getVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PWD));
        PreparedStatement stmt = conn.prepareStatement("SELECT id FROM hdfs_inodes WHERE id = ? and name = ?");
        stmt.setLong(1, inodePk.parentId);
        stmt.setString(2, wh.getWhRoot().getName());
        ResultSet rs = stmt.executeQuery();
        if (!rs.next()) {
            throw new MetaException("Parent inode not found");
        }
        rs.close();
        stmt.close();
    }
}

