/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.AlternateFailurePreListener;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreCheckinTest.class})
public class TestRetryingHMSHandler {
    private Configuration conf;
    private HiveMetaStoreClient msc;

    @Before
    public void setUp() throws Exception {
        System.setProperty("hive.metastore.pre.event.listeners", AlternateFailurePreListener.class.getName());
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES, (long)3L);
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HMS_HANDLER_ATTEMPTS, (long)2L);
        MetastoreConf.setTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HMS_HANDLER_INTERVAL, (long)0L, (TimeUnit)TimeUnit.MILLISECONDS);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HMS_HANDLER_FORCE_RELOAD_CONF, (boolean)false);
        MetaStoreTestUtils.setConfForStandloneMode(this.conf);
        MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), this.conf);
        this.msc = new HiveMetaStoreClient(this.conf);
    }

    @Test
    public void testRetryingHMSHandler() throws Exception {
        String dbName = "hive4159";
        String tblName = "tmptbl";
        new DatabaseBuilder().setName(dbName).create((IMetaStoreClient)this.msc, this.conf);
        Assert.assertEquals((long)2L, (long)AlternateFailurePreListener.getCallCount());
        ((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tblName).addCol("c1", "string")).create((IMetaStoreClient)this.msc, this.conf);
        Assert.assertEquals((long)4L, (long)AlternateFailurePreListener.getCallCount());
    }
}

