/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import io.hops.security.CertificateLocalization;
import io.hops.security.CertificateLocalizationCtx;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DummyJdoConnectionUrlHook;
import org.apache.hadoop.hive.metastore.DummyRawStoreForJdoConnection;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.MockPartitionExpressionForMetastore;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestTLSHiveMetastoreClient {
    private static Path serverKeyStore;
    private static Path serverTrustStore;
    private static Path clientKeyStore;
    private static Path clientTrustStore;
    private static Path appClientKeyStore;
    private static Path appClientTrustStore;
    private static String outputDir;
    private static X509Certificate caCert;
    private static KeyPair caKeyPair;
    private static final String clientUsername = "Ring__Gandalf";
    private static final String fakeUser = "fake__user";
    private static final String password = "123456";
    private static Configuration hiveConf;
    private HiveMetaStoreClient hmsc = null;
    private HiveMetaStoreClient hmscUser = null;
    @Rule
    public final ExpectedException rule = ExpectedException.none();

    @BeforeClass
    public static void setUp() throws Exception {
        outputDir = KeyStoreTestUtil.getClasspathDir(TestTLSHiveMetastoreClient.class);
        TestTLSHiveMetastoreClient.generateCerts();
        Configuration sslServerConf = KeyStoreTestUtil.createServerSSLConfig((String)serverKeyStore.toString(), (String)password, (String)password, (String)serverTrustStore.toString(), (String)password, (String)"");
        Path sslServerPath = Paths.get(outputDir, "ssl-server.xml");
        File sslServer = new File(sslServerPath.toUri());
        KeyStoreTestUtil.saveConfig((File)sslServer, (Configuration)sslServerConf);
        hiveConf = MetastoreConf.newMetastoreConf();
        MetaStoreTestUtils.setConfForStandloneMode(hiveConf);
        hiveConf.set(MetastoreConf.ConfVars.HIVE_SUPER_USER.getVarname(), UserGroupInformation.getCurrentUser().getUserName());
        hiveConf.setBoolean("ipc.server.ssl.enabled", true);
        hiveConf.addResource("ssl-server.xml");
        hiveConf.set("hadoop.ssl.enabled.protocols", "TLSv1.2,TLSv1.1,TLSv1");
        hiveConf.set("hadoop.ssl.hostname.verifier", "ALLOW_ALL");
        MetastoreConf.setVar((Configuration)hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.RAW_STORE_IMPL, (String)DummyRawStoreForJdoConnection.class.getName());
        MetastoreConf.setVar((Configuration)hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_HOOK, (String)DummyJdoConnectionUrlHook.class.getName());
        MetastoreConf.setVar((Configuration)hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY, (String)"BAD_URL");
        MetastoreConf.setLongVar((Configuration)hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CERT_RELOAD_THREAD_SLEEP, (long)1000L);
        hiveConf.setClass(MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS.getVarname(), MockPartitionExpressionForMetastore.class, PartitionExpressionProxy.class);
        hiveConf.setBoolean(MetastoreConf.ConfVars.EXECUTE_SET_UGI.getVarname(), true);
        int msPort = MetaStoreTestUtils.startMetaStoreWithRetry(hiveConf);
        hiveConf.set(MetastoreConf.ConfVars.THRIFT_URIS.getVarname(), "thrift://localhost:" + msPort);
        hiveConf.set(MetastoreConf.ConfVars.INIT_HOOKS.getVarname(), "");
        hiveConf.setBoolean(MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY.getVarname(), false);
        hiveConf.setInt(MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES.getVarname(), 1);
    }

    @After
    public void closeClient() throws Exception {
        if (this.hmsc != null) {
            this.hmsc.close();
        }
        this.cleanCertificateLocalization(clientUsername, null);
        this.cleanCertificateLocalization(clientUsername, "app");
        this.cleanCertificateLocalization(fakeUser, "app");
    }

    @Test
    public void testClientMatchingCNUGI() throws Exception {
        this.setUpCertificateLocalization(clientUsername, clientKeyStore, clientTrustStore);
        UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)clientUsername, (UserGroupInformation)UserGroupInformation.getCurrentUser());
        ugi.doAs(() -> {
            this.hmsc = new HiveMetaStoreClient(hiveConf);
            return null;
        });
        CertificateLocalization certificateLocalization = CertificateLocalizationCtx.getInstance().getCertificateLocalization();
        Assert.assertEquals((long)2L, (long)certificateLocalization.getX509MaterialLocation(clientUsername).getRequestedApplications());
        this.hmsc.close();
        this.hmsc = null;
        Thread.sleep(1000L);
        Assert.assertEquals((long)1L, (long)certificateLocalization.getX509MaterialLocation(clientUsername).getRequestedApplications());
    }

    @Test
    public void testClientNotMatchingCNUGI() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)fakeUser, (UserGroupInformation)UserGroupInformation.getCurrentUser());
        this.setUpCertificateLocalization(fakeUser, clientKeyStore, clientTrustStore);
        ugi.doAs(() -> {
            this.rule.expect(UndeclaredThrowableException.class);
            this.hmsc = new HiveMetaStoreClient(hiveConf);
            return null;
        });
        this.cleanCertificateLocalization(fakeUser, null);
    }

    @Test
    public void testAppClient() throws Exception {
        UserGroupInformation ugiApp = UserGroupInformation.createProxyUser((String)clientUsername, (UserGroupInformation)UserGroupInformation.getCurrentUser());
        ugiApp.addApplicationId("app");
        this.setUpCertificateLocalization(clientUsername, appClientKeyStore, appClientTrustStore);
        ugiApp.doAs(() -> {
            this.hmsc = new HiveMetaStoreClient(hiveConf);
            return null;
        });
        CertificateLocalization certificateLocalization = CertificateLocalizationCtx.getInstance().getCertificateLocalization();
        Assert.assertEquals((long)1L, (long)certificateLocalization.getX509MaterialLocation(clientUsername).getRequestedApplications());
        Assert.assertEquals((long)1L, (long)certificateLocalization.getX509MaterialLocation(clientUsername, "app").getRequestedApplications());
        this.hmsc.close();
        this.hmsc = null;
        Thread.sleep(1000L);
        this.rule.expect(FileNotFoundException.class);
        certificateLocalization.getX509MaterialLocation(clientUsername, "app");
        Assert.assertEquals((long)1L, (long)certificateLocalization.getX509MaterialLocation(clientUsername).getRequestedApplications());
        this.cleanCertificateLocalization(clientUsername, null);
    }

    @Test
    public void testConcurrentAppNonAppUser() throws Exception {
        UserGroupInformation ugiApp = UserGroupInformation.createProxyUser((String)clientUsername, (UserGroupInformation)UserGroupInformation.getCurrentUser());
        ugiApp.addApplicationId("app");
        this.setUpCertificateLocalization(clientUsername, appClientKeyStore, appClientTrustStore);
        ugiApp.doAs(() -> {
            this.hmsc = new HiveMetaStoreClient(hiveConf);
            return null;
        });
        UserGroupInformation ugiUser = UserGroupInformation.createProxyUser((String)clientUsername, (UserGroupInformation)UserGroupInformation.getCurrentUser());
        byte[] keyStore = Files.readAllBytes(clientKeyStore);
        byte[] trustStore = Files.readAllBytes(clientTrustStore);
        CertificateLocalization certificateLocalization = CertificateLocalizationCtx.getInstance().getCertificateLocalization();
        certificateLocalization.updateX509(clientUsername, null, ByteBuffer.wrap(keyStore), password, ByteBuffer.wrap(trustStore), password);
        ugiUser.doAs(() -> {
            this.hmscUser = new HiveMetaStoreClient(hiveConf);
            return null;
        });
        Assert.assertEquals((long)2L, (long)certificateLocalization.getX509MaterialLocation(clientUsername).getRequestedApplications());
        Assert.assertEquals((long)1L, (long)certificateLocalization.getX509MaterialLocation(clientUsername, "app").getRequestedApplications());
        this.hmsc.close();
        this.hmscUser.close();
        this.hmsc = null;
        Thread.sleep(1000L);
        this.rule.expect(FileNotFoundException.class);
        certificateLocalization.getX509MaterialLocation(clientUsername, "app");
        Assert.assertEquals((long)1L, (long)certificateLocalization.getX509MaterialLocation(clientUsername).getRequestedApplications());
        this.cleanCertificateLocalization(clientUsername, null);
    }

    @Test
    public void testConcurrentUsers() throws Exception {
        UserGroupInformation ugiUser = UserGroupInformation.createProxyUser((String)clientUsername, (UserGroupInformation)UserGroupInformation.getCurrentUser());
        this.setUpCertificateLocalization(clientUsername, clientKeyStore, clientTrustStore);
        ugiUser.doAs(() -> {
            this.hmsc = new HiveMetaStoreClient(hiveConf);
            return null;
        });
        ugiUser.doAs(() -> {
            this.hmscUser = new HiveMetaStoreClient(hiveConf);
            return null;
        });
        CertificateLocalization certificateLocalization = CertificateLocalizationCtx.getInstance().getCertificateLocalization();
        Assert.assertEquals((long)3L, (long)certificateLocalization.getX509MaterialLocation(clientUsername).getRequestedApplications());
        this.hmsc.close();
        this.hmsc = null;
        Thread.sleep(1000L);
        Assert.assertEquals((long)2L, (long)certificateLocalization.getX509MaterialLocation(clientUsername).getRequestedApplications());
        this.hmscUser.close();
        this.hmscUser = null;
        Thread.sleep(1000L);
        Assert.assertEquals((long)1L, (long)certificateLocalization.getX509MaterialLocation(clientUsername).getRequestedApplications());
    }

    @Test
    public void testAppCertificateRotation() throws Exception {
        UserGroupInformation ugiUser = UserGroupInformation.createProxyUser((String)clientUsername, (UserGroupInformation)UserGroupInformation.getCurrentUser());
        FileUtils.copyFile((File)appClientKeyStore.toFile(), (File)Paths.get("k_certificate", new String[0]).toFile());
        FileUtils.copyFile((File)appClientTrustStore.toFile(), (File)Paths.get("t_certificate", new String[0]).toFile());
        FileUtils.write((File)Paths.get("material_passwd", new String[0]).toFile(), (CharSequence)password);
        ugiUser.doAs(() -> {
            this.hmsc = new HiveMetaStoreClient(hiveConf);
            return null;
        });
        CertificateLocalization certificateLocalization = CertificateLocalizationCtx.getInstance().getCertificateLocalization();
        Assert.assertEquals((long)1L, (long)certificateLocalization.getX509MaterialLocation(clientUsername, "app").getRequestedApplications());
        int keystore1_size = certificateLocalization.getX509MaterialLocation(clientUsername, "app").getKeyStoreMem().capacity();
        TestTLSHiveMetastoreClient.generateCertificate("CN=Ring__Gandalf,O=app,OU=100000", "c_client_alias", appClientKeyStore, appClientTrustStore);
        FileUtils.deleteQuietly((File)Paths.get("k_certificate", new String[0]).toFile());
        FileUtils.deleteQuietly((File)Paths.get("t_certificate", new String[0]).toFile());
        FileUtils.copyFile((File)appClientKeyStore.toFile(), (File)Paths.get("k_certificate", new String[0]).toFile());
        FileUtils.copyFile((File)appClientTrustStore.toFile(), (File)Paths.get("t_certificate", new String[0]).toFile());
        Thread.sleep(10000L);
        Assert.assertEquals((long)1L, (long)certificateLocalization.getX509MaterialLocation(clientUsername, "app").getRequestedApplications());
        int keystore2_size = certificateLocalization.getX509MaterialLocation(clientUsername, "app").getKeyStoreMem().capacity();
        Assert.assertNotEquals((long)keystore1_size, (long)keystore2_size);
        this.hmsc.close();
        this.hmsc = null;
        FileUtils.deleteQuietly((File)Paths.get("k_certificate", new String[0]).toFile());
        FileUtils.deleteQuietly((File)Paths.get("t_certificate", new String[0]).toFile());
        FileUtils.deleteQuietly((File)Paths.get("material_passwd", new String[0]).toFile());
        this.cleanCertificateLocalization(clientUsername, "app");
    }

    @Test
    public void testClientMachineCertificates() throws Exception {
        this.hmsc = new HiveMetaStoreClient(hiveConf);
    }

    private static void generateCerts() throws Exception {
        String keyAlg = "RSA";
        String signAlg = "SHA256withRSA";
        caKeyPair = KeyStoreTestUtil.generateKeyPair((String)keyAlg);
        caCert = KeyStoreTestUtil.generateCertificate((String)"CN=CARoot", (KeyPair)caKeyPair, (int)42, (String)signAlg);
        serverKeyStore = Paths.get(outputDir, "server.keystore.jks");
        serverTrustStore = Paths.get(outputDir, "server.truststore.jks");
        TestTLSHiveMetastoreClient.generateCertificate("CN=" + NetUtils.getHostNameOfIP((String)"127.0.0.1"), "server_alias", serverKeyStore, serverTrustStore);
        clientKeyStore = Paths.get(outputDir, "c_client.keystore.jks");
        clientTrustStore = Paths.get(outputDir, "c_client.truststore.jks");
        TestTLSHiveMetastoreClient.generateCertificate("CN=Ring__Gandalf", "c_client_alias", clientKeyStore, clientTrustStore);
        appClientKeyStore = Paths.get(outputDir, "c_app_client.keystore.jks");
        appClientTrustStore = Paths.get(outputDir, "c_app_client.truststore.jks");
        TestTLSHiveMetastoreClient.generateCertificate("CN=Ring__Gandalf,O=app,OU=0", "c_client_alias", appClientKeyStore, appClientTrustStore);
    }

    private static void generateCertificate(String cn, String alias, Path keystore, Path truststore) throws Exception {
        String keyAlg = "RSA";
        String signAlg = "SHA256withRSA";
        KeyPair keyPair = KeyStoreTestUtil.generateKeyPair((String)keyAlg);
        X509Certificate clientCrt = KeyStoreTestUtil.generateSignedCertificate((String)cn, (KeyPair)keyPair, (int)42, (String)signAlg, (PrivateKey)caKeyPair.getPrivate(), (X509Certificate)caCert);
        KeyStoreTestUtil.createKeyStore((String)keystore.toString(), (String)password, (String)password, (String)alias, (Key)keyPair.getPrivate(), (Certificate)clientCrt);
        KeyStoreTestUtil.createTrustStore((String)truststore.toString(), (String)password, (String)"CARoot", (Certificate)caCert);
    }

    private void setUpCertificateLocalization(String username, Path keyStorePath, Path trustStorePath) throws Exception {
        byte[] keyStore = Files.readAllBytes(keyStorePath);
        byte[] trustStore = Files.readAllBytes(trustStorePath);
        CertificateLocalization certificateLocalization = CertificateLocalizationCtx.getInstance().getCertificateLocalization();
        certificateLocalization.materializeCertificates(username, username, ByteBuffer.wrap(keyStore), password, ByteBuffer.wrap(trustStore), password);
    }

    private void cleanCertificateLocalization(String username, String appId) {
        CertificateLocalization certificateLocalization = CertificateLocalizationCtx.getInstance().getCertificateLocalization();
        try {
            certificateLocalization.removeX509Material(username, appId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

