/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestCatalogs
extends MetaStoreClientTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestCatalogs.class);
    private final AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;

    public TestCatalogs(String name, AbstractMetaStoreService metaStore) throws Exception {
        this.metaStore = metaStore;
        this.metaStore.start();
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws Exception {
        List catalogs = this.client.getCatalogs();
        for (String catName : catalogs) {
            List databases;
            if (!catName.equalsIgnoreCase("hive")) {
                databases = this.client.getAllDatabases(catName);
                for (String db : databases) {
                    this.client.dropDatabase(catName, db, true, false, true);
                }
                this.client.dropCatalog(catName);
                continue;
            }
            databases = this.client.getAllDatabases(catName);
            for (String db : databases) {
                if (db.equalsIgnoreCase("default")) continue;
                this.client.dropDatabase(catName, db, true, false, true);
            }
        }
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        finally {
            this.client = null;
        }
    }

    @Test
    public void catalogOperations() throws TException {
        int i;
        File dir;
        Catalog cat;
        int i2;
        String[] catNames = new String[]{"cat1", "cat2", "ADifferentName"};
        String[] description = new String[]{"a description", "super descriptive", null};
        String[] location = new String[]{MetaStoreTestUtils.getTestWarehouseDir("cat1"), MetaStoreTestUtils.getTestWarehouseDir("cat2"), MetaStoreTestUtils.getTestWarehouseDir("different")};
        for (i2 = 0; i2 < catNames.length; ++i2) {
            cat = new CatalogBuilder().setName(catNames[i2]).setLocation(location[i2]).setDescription(description[i2]).build();
            this.client.createCatalog(cat);
            dir = new File(cat.getLocationUri());
            Assert.assertTrue((dir.exists() && dir.isDirectory() ? 1 : 0) != 0);
        }
        for (i2 = 0; i2 < catNames.length; ++i2) {
            cat = this.client.getCatalog(catNames[i2]);
            Assert.assertTrue((boolean)catNames[i2].equalsIgnoreCase(cat.getName()));
            Assert.assertEquals((Object)description[i2], (Object)cat.getDescription());
            Assert.assertEquals((Object)location[i2], (Object)cat.getLocationUri());
            dir = new File(cat.getLocationUri());
            Assert.assertTrue((dir.exists() && dir.isDirectory() ? 1 : 0) != 0);
            Database db = this.client.getDatabase(catNames[i2], "default");
            Assert.assertEquals((Object)("file:" + cat.getLocationUri()), (Object)db.getLocationUri());
        }
        List catalogs = this.client.getCatalogs();
        Assert.assertEquals((long)4L, (long)catalogs.size());
        catalogs.sort(Comparator.naturalOrder());
        ArrayList<String> expected = new ArrayList<String>(catNames.length + 1);
        expected.add("hive");
        expected.addAll(Arrays.asList(catNames));
        expected.sort(Comparator.naturalOrder());
        for (i = 0; i < catalogs.size(); ++i) {
            Assert.assertTrue((String)("Expected " + (String)expected.get(i) + " actual " + (String)catalogs.get(i)), (boolean)((String)catalogs.get(i)).equalsIgnoreCase((String)expected.get(i)));
        }
        for (i = 0; i < catNames.length; ++i) {
            this.client.dropCatalog(catNames[i]);
            File dir2 = new File(location[i]);
            Assert.assertFalse((boolean)dir2.exists());
        }
        catalogs = this.client.getCatalogs();
        Assert.assertEquals((long)1L, (long)catalogs.size());
        Assert.assertTrue((boolean)((String)catalogs.get(0)).equalsIgnoreCase("hive"));
    }

    @Test(expected=NoSuchObjectException.class)
    public void getNonExistentCatalog() throws TException {
        this.client.getCatalog("noSuchCatalog");
    }

    @Test(expected=MetaException.class)
    @Ignore
    public void createCatalogWithBadLocation() throws TException {
        Catalog cat = new CatalogBuilder().setName("goodluck").setLocation("/nosuch/nosuch").build();
        this.client.createCatalog(cat);
    }

    @Test(expected=NoSuchObjectException.class)
    public void dropNonExistentCatalog() throws TException {
        this.client.dropCatalog("noSuchCatalog");
    }

    @Test(expected=MetaException.class)
    public void dropHiveCatalog() throws TException {
        this.client.dropCatalog("hive");
    }

    @Test(expected=InvalidOperationException.class)
    public void dropNonEmptyCatalog() throws TException {
        String catName = "toBeDropped";
        Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
        this.client.createCatalog(cat);
        String dbName = "dontDropMe";
        new DatabaseBuilder().setName(dbName).setCatalogName(catName).create(this.client, this.metaStore.getConf());
        this.client.dropCatalog(catName);
    }

    @Test(expected=InvalidOperationException.class)
    public void dropCatalogWithNonEmptyDefaultDb() throws TException {
        String catName = "toBeDropped2";
        new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).create(this.client);
        ((TableBuilder)new TableBuilder().setTableName("not_droppable").setCatName(catName).addCol("cola1", "bigint")).create(this.client, this.metaStore.getConf());
        this.client.dropCatalog(catName);
    }
}

