/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.utils.HdfsUtils;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Category(value={MetastoreUnitTest.class})
public class TestHdfsUtils {
    private Random rand = new Random();

    private Path createFile(FileSystem fs, FsPermission perms) throws IOException {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            buf.append((char)(this.rand.nextInt(26) + 97));
        }
        Path p = new Path(buf.toString());
        FSDataOutputStream os = fs.create(p);
        os.writeBytes("Mary had a little lamb\nit's fleece was white as snow\nand anywhere that Mary went\nthe lamb was sure to go\n");
        os.close();
        fs.setPermission(p, perms);
        fs.deleteOnExit(p);
        return p;
    }

    private Configuration makeConf() {
        Configuration conf = new Configuration();
        conf.set("dfs.permissions.supergroup", "ubermensch");
        return conf;
    }

    private UserGroupInformation ugiInvalidUserValidGroups() throws LoginException, IOException {
        UserGroupInformation ugi = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Mockito.when((Object)ugi.getShortUserName()).thenReturn((Object)"nosuchuser");
        Mockito.when((Object)ugi.getGroupNames()).thenReturn((Object)SecurityUtils.getUGI().getGroupNames());
        return ugi;
    }

    private UserGroupInformation ugiInvalidUserInvalidGroups() {
        UserGroupInformation ugi = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Mockito.when((Object)ugi.getShortUserName()).thenReturn((Object)"nosuchuser");
        Mockito.when((Object)ugi.getGroupNames()).thenReturn((Object)new String[]{"nosuchgroup"});
        return ugi;
    }

    @Test
    public void userReadWriteExecute() throws IOException, LoginException {
        FileSystem fs = FileSystem.get((Configuration)this.makeConf());
        Path p = this.createFile(fs, new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE));
        UserGroupInformation ugi = SecurityUtils.getUGI();
        HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.READ, (UserGroupInformation)ugi);
        HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.WRITE, (UserGroupInformation)ugi);
        HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.EXECUTE, (UserGroupInformation)ugi);
    }

    @Test(expected=AccessControlException.class)
    public void userNoRead() throws IOException, LoginException {
        FileSystem fs = FileSystem.get((Configuration)this.makeConf());
        Path p = this.createFile(fs, new FsPermission(FsAction.NONE, FsAction.ALL, FsAction.ALL));
        UserGroupInformation ugi = SecurityUtils.getUGI();
        HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.READ, (UserGroupInformation)ugi);
    }

    @Test(expected=AccessControlException.class)
    public void userNoWrite() throws IOException, LoginException {
        FileSystem fs = FileSystem.get((Configuration)this.makeConf());
        Path p = this.createFile(fs, new FsPermission(FsAction.NONE, FsAction.ALL, FsAction.ALL));
        UserGroupInformation ugi = SecurityUtils.getUGI();
        HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.WRITE, (UserGroupInformation)ugi);
    }

    @Test(expected=AccessControlException.class)
    public void userNoExecute() throws IOException, LoginException {
        FileSystem fs = FileSystem.get((Configuration)this.makeConf());
        Path p = this.createFile(fs, new FsPermission(FsAction.NONE, FsAction.ALL, FsAction.ALL));
        UserGroupInformation ugi = SecurityUtils.getUGI();
        HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.EXECUTE, (UserGroupInformation)ugi);
    }

    @Test
    public void groupReadWriteExecute() throws IOException, LoginException {
        FileSystem fs = FileSystem.get((Configuration)this.makeConf());
        Path p = this.createFile(fs, new FsPermission(FsAction.NONE, FsAction.ALL, FsAction.NONE));
        UserGroupInformation ugi = this.ugiInvalidUserValidGroups();
        HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.READ, (UserGroupInformation)ugi);
        HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.WRITE, (UserGroupInformation)ugi);
        HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.EXECUTE, (UserGroupInformation)ugi);
    }

    @Test(expected=AccessControlException.class)
    public void groupNoRead() throws IOException, LoginException {
        FileSystem fs = FileSystem.get((Configuration)this.makeConf());
        Path p = this.createFile(fs, new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.ALL));
        UserGroupInformation ugi = this.ugiInvalidUserValidGroups();
        HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.READ, (UserGroupInformation)ugi);
    }

    @Test(expected=AccessControlException.class)
    public void groupNoWrite() throws IOException, LoginException {
        FileSystem fs = FileSystem.get((Configuration)this.makeConf());
        Path p = this.createFile(fs, new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.ALL));
        UserGroupInformation ugi = this.ugiInvalidUserValidGroups();
        HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.WRITE, (UserGroupInformation)ugi);
    }

    @Test(expected=AccessControlException.class)
    public void groupNoExecute() throws IOException, LoginException {
        FileSystem fs = FileSystem.get((Configuration)this.makeConf());
        Path p = this.createFile(fs, new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.ALL));
        UserGroupInformation ugi = this.ugiInvalidUserValidGroups();
        HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.EXECUTE, (UserGroupInformation)ugi);
    }

    @Test
    public void otherReadWriteExecute() throws IOException, LoginException {
        FileSystem fs = FileSystem.get((Configuration)this.makeConf());
        Path p = this.createFile(fs, new FsPermission(FsAction.NONE, FsAction.NONE, FsAction.ALL));
        UserGroupInformation ugi = this.ugiInvalidUserInvalidGroups();
        HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.READ, (UserGroupInformation)ugi);
        HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.WRITE, (UserGroupInformation)ugi);
        HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.EXECUTE, (UserGroupInformation)ugi);
    }

    @Test(expected=AccessControlException.class)
    public void otherNoRead() throws IOException, LoginException {
        FileSystem fs = FileSystem.get((Configuration)this.makeConf());
        Path p = this.createFile(fs, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.NONE));
        UserGroupInformation ugi = this.ugiInvalidUserInvalidGroups();
        HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.READ, (UserGroupInformation)ugi);
    }

    @Test(expected=AccessControlException.class)
    public void otherNoWrite() throws IOException, LoginException {
        FileSystem fs = FileSystem.get((Configuration)this.makeConf());
        Path p = this.createFile(fs, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.NONE));
        UserGroupInformation ugi = this.ugiInvalidUserInvalidGroups();
        HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.WRITE, (UserGroupInformation)ugi);
    }

    @Test(expected=AccessControlException.class)
    public void otherNoExecute() throws IOException, LoginException {
        FileSystem fs = FileSystem.get((Configuration)this.makeConf());
        Path p = this.createFile(fs, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.NONE));
        UserGroupInformation ugi = this.ugiInvalidUserInvalidGroups();
        HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.EXECUTE, (UserGroupInformation)ugi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void rootReadWriteExecute() throws IOException, LoginException {
        UserGroupInformation ugi = SecurityUtils.getUGI();
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        String old = fs.getConf().get("dfs.permissions.supergroup");
        try {
            fs.getConf().set("dfs.permissions.supergroup", ugi.getPrimaryGroupName());
            Path p = this.createFile(fs, new FsPermission(FsAction.NONE, FsAction.NONE, FsAction.NONE));
            HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.READ, (UserGroupInformation)ugi);
            HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.WRITE, (UserGroupInformation)ugi);
            HdfsUtils.checkFileAccess((FileSystem)fs, (FileStatus)fs.getFileStatus(p), (FsAction)FsAction.EXECUTE, (UserGroupInformation)ugi);
        }
        finally {
            fs.getConf().set("dfs.permissions.supergroup", old);
        }
    }

    @Test
    public void testSetFullFileStatusFailInheritGroup() throws IOException {
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.acls.enabled", "false");
        HdfsUtils.HadoopFileStatus mockHadoopFileStatus = (HdfsUtils.HadoopFileStatus)Mockito.mock(HdfsUtils.HadoopFileStatus.class);
        FileStatus mockSourceStatus = (FileStatus)Mockito.mock(FileStatus.class);
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)mockSourceStatus.getGroup()).thenReturn((Object)"fakeGroup1");
        Mockito.when((Object)mockHadoopFileStatus.getFileStatus()).thenReturn((Object)mockSourceStatus);
        ((FileSystem)Mockito.doThrow(RuntimeException.class).when((Object)fs)).setOwner((Path)Matchers.any(Path.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class));
        HdfsUtils.setFullFileStatus((Configuration)conf, (HdfsUtils.HadoopFileStatus)mockHadoopFileStatus, (String)"fakeGroup2", (FileSystem)fs, (Path)new Path("fakePath"), (boolean)false);
        ((FileSystem)Mockito.verify((Object)fs)).setOwner((Path)Matchers.any(Path.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class));
    }

    @Test
    public void testSetFullFileStatusFailInheritAcls() throws IOException {
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.acls.enabled", "true");
        HdfsUtils.HadoopFileStatus mockHadoopFileStatus = (HdfsUtils.HadoopFileStatus)Mockito.mock(HdfsUtils.HadoopFileStatus.class);
        FileStatus mockSourceStatus = (FileStatus)Mockito.mock(FileStatus.class);
        AclStatus mockAclStatus = (AclStatus)Mockito.mock(AclStatus.class);
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)mockSourceStatus.getPermission()).thenReturn((Object)new FsPermission(777));
        Mockito.when((Object)mockAclStatus.toString()).thenReturn((Object)"");
        Mockito.when((Object)mockHadoopFileStatus.getFileStatus()).thenReturn((Object)mockSourceStatus);
        Mockito.when((Object)mockHadoopFileStatus.getAclEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)mockHadoopFileStatus.getAclStatus()).thenReturn((Object)mockAclStatus);
        ((FileSystem)Mockito.doThrow(RuntimeException.class).when((Object)mockFs)).setAcl((Path)Matchers.any(Path.class), (List)Matchers.any(List.class));
        HdfsUtils.setFullFileStatus((Configuration)conf, (HdfsUtils.HadoopFileStatus)mockHadoopFileStatus, null, (FileSystem)mockFs, (Path)new Path("fakePath"), (boolean)false);
        ((FileSystem)Mockito.verify((Object)mockFs)).setAcl((Path)Matchers.any(Path.class), (List)Matchers.any(List.class));
    }

    @Test
    public void testSetFullFileStatusFailInheritPerms() throws IOException {
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.acls.enabled", "false");
        HdfsUtils.HadoopFileStatus mockHadoopFileStatus = (HdfsUtils.HadoopFileStatus)Mockito.mock(HdfsUtils.HadoopFileStatus.class);
        FileStatus mockSourceStatus = (FileStatus)Mockito.mock(FileStatus.class);
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)mockSourceStatus.getPermission()).thenReturn((Object)new FsPermission(777));
        Mockito.when((Object)mockHadoopFileStatus.getFileStatus()).thenReturn((Object)mockSourceStatus);
        ((FileSystem)Mockito.doThrow(RuntimeException.class).when((Object)mockFs)).setPermission((Path)Matchers.any(Path.class), (FsPermission)Matchers.any(FsPermission.class));
        HdfsUtils.setFullFileStatus((Configuration)conf, (HdfsUtils.HadoopFileStatus)mockHadoopFileStatus, null, (FileSystem)mockFs, (Path)new Path("fakePath"), (boolean)false);
        ((FileSystem)Mockito.verify((Object)mockFs)).setPermission((Path)Matchers.any(Path.class), (FsPermission)Matchers.any(FsPermission.class));
    }

    @Test
    public void testSetFullFileStatusFailInheritGroupRecursive() throws Exception {
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.acls.enabled", "false");
        String fakeSourceGroup = "fakeGroup1";
        String fakeTargetGroup = "fakeGroup2";
        Path fakeTarget = new Path("fakePath");
        HdfsUtils.HadoopFileStatus mockHadoopFileStatus = (HdfsUtils.HadoopFileStatus)Mockito.mock(HdfsUtils.HadoopFileStatus.class);
        FileStatus mockSourceStatus = (FileStatus)Mockito.mock(FileStatus.class);
        FsShell mockFsShell = (FsShell)Mockito.mock(FsShell.class);
        Mockito.when((Object)mockSourceStatus.getGroup()).thenReturn((Object)fakeSourceGroup);
        Mockito.when((Object)mockHadoopFileStatus.getFileStatus()).thenReturn((Object)mockSourceStatus);
        ((FsShell)Mockito.doThrow(RuntimeException.class).when((Object)mockFsShell)).run((String[])Matchers.any(String[].class));
        HdfsUtils.setFullFileStatus((Configuration)conf, (HdfsUtils.HadoopFileStatus)mockHadoopFileStatus, (String)fakeTargetGroup, (FileSystem)((FileSystem)Mockito.mock(FileSystem.class)), (Path)fakeTarget, (boolean)true, (FsShell)mockFsShell);
        ((FsShell)Mockito.verify((Object)mockFsShell)).run(new String[]{"-chgrp", "-R", fakeSourceGroup, fakeTarget.toString()});
    }

    @Test
    public void testSetFullFileStatusFailInheritAclsRecursive() throws Exception {
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.acls.enabled", "true");
        Path fakeTarget = new Path("fakePath");
        HdfsUtils.HadoopFileStatus mockHadoopFileStatus = (HdfsUtils.HadoopFileStatus)Mockito.mock(HdfsUtils.HadoopFileStatus.class);
        FileStatus mockSourceStatus = (FileStatus)Mockito.mock(FileStatus.class);
        FsShell mockFsShell = (FsShell)Mockito.mock(FsShell.class);
        AclStatus mockAclStatus = (AclStatus)Mockito.mock(AclStatus.class);
        Mockito.when((Object)mockSourceStatus.getPermission()).thenReturn((Object)new FsPermission(777));
        Mockito.when((Object)mockAclStatus.toString()).thenReturn((Object)"");
        Mockito.when((Object)mockHadoopFileStatus.getFileStatus()).thenReturn((Object)mockSourceStatus);
        Mockito.when((Object)mockHadoopFileStatus.getAclEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)mockHadoopFileStatus.getAclStatus()).thenReturn((Object)mockAclStatus);
        ((FsShell)Mockito.doThrow(RuntimeException.class).when((Object)mockFsShell)).run((String[])Matchers.any(String[].class));
        HdfsUtils.setFullFileStatus((Configuration)conf, (HdfsUtils.HadoopFileStatus)mockHadoopFileStatus, (String)"", (FileSystem)((FileSystem)Mockito.mock(FileSystem.class)), (Path)fakeTarget, (boolean)true, (FsShell)mockFsShell);
        ((FsShell)Mockito.verify((Object)mockFsShell)).run(new String[]{"-setfacl", "-R", "--set", (String)Matchers.any(String.class), fakeTarget.toString()});
    }

    @Test
    public void testSetFullFileStatusFailInheritPermsRecursive() throws Exception {
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.acls.enabled", "false");
        Path fakeTarget = new Path("fakePath");
        HdfsUtils.HadoopFileStatus mockHadoopFileStatus = (HdfsUtils.HadoopFileStatus)Mockito.mock(HdfsUtils.HadoopFileStatus.class);
        FileStatus mockSourceStatus = (FileStatus)Mockito.mock(FileStatus.class);
        FsShell mockFsShell = (FsShell)Mockito.mock(FsShell.class);
        Mockito.when((Object)mockSourceStatus.getPermission()).thenReturn((Object)new FsPermission(777));
        Mockito.when((Object)mockHadoopFileStatus.getFileStatus()).thenReturn((Object)mockSourceStatus);
        ((FsShell)Mockito.doThrow(RuntimeException.class).when((Object)mockFsShell)).run((String[])Matchers.any(String[].class));
        HdfsUtils.setFullFileStatus((Configuration)conf, (HdfsUtils.HadoopFileStatus)mockHadoopFileStatus, (String)"", (FileSystem)((FileSystem)Mockito.mock(FileSystem.class)), (Path)fakeTarget, (boolean)true, (FsShell)mockFsShell);
        ((FsShell)Mockito.verify((Object)mockFsShell)).run(new String[]{"-chmod", "-R", (String)Matchers.any(String.class), fakeTarget.toString()});
    }
}

