/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.security;

import io.hops.common.Pair;
import io.hops.security.HopsUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.TUGIBasedProcessor;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.TUGIContainingTransport;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.ProcessFunction;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSSLBasedProcessor<I extends ThriftHiveMetastore.Iface>
extends TUGIBasedProcessor<ThriftHiveMetastore.Iface> {
    private final I iface;
    private final Map<String, ProcessFunction<ThriftHiveMetastore.Iface, ? extends TBase>> functions;
    static final Logger LOG = LoggerFactory.getLogger(TSSLBasedProcessor.class);
    private Configuration metastoreConf = null;

    public TSSLBasedProcessor(I iface, Configuration metastoreConf) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        super(iface);
        this.iface = iface;
        this.functions = this.getProcessMapView();
        this.metastoreConf = metastoreConf;
    }

    @Override
    public boolean process(final TProtocol in, final TProtocol out) throws TException {
        this.setIpAddress(in);
        final TMessage msg = in.readMessageBegin();
        final ProcessFunction<ThriftHiveMetastore.Iface, ? extends TBase> fn = this.functions.get(msg.name);
        if (fn == null) {
            TProtocolUtil.skip((TProtocol)in, (byte)12);
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(1, "Invalid method name: '" + msg.name + "'");
            out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
            x.write(out);
            out.writeMessageEnd();
            out.getTransport().flush();
            return true;
        }
        TUGIContainingTransport ugiTrans = (TUGIContainingTransport)in.getTransport();
        if (msg.name.equalsIgnoreCase("set_ugi")) {
            try {
                this.handleSetUGISSL(ugiTrans, (ThriftHiveMetastore.Processor.set_ugi)fn, msg, in, out);
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TException(e.getCause());
            }
            return true;
        }
        UserGroupInformation clientUgi = ugiTrans.getClientUGI();
        if (null == clientUgi) {
            throw new TException("UGI missing from the request");
        }
        try {
            PrivilegedExceptionAction<Void> pvea = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() {
                    try {
                        fn.process(msg.seqid, in, out, (Object)TSSLBasedProcessor.this.iface);
                        return null;
                    }
                    catch (TException te) {
                        throw new RuntimeException(te);
                    }
                }
            };
            clientUgi.doAs((PrivilegedExceptionAction)pvea);
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException rte) {
            if (rte.getCause() instanceof TException) {
                throw (TException)rte.getCause();
            }
            throw rte;
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                FileSystem.closeAllForUGI((UserGroupInformation)clientUgi);
            }
            catch (IOException e) {
                LOG.error("Could not clean up file-system handles for UGI: " + clientUgi, (Throwable)e);
            }
        }
    }

    private Pair<String, String> extractDN(TProtocol in) throws TException, SSLException {
        TTransport tTransport = in.getTransport();
        Socket socket = ((TUGIContainingTransport)tTransport).getSocket();
        X509Certificate[] certs = ((SSLSocket)socket).getSession().getPeerCertificateChain();
        if (certs.length == 0) {
            LOG.error("Client certificate not available");
            throw new SSLException("Client certificate not available");
        }
        String DN = certs[0].getSubjectDN().getName();
        String CN = HopsUtil.extractCNFromSubject((String)DN);
        String applicationId = HopsUtil.extractOFromSubject((String)DN);
        if (CN.contains("__")) {
            return new Pair((Object)CN, (Object)applicationId);
        }
        InetAddress hostnameIp = null;
        try {
            hostnameIp = InetAddress.getByName(CN);
        }
        catch (UnknownHostException ex) {
            LOG.error("Cannot resolve machine address: ", (Throwable)ex);
            throw new TException("Cannot authenticate the user");
        }
        if (!hostnameIp.getHostAddress().equals(HiveMetaStore.HMSHandler.getThreadLocalIpAddress())) {
            LOG.error("Superuser request coming from a different host");
            throw new TException("Cannot authenticate the user");
        }
        return new Pair((Object)MetastoreConf.getVar(this.metastoreConf, MetastoreConf.ConfVars.HIVE_SUPER_USER), null);
    }

    protected void handleSetUGISSL(TUGIContainingTransport ugiTrans, ThriftHiveMetastore.Processor.set_ugi<ThriftHiveMetastore.Iface> fn, TMessage msg, TProtocol iprot, TProtocol oprot) throws TException, SecurityException, SSLException, IllegalArgumentException {
        UserGroupInformation clientUgi = ugiTrans.getClientUGI();
        if (null != clientUgi) {
            throw new TException((Throwable)new IllegalStateException("UGI is already set. Resetting is not allowed. Current ugi is: " + clientUgi.getUserName()));
        }
        ThriftHiveMetastore.set_ugi_args args = fn.getEmptyArgsInstance();
        try {
            args.read(iprot);
        }
        catch (TProtocolException e) {
            iprot.readMessageEnd();
            TApplicationException x = new TApplicationException(7, e.getMessage());
            oprot.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
            x.write(oprot);
            oprot.writeMessageEnd();
            oprot.getTransport().flush();
            return;
        }
        iprot.readMessageEnd();
        ThriftHiveMetastore.set_ugi_result result = fn.getResult((ThriftHiveMetastore.Iface)this.iface, args);
        List<String> principals = result.getSuccess();
        String user = principals.remove(principals.size() - 1);
        Pair<String, String> certDN = this.extractDN(iprot);
        if (!user.equals(certDN.getL())) {
            LOG.error("Mismatch between the UGI user: ", new Object[]{user, " and common name in the certificate: ", certDN.getL()});
            throw new TTransportException("Client not authorized.");
        }
        clientUgi = UserGroupInformation.createRemoteUser((String)user);
        if (certDN.getR() != null) {
            clientUgi.addApplicationId((String)certDN.getR());
        }
        ugiTrans.setClientUGI(clientUgi);
        oprot.writeMessageBegin(new TMessage(msg.name, 2, msg.seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
    }
}

