/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.base.Strings;
import com.google.common.net.InetAddresses;
import com.logicalclocks.servicediscoverclient.Builder;
import com.logicalclocks.servicediscoverclient.ServiceDiscoveryClient;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.resolvers.Type;
import com.logicalclocks.servicediscoverclient.service.Service;
import com.logicalclocks.servicediscoverclient.service.ServiceQuery;
import io.hops.net.ServiceDiscoveryClientFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import net.spy.memcached.compat.log.Logger;
import net.spy.memcached.compat.log.LoggerFactory;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.MetaException;

public class CachedServiceDiscoveryResolver {
    private static final Logger LOG = LoggerFactory.getLogger(CachedServiceDiscoveryResolver.class);
    private final Configuration conf;
    private final ServiceDiscoveryClient client;

    public CachedServiceDiscoveryResolver(Configuration conf) {
        this.conf = conf;
        this.client = this.initializeServiceDiscoveryClient();
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public String resolveLocationURI(String locationURI) throws MetaException {
        if (this.client == null) {
            return locationURI;
        }
        URI uri = URI.create(locationURI);
        if (Strings.isNullOrEmpty((String)uri.getHost())) {
            return locationURI;
        }
        if (InetAddresses.isInetAddress((String)uri.getHost())) {
            return locationURI;
        }
        try {
            Service nn = (Service)this.client.getService(ServiceQuery.of((String)uri.getHost(), Collections.emptySet())).findAny().orElseThrow(() -> new MetaException("Service Discovery is enabled but could not resolve domain " + uri.getHost()));
            return new URI(uri.getScheme(), uri.getUserInfo(), nn.getAddress(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
        }
        catch (ServiceDiscoveryException | URISyntaxException ex) {
            String msg = "Could not resolve NameNode service with Service Discovery";
            LOG.warn((Object)msg, ex);
            throw new MetaException(ex.getMessage() != null ? ex.getMessage() : msg);
        }
    }

    private ServiceDiscoveryClient initializeServiceDiscoveryClient() {
        block3: {
            if (this.conf.getBoolean("hops.service-discovery.enabled", false)) {
                ServiceDiscoveryClient dnsResolver = null;
                ServiceDiscoveryClientFactory factory = ServiceDiscoveryClientFactory.getInstance();
                Pair nameserver = factory.getNameserver(this.conf);
                try {
                    dnsResolver = new Builder(Type.DNS).withDnsHost((String)nameserver.getFirst()).withDnsPort((Integer)nameserver.getSecond()).build();
                    Builder cachedDNSResolver = new Builder(Type.CACHING).withCacheExpiration(Duration.of(30L, ChronoUnit.SECONDS)).withServiceDiscoveryClient(dnsResolver);
                    return factory.getClient(cachedDNSResolver);
                }
                catch (ServiceDiscoveryException ex) {
                    if (dnsResolver == null) break block3;
                    dnsResolver.close();
                    throw new RuntimeException("Could not initialize Service Discovery client", ex);
                }
            }
        }
        return null;
    }
}

