/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HopsTLSTSocketFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TTransportException;

public class TServerSocketFactory {
    public static TServerSocket getServerSocket(Configuration conf, TSocketType socketType, String hiveHost, int portNum) throws TTransportException {
        InetSocketAddress serverAddress = TServerSocketFactory.getServerAddress(hiveHost, portNum);
        switch (socketType) {
            case PLAIN: {
                return new TServerSocket(serverAddress);
            }
        }
        HopsTLSTSocketFactory.HopsTLSTransportParams params = new HopsTLSTSocketFactory.HopsTLSTransportParams();
        params.ifAddress = serverAddress;
        params.clientAuth = socketType == TSocketType.TWOWAYTLS;
        params.clientTimeout = 0;
        params.enabledProtocols = conf.getStrings("hadoop.ssl.enabled.protocols", new String[]{"TLSv1.2,TLSv1.1"});
        String excludeCiphersConf = conf.get("ssl.server.exclude.cipher.list", "");
        params.excludeCiphers = excludeCiphersConf.isEmpty() ? new LinkedList<String>() : Arrays.asList(excludeCiphersConf.split(","));
        return HopsTLSTSocketFactory.getServerSocket(conf, params);
    }

    private static InetSocketAddress getServerAddress(String hiveHost, int portNum) {
        InetSocketAddress serverAddress = hiveHost == null || hiveHost.isEmpty() ? new InetSocketAddress(portNum) : new InetSocketAddress(hiveHost, portNum);
        return serverAddress;
    }

    public static enum TSocketType {
        PLAIN,
        TLS,
        TWOWAYTLS;

    }
}

