/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.util.List;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.junit.Assert;

public class InjectableBehaviourObjectStore
extends ObjectStore {
    private static Function<Table, Table> getTableModifier = Functions.identity();
    private static Function<List<String>, List<String>> listPartitionNamesModifier = Functions.identity();
    private static Function<NotificationEventResponse, NotificationEventResponse> getNextNotificationModifier = Functions.identity();

    public static void setGetTableBehaviour(Function<Table, Table> modifier) {
        getTableModifier = modifier == null ? Functions.identity() : modifier;
    }

    public static void resetGetTableBehaviour() {
        InjectableBehaviourObjectStore.setGetTableBehaviour(null);
    }

    public static void setListPartitionNamesBehaviour(Function<List<String>, List<String>> modifier) {
        listPartitionNamesModifier = modifier == null ? Functions.identity() : modifier;
    }

    public static void resetListPartitionNamesBehaviour() {
        InjectableBehaviourObjectStore.setListPartitionNamesBehaviour(null);
    }

    public static void setGetNextNotificationBehaviour(Function<NotificationEventResponse, NotificationEventResponse> modifier) {
        getNextNotificationModifier = modifier == null ? Functions.identity() : modifier;
    }

    public static void resetGetNextNotificationBehaviour() {
        InjectableBehaviourObjectStore.setGetNextNotificationBehaviour(null);
    }

    public Table getTable(String catName, String dbName, String tableName) throws MetaException {
        return (Table)getTableModifier.apply((Object)super.getTable(catName, dbName, tableName));
    }

    public Table getTable(String catName, String dbName, String tableName, boolean resolveHostname) throws MetaException {
        return (Table)getTableModifier.apply((Object)super.getTable(catName, dbName, tableName, resolveHostname));
    }

    public List<String> listPartitionNames(String catName, String dbName, String tableName, short max) throws MetaException {
        return (List)listPartitionNamesModifier.apply((Object)super.listPartitionNames(catName, dbName, tableName, max));
    }

    public NotificationEventResponse getNextNotification(NotificationEventRequest rqst) {
        return (NotificationEventResponse)getNextNotificationModifier.apply((Object)super.getNextNotification(rqst));
    }

    public static abstract class BehaviourInjection<T, F>
    implements Function<T, F> {
        protected boolean injectionPathCalled = false;
        protected boolean nonInjectedPathCalled = false;

        public void assertInjectionsPerformed(boolean expectedInjectionCalled, boolean expectedNonInjectedPathCalled) {
            Assert.assertEquals((Object)expectedInjectionCalled, (Object)this.injectionPathCalled);
            Assert.assertEquals((Object)expectedNonInjectedPathCalled, (Object)this.nonInjectedPathCalled);
        }
    }
}

