/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.MaterializationsInvalidationCache;
import org.apache.hadoop.hive.metastore.api.BasicTxnInfo;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.Table;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.mockito.Mockito;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestMetaStoreMaterializationsCacheCleaner {
    private static final String DB_NAME = "hive3252";
    private static final String TBL_NAME_1 = "tmptbl1";
    private static final String TBL_NAME_2 = "tmptbl2";
    private static final String TBL_NAME_3 = "tmptbl3";
    private static final String MV_NAME_1 = "mv1";
    private static final String MV_NAME_2 = "mv2";

    @Test
    public void testCleanerScenario1() throws Exception {
        Configuration conf = new Configuration();
        conf.set("metastore.materializations.invalidation.impl", "DISABLE");
        IHMSHandler handler = (IHMSHandler)Mockito.mock(IHMSHandler.class);
        MaterializationsInvalidationCache.get().init(conf, handler);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_1, 1L, 1L, false);
        int id = 2;
        BasicTxnInfo txn2 = TestMetaStoreMaterializationsCacheCleaner.createTxnInfo(DB_NAME, TBL_NAME_1, id);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_1, (long)id, (long)id, false);
        id = 3;
        BasicTxnInfo txn3 = TestMetaStoreMaterializationsCacheCleaner.createTxnInfo(DB_NAME, TBL_NAME_1, id);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_2, (long)id, (long)id, false);
        long removed = MaterializationsInvalidationCache.get().cleanup(0L);
        Assert.assertEquals((long)0L, (long)removed);
        Table mv1 = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)mv1.getDbName()).thenReturn((Object)DB_NAME);
        Mockito.when((Object)mv1.getTableName()).thenReturn((Object)MV_NAME_1);
        CreationMetadata mockCM1 = new CreationMetadata("hive", DB_NAME, MV_NAME_1, (Set)ImmutableSet.of((Object)"hive3252.tmptbl1", (Object)"hive3252.tmptbl2"));
        mockCM1.setValidTxnList("3:9223372036854775807::");
        Mockito.when((Object)mv1.getCreationMetadata()).thenReturn((Object)mockCM1);
        MaterializationsInvalidationCache.get().createMaterializedView(mockCM1.getDbName(), mockCM1.getTblName(), mockCM1.getTablesUsed(), mockCM1.getValidTxnList());
        Map invalidationInfos = MaterializationsInvalidationCache.get().getMaterializationInvalidationInfo(DB_NAME, (List)ImmutableList.of((Object)MV_NAME_1));
        Assert.assertTrue((boolean)invalidationInfos.isEmpty());
        id = 10;
        BasicTxnInfo txn10 = TestMetaStoreMaterializationsCacheCleaner.createTxnInfo(DB_NAME, TBL_NAME_2, id);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_2, (long)id, (long)id, false);
        id = 9;
        BasicTxnInfo txn9 = TestMetaStoreMaterializationsCacheCleaner.createTxnInfo(DB_NAME, TBL_NAME_1, id);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_1, (long)id, (long)id, false);
        removed = MaterializationsInvalidationCache.get().cleanup(8L);
        Assert.assertEquals((long)0L, (long)removed);
        invalidationInfos = MaterializationsInvalidationCache.get().getMaterializationInvalidationInfo(DB_NAME, (List)ImmutableList.of((Object)MV_NAME_1));
        Assert.assertTrue((boolean)invalidationInfos.isEmpty());
        Table mv2 = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)mv2.getDbName()).thenReturn((Object)DB_NAME);
        Mockito.when((Object)mv2.getTableName()).thenReturn((Object)MV_NAME_2);
        CreationMetadata mockCM2 = new CreationMetadata("hive", DB_NAME, MV_NAME_2, (Set)ImmutableSet.of((Object)"hive3252.tmptbl1", (Object)"hive3252.tmptbl2"));
        mockCM2.setValidTxnList("10:9223372036854775807::");
        Mockito.when((Object)mv2.getCreationMetadata()).thenReturn((Object)mockCM2);
        MaterializationsInvalidationCache.get().createMaterializedView(mockCM2.getDbName(), mockCM2.getTblName(), mockCM2.getTablesUsed(), mockCM2.getValidTxnList());
        Mockito.when((Object)mv2.getCreationMetadata()).thenReturn((Object)mockCM2);
        invalidationInfos = MaterializationsInvalidationCache.get().getMaterializationInvalidationInfo(DB_NAME, (List)ImmutableList.of((Object)MV_NAME_1, (Object)MV_NAME_2));
        Assert.assertTrue((boolean)invalidationInfos.isEmpty());
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_3, 11L, 11L, false);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_3, 18L, 18L, false);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_1, 14L, 14L, false);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_1, 17L, 17L, false);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_2, 16L, 16L, false);
        removed = MaterializationsInvalidationCache.get().cleanup(16L);
        Assert.assertEquals((long)0L, (long)removed);
        invalidationInfos = MaterializationsInvalidationCache.get().getMaterializationInvalidationInfo(DB_NAME, (List)ImmutableList.of((Object)MV_NAME_1, (Object)MV_NAME_2));
        Assert.assertTrue((boolean)invalidationInfos.isEmpty());
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_1, 12L, 12L, false);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_2, 15L, 15L, false);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_2, 7L, 7L, false);
        invalidationInfos = MaterializationsInvalidationCache.get().getMaterializationInvalidationInfo(DB_NAME, (List)ImmutableList.of((Object)MV_NAME_1, (Object)MV_NAME_2));
        Assert.assertTrue((boolean)invalidationInfos.isEmpty());
        removed = MaterializationsInvalidationCache.get().cleanup(20L);
        Assert.assertEquals((long)0L, (long)removed);
        invalidationInfos = MaterializationsInvalidationCache.get().getMaterializationInvalidationInfo(DB_NAME, (List)ImmutableList.of((Object)MV_NAME_1, (Object)MV_NAME_2));
        Assert.assertTrue((boolean)invalidationInfos.isEmpty());
        removed = MaterializationsInvalidationCache.get().cleanup(24L);
        Assert.assertEquals((long)0L, (long)removed);
    }

    @Test
    public void testCleanerScenario2() throws Exception {
        Configuration conf = new Configuration();
        conf.set("metastore.materializations.invalidation.impl", "DEFAULT");
        IHMSHandler handler = (IHMSHandler)Mockito.mock(IHMSHandler.class);
        MaterializationsInvalidationCache.get().init(conf, handler);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_1, 1L, 1L, false);
        int id = 2;
        BasicTxnInfo txn2 = TestMetaStoreMaterializationsCacheCleaner.createTxnInfo(DB_NAME, TBL_NAME_1, id);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_1, (long)id, (long)id, false);
        id = 3;
        BasicTxnInfo txn3 = TestMetaStoreMaterializationsCacheCleaner.createTxnInfo(DB_NAME, TBL_NAME_1, id);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_2, (long)id, (long)id, false);
        long removed = MaterializationsInvalidationCache.get().cleanup(0L);
        Assert.assertEquals((long)0L, (long)removed);
        Table mv1 = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)mv1.getDbName()).thenReturn((Object)DB_NAME);
        Mockito.when((Object)mv1.getTableName()).thenReturn((Object)MV_NAME_1);
        CreationMetadata mockCM1 = new CreationMetadata("hive", DB_NAME, MV_NAME_1, (Set)ImmutableSet.of((Object)"hive3252.tmptbl1", (Object)"hive3252.tmptbl2"));
        mockCM1.setValidTxnList("3$hive3252.tmptbl1:3:9223372036854775807::$hive3252.tmptbl2:3:9223372036854775807::");
        Mockito.when((Object)mv1.getCreationMetadata()).thenReturn((Object)mockCM1);
        MaterializationsInvalidationCache.get().createMaterializedView(mockCM1.getDbName(), mockCM1.getTblName(), mockCM1.getTablesUsed(), mockCM1.getValidTxnList());
        Map invalidationInfos = MaterializationsInvalidationCache.get().getMaterializationInvalidationInfo(DB_NAME, (List)ImmutableList.of((Object)MV_NAME_1));
        Assert.assertEquals((long)0L, (long)((Materialization)invalidationInfos.get(MV_NAME_1)).getInvalidationTime());
        id = 10;
        BasicTxnInfo txn10 = TestMetaStoreMaterializationsCacheCleaner.createTxnInfo(DB_NAME, TBL_NAME_2, id);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_2, (long)id, (long)id, false);
        id = 9;
        BasicTxnInfo txn9 = TestMetaStoreMaterializationsCacheCleaner.createTxnInfo(DB_NAME, TBL_NAME_1, id);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_1, (long)id, (long)id, false);
        removed = MaterializationsInvalidationCache.get().cleanup(8L);
        Assert.assertEquals((long)3L, (long)removed);
        invalidationInfos = MaterializationsInvalidationCache.get().getMaterializationInvalidationInfo(DB_NAME, (List)ImmutableList.of((Object)MV_NAME_1));
        Assert.assertEquals((long)9L, (long)((Materialization)invalidationInfos.get(MV_NAME_1)).getInvalidationTime());
        Table mv2 = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)mv2.getDbName()).thenReturn((Object)DB_NAME);
        Mockito.when((Object)mv2.getTableName()).thenReturn((Object)MV_NAME_2);
        CreationMetadata mockCM2 = new CreationMetadata("hive", DB_NAME, MV_NAME_2, (Set)ImmutableSet.of((Object)"hive3252.tmptbl1", (Object)"hive3252.tmptbl2"));
        mockCM2.setValidTxnList("10$hive3252.tmptbl1:10:9223372036854775807::$hive3252.tmptbl2:10:9223372036854775807::");
        Mockito.when((Object)mv2.getCreationMetadata()).thenReturn((Object)mockCM2);
        MaterializationsInvalidationCache.get().createMaterializedView(mockCM2.getDbName(), mockCM2.getTblName(), mockCM2.getTablesUsed(), mockCM2.getValidTxnList());
        Mockito.when((Object)mv2.getCreationMetadata()).thenReturn((Object)mockCM2);
        invalidationInfos = MaterializationsInvalidationCache.get().getMaterializationInvalidationInfo(DB_NAME, (List)ImmutableList.of((Object)MV_NAME_1, (Object)MV_NAME_2));
        Assert.assertEquals((long)9L, (long)((Materialization)invalidationInfos.get(MV_NAME_1)).getInvalidationTime());
        Assert.assertEquals((long)0L, (long)((Materialization)invalidationInfos.get(MV_NAME_2)).getInvalidationTime());
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_3, 11L, 11L, false);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_3, 18L, 18L, false);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_1, 14L, 14L, false);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_1, 17L, 17L, false);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_2, 16L, 16L, false);
        removed = MaterializationsInvalidationCache.get().cleanup(16L);
        Assert.assertEquals((long)2L, (long)removed);
        invalidationInfos = MaterializationsInvalidationCache.get().getMaterializationInvalidationInfo(DB_NAME, (List)ImmutableList.of((Object)MV_NAME_1, (Object)MV_NAME_2));
        Assert.assertEquals((long)9L, (long)((Materialization)invalidationInfos.get(MV_NAME_1)).getInvalidationTime());
        Assert.assertEquals((long)14L, (long)((Materialization)invalidationInfos.get(MV_NAME_2)).getInvalidationTime());
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_1, 12L, 12L, false);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_2, 15L, 15L, false);
        MaterializationsInvalidationCache.get().notifyTableModification(DB_NAME, TBL_NAME_2, 7L, 7L, false);
        invalidationInfos = MaterializationsInvalidationCache.get().getMaterializationInvalidationInfo(DB_NAME, (List)ImmutableList.of((Object)MV_NAME_1, (Object)MV_NAME_2));
        Assert.assertEquals((long)7L, (long)((Materialization)invalidationInfos.get(MV_NAME_1)).getInvalidationTime());
        Assert.assertEquals((long)12L, (long)((Materialization)invalidationInfos.get(MV_NAME_2)).getInvalidationTime());
        removed = MaterializationsInvalidationCache.get().cleanup(20L);
        Assert.assertEquals((long)6L, (long)removed);
        invalidationInfos = MaterializationsInvalidationCache.get().getMaterializationInvalidationInfo(DB_NAME, (List)ImmutableList.of((Object)MV_NAME_1, (Object)MV_NAME_2));
        Assert.assertEquals((long)7L, (long)((Materialization)invalidationInfos.get(MV_NAME_1)).getInvalidationTime());
        Assert.assertEquals((long)12L, (long)((Materialization)invalidationInfos.get(MV_NAME_2)).getInvalidationTime());
        removed = MaterializationsInvalidationCache.get().cleanup(24L);
        Assert.assertEquals((long)0L, (long)removed);
    }

    private static BasicTxnInfo createTxnInfo(String dbName, String tableName, int i) {
        BasicTxnInfo r = new BasicTxnInfo();
        r.setDbname(dbName);
        r.setTablename(tableName);
        r.setTxnid((long)i);
        r.setTime((long)i);
        return r;
    }
}

