/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.codahale.metrics.Counter;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.logicalclocks.servicediscoverclient.Builder;
import com.logicalclocks.servicediscoverclient.ServiceDiscoveryClient;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.resolvers.CachingResolver;
import com.logicalclocks.servicediscoverclient.resolvers.DnsResolver;
import com.logicalclocks.servicediscoverclient.resolvers.Type;
import com.logicalclocks.servicediscoverclient.service.Service;
import com.logicalclocks.servicediscoverclient.service.ServiceQuery;
import io.hops.net.ServiceDiscoveryClientFactory;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jdo.Query;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.model.MNotificationLog;
import org.apache.hadoop.hive.metastore.model.MNotificationNextId;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MetastoreUnitTest.class})
public class TestObjectStore {
    private ObjectStore objectStore = null;
    private Configuration conf;
    private static final String DB1 = "testobjectstoredb1";
    private static final String DB2 = "testobjectstoredb2";
    private static final String TABLE1 = "testobjectstoretable1";
    private static final String KEY1 = "testobjectstorekey1";
    private static final String KEY2 = "testobjectstorekey2";
    private static final String OWNER = "testobjectstoreowner";
    private static final String USER1 = "testobjectstoreuser1";
    private static final String ROLE1 = "testobjectstorerole1";
    private static final String ROLE2 = "testobjectstorerole2";
    private static final Logger LOG = LoggerFactory.getLogger((String)TestObjectStore.class.getName());
    private Warehouse wh;

    @Before
    public void setUp() throws Exception {
        this.conf = MetastoreConf.newMetastoreConf();
        MetaStoreTestUtils.setConfForStandloneMode(this.conf);
        this.objectStore = new ObjectStore();
        this.objectStore.setConf(this.conf);
        this.wh = new Warehouse(this.conf);
        TestObjectStore.dropAllStoreObjects((RawStore)this.objectStore);
        HiveMetaStore.HMSHandler.createDefaultCatalog((RawStore)this.objectStore, (Warehouse)this.wh);
    }

    @Test
    public void catalogs() throws MetaException, NoSuchObjectException {
        String[] names = new String[]{"cat1", "cat2"};
        String[] locations = new String[]{"loc1", "loc2"};
        String[] descriptions = new String[]{"description 1", "description 2"};
        for (int i = 0; i < names.length; ++i) {
            Catalog cat = new CatalogBuilder().setName(names[i]).setLocation(locations[i]).setDescription(descriptions[i]).build();
            this.objectStore.createCatalog(cat);
        }
        List fetchedNames = this.objectStore.getCatalogs();
        Assert.assertEquals((long)3L, (long)fetchedNames.size());
        for (int i = 0; i < names.length - 1; ++i) {
            Assert.assertEquals((Object)names[i], fetchedNames.get(i));
            Catalog cat = this.objectStore.getCatalog((String)fetchedNames.get(i));
            Assert.assertEquals((Object)names[i], (Object)cat.getName());
            Assert.assertEquals((Object)descriptions[i], (Object)cat.getDescription());
            Assert.assertEquals((Object)locations[i], (Object)cat.getLocationUri());
        }
        Catalog cat = this.objectStore.getCatalog((String)fetchedNames.get(2));
        Assert.assertEquals((Object)"hive", (Object)cat.getName());
        Assert.assertEquals((Object)"Default catalog, for Hive", (Object)cat.getDescription());
        for (int i = 0; i < names.length; ++i) {
            this.objectStore.dropCatalog(names[i]);
        }
        fetchedNames = this.objectStore.getCatalogs();
        Assert.assertEquals((long)1L, (long)fetchedNames.size());
    }

    @Test(expected=NoSuchObjectException.class)
    public void getNoSuchCatalog() throws MetaException, NoSuchObjectException {
        this.objectStore.getCatalog("no_such_catalog");
    }

    @Test(expected=NoSuchObjectException.class)
    public void dropNoSuchCatalog() throws MetaException, NoSuchObjectException {
        this.objectStore.dropCatalog("no_such_catalog");
    }

    @Test
    public void testDatabaseOps() throws MetaException, InvalidObjectException, NoSuchObjectException {
        Path db1Path = new Path(this.wh.getWhRoot(), DB1);
        this.wh.mkdirs(db1Path);
        Path db2Path = new Path(this.wh.getWhRoot(), DB2);
        this.wh.mkdirs(db2Path);
        String catName = "tdo1_cat";
        this.createTestCatalog(catName);
        Database db1 = new Database(DB1, "description", "locationurl", null);
        Database db2 = new Database(DB2, "description", "locationurl", null);
        db1.setCatalogName(catName);
        db2.setCatalogName(catName);
        this.objectStore.createDatabase(db1);
        this.objectStore.createDatabase(db2);
        List databases = this.objectStore.getAllDatabases(catName);
        LOG.info("databases: " + databases);
        Assert.assertEquals((long)2L, (long)databases.size());
        Assert.assertEquals((Object)DB1, databases.get(0));
        Assert.assertEquals((Object)DB2, databases.get(1));
        this.objectStore.dropDatabase(catName, DB1);
        databases = this.objectStore.getAllDatabases(catName);
        Assert.assertEquals((long)1L, (long)databases.size());
        Assert.assertEquals((Object)DB2, databases.get(0));
        this.objectStore.dropDatabase(catName, DB2);
        this.wh.deleteDir(db1Path, true);
        this.wh.deleteDir(db2Path, true);
    }

    @Test
    public void testDatabaseOpsWithServiceDiscovery() throws Exception {
        Configuration conf = new Configuration(this.conf);
        conf.setBoolean("hops.service-discovery.enabled", true);
        String locationURI = "hdfs://namenode.service.consul:8020/some/location.db";
        String expectedURI = "hdfs://10.0.0.1:8020/some/location.db";
        HashSet nns = Sets.newHashSet((Object[])new Service[]{Service.of((String)"namenode.service.consul", (String)"10.0.0.1", (Integer)8020), Service.of((String)"namenode.service.consul", (String)"10.0.0.1", (Integer)50470)});
        DnsResolver dnsResolver = (DnsResolver)Mockito.mock(DnsResolver.class);
        Mockito.when((Object)dnsResolver.getService((ServiceQuery)Matchers.any(ServiceQuery.class))).thenReturn(nns.stream());
        Builder cachingResolverBuilder = new Builder(Type.CACHING).withServiceDiscoveryClient((ServiceDiscoveryClient)dnsResolver);
        CachingResolver cachingResolver = (CachingResolver)Mockito.mock(CachingResolver.class);
        ((CachingResolver)Mockito.doCallRealMethod().when((Object)cachingResolver)).init((Builder)Matchers.any(Builder.class));
        Mockito.when((Object)cachingResolver.getService((ServiceQuery)Matchers.any(ServiceQuery.class))).thenCallRealMethod();
        cachingResolver.init(cachingResolverBuilder);
        ServiceDiscoveryClientFactory.getInstance().setClient((ServiceDiscoveryClient)cachingResolver);
        ObjectStore objectStore = new ObjectStore();
        objectStore.setConf(conf);
        Warehouse wh = new Warehouse(conf);
        TestObjectStore.dropAllStoreObjects((RawStore)objectStore);
        HiveMetaStore.HMSHandler.createDefaultCatalog((RawStore)objectStore, (Warehouse)wh);
        Path db1Path = new Path(wh.getWhRoot(), DB1);
        wh.mkdirs(db1Path);
        String catName = "tdo1_cat";
        this.createTestCatalog(catName);
        Catalog catalog = objectStore.getCatalog(catName);
        Assert.assertEquals((Object)"/tmp", (Object)catalog.getLocationUri());
        Mockito.when((Object)dnsResolver.getService((ServiceQuery)Matchers.any(ServiceQuery.class))).thenReturn(nns.stream());
        Database db1 = new Database(DB1, "description", locationURI, null);
        db1.setCatalogName(catName);
        objectStore.createDatabase(db1);
        Database db = objectStore.getDatabase(catName, DB1);
        Assert.assertEquals((Object)expectedURI, (Object)db.getLocationUri());
        ((CachingResolver)Mockito.verify((Object)cachingResolver, (VerificationMode)Mockito.atLeastOnce())).getService((ServiceQuery)Matchers.any(ServiceQuery.class));
        ((DnsResolver)Mockito.verify((Object)dnsResolver, (VerificationMode)Mockito.times((int)1))).getService((ServiceQuery)Matchers.any(ServiceQuery.class));
    }

    @Test
    public void testTableOps() throws MetaException, InvalidObjectException, NoSuchObjectException, InvalidInputException {
        Path db1Path = new Path(this.wh.getWhRoot(), DB1);
        this.wh.mkdirs(db1Path);
        Database db1 = new DatabaseBuilder().setName(DB1).setDescription("description").setLocation(db1Path.toString()).build(this.conf);
        this.objectStore.createDatabase(db1);
        Path tbl1Path = new Path(db1Path, TABLE1);
        this.wh.mkdirs(tbl1Path);
        StorageDescriptor sd = this.createFakeSd(tbl1Path.toString(), (List<FieldSchema>)ImmutableList.of((Object)new FieldSchema("pk_col", "double", null)));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("EXTERNAL", "false");
        Table tbl1 = new Table(TABLE1, DB1, "owner", 1, 2, 3, sd, null, params, null, null, "MANAGED_TABLE");
        this.objectStore.createTable(tbl1);
        List tables = this.objectStore.getAllTables("hive", DB1);
        Assert.assertEquals((long)1L, (long)tables.size());
        Assert.assertEquals((Object)TABLE1, tables.get(0));
        Path tbl2Path = new Path(db1Path, "newtestobjectstoretable1");
        this.wh.mkdirs(tbl2Path);
        StorageDescriptor sd2 = this.createFakeSd(tbl1Path.toString(), (List<FieldSchema>)ImmutableList.of((Object)new FieldSchema("fk_col", "double", null)));
        Table newTbl1 = new Table("newtestobjectstoretable1", DB1, "owner", 1, 2, 3, sd2, null, params, null, null, "MANAGED_TABLE");
        newTbl1.setOwner("role1");
        newTbl1.setOwnerType(PrincipalType.ROLE);
        this.objectStore.alterTable("hive", DB1, TABLE1, newTbl1);
        tables = this.objectStore.getTables("hive", DB1, "new*");
        Assert.assertEquals((long)1L, (long)tables.size());
        Assert.assertEquals((Object)"newtestobjectstoretable1", tables.get(0));
        Table alteredTable = this.objectStore.getTable("hive", DB1, "newtestobjectstoretable1");
        Assert.assertEquals((String)"Owner of table was not altered", (Object)newTbl1.getOwner(), (Object)alteredTable.getOwner());
        Assert.assertEquals((String)"Owner type of table was not altered", (Object)newTbl1.getOwnerType(), (Object)alteredTable.getOwnerType());
        this.objectStore.createTable(tbl1);
        tables = this.objectStore.getAllTables("hive", DB1);
        Assert.assertEquals((long)2L, (long)tables.size());
        List foreignKeys = this.objectStore.getForeignKeys("hive", DB1, TABLE1, null, null);
        Assert.assertEquals((long)0L, (long)foreignKeys.size());
        SQLPrimaryKey pk = new SQLPrimaryKey(DB1, TABLE1, "pk_col", 1, "pk_const_1", false, false, false);
        pk.setCatName("hive");
        this.objectStore.addPrimaryKeys((List)ImmutableList.of((Object)pk));
        SQLForeignKey fk = new SQLForeignKey(DB1, TABLE1, "pk_col", DB1, "newtestobjectstoretable1", "fk_col", 1, 0, 0, "fk_const_1", "pk_const_1", false, false, false);
        this.objectStore.addForeignKeys((List)ImmutableList.of((Object)fk));
        foreignKeys = this.objectStore.getForeignKeys("hive", null, null, DB1, "newtestobjectstoretable1");
        Assert.assertEquals((long)1L, (long)foreignKeys.size());
        List fks = this.objectStore.getForeignKeys("hive", null, null, DB1, "newtestobjectstoretable1");
        if (fks != null) {
            for (SQLForeignKey fkcol : fks) {
                this.objectStore.dropConstraint(fkcol.getCatName(), fkcol.getFktable_db(), fkcol.getFktable_name(), fkcol.getFk_name());
            }
        }
        foreignKeys = this.objectStore.getForeignKeys("hive", DB1, TABLE1, null, null);
        Assert.assertEquals((long)0L, (long)foreignKeys.size());
        foreignKeys = this.objectStore.getForeignKeys("hive", null, null, DB1, "newtestobjectstoretable1");
        Assert.assertEquals((long)0L, (long)foreignKeys.size());
        this.objectStore.dropTable("hive", DB1, TABLE1);
        tables = this.objectStore.getAllTables("hive", DB1);
        Assert.assertEquals((long)1L, (long)tables.size());
        this.objectStore.dropTable("hive", DB1, "newtestobjectstoretable1");
        tables = this.objectStore.getAllTables("hive", DB1);
        Assert.assertEquals((long)0L, (long)tables.size());
        this.objectStore.dropDatabase(db1.getCatalogName(), DB1);
    }

    @Test
    public void testTableEnforceWHAuthority() throws MetaException, InvalidObjectException, NoSuchObjectException, InvalidInputException, InvalidOperationException {
        String warehouseURI = "hopsfs://namenode.service.consul:8020/warehouse";
        Configuration conf = new Configuration(this.conf);
        conf.setStrings(MetastoreConf.ConfVars.WAREHOUSE.getVarname(), new String[]{warehouseURI});
        conf.setBoolean(MetastoreConf.ConfVars.ENFORCE_WAREHOUSE_AUTHORITY.getVarname(), true);
        ObjectStore objectStore = new ObjectStore();
        objectStore.setConf(conf);
        TestObjectStore.dropAllStoreObjects((RawStore)objectStore);
        Path db1Path = new Path(warehouseURI, DB1);
        Database db1 = new DatabaseBuilder().setName(DB1).setDescription("description").setLocation(db1Path.toString()).build(conf);
        objectStore.createDatabase(db1);
        Path tbl1Path = new Path("hopsfs://10.0.2.15:8020/warehouse", "testobjectstoredb1/testobjectstoretable1");
        StorageDescriptor sd = this.createFakeSd(tbl1Path.toString(), (List<FieldSchema>)ImmutableList.of((Object)new FieldSchema("pk_col", "double", null)));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("EXTERNAL", "false");
        Table tbl1 = new Table(TABLE1, DB1, "owner", 1, 2, 3, sd, null, params, null, null, "MANAGED_TABLE");
        objectStore.createTable(tbl1);
        Table table1 = objectStore.getTable("hive", DB1, TABLE1);
        Assert.assertTrue((boolean)table1.getSd().getLocation().startsWith(warehouseURI));
        objectStore.dropDatabase(db1.getCatalogName(), DB1);
    }

    @Test
    public void testTableServiceDiscovery() throws MetaException, InvalidObjectException, NoSuchObjectException, InvalidInputException, InvalidOperationException, ServiceDiscoveryException {
        String warehouseURI = "hopsfs://namenode.service.consul:8020/warehouse";
        Configuration conf = new Configuration(this.conf);
        conf.setStrings(MetastoreConf.ConfVars.WAREHOUSE.getVarname(), new String[]{warehouseURI});
        conf.setBoolean(MetastoreConf.ConfVars.ENFORCE_WAREHOUSE_AUTHORITY.getVarname(), true);
        conf.setBoolean("hops.service-discovery.enabled", true);
        HashSet nns = Sets.newHashSet((Object[])new Service[]{Service.of((String)"namenode.service.consul", (String)"10.0.2.15", (Integer)8020), Service.of((String)"namenode.service.consul", (String)"10.0.2.15", (Integer)8020), Service.of((String)"namenode.service.consul", (String)"10.0.2.15", (Integer)8020)});
        DnsResolver dnsResolver = (DnsResolver)Mockito.mock(DnsResolver.class);
        Mockito.when((Object)dnsResolver.getService((ServiceQuery)Matchers.any(ServiceQuery.class))).thenReturn(nns.stream());
        Builder cachingResolverBuilder = new Builder(Type.CACHING).withServiceDiscoveryClient((ServiceDiscoveryClient)dnsResolver);
        CachingResolver cachingResolver = (CachingResolver)Mockito.mock(CachingResolver.class);
        ((CachingResolver)Mockito.doCallRealMethod().when((Object)cachingResolver)).init((Builder)Matchers.any(Builder.class));
        Mockito.when((Object)cachingResolver.getService((ServiceQuery)Matchers.any(ServiceQuery.class))).thenCallRealMethod();
        cachingResolver.init(cachingResolverBuilder);
        ServiceDiscoveryClientFactory.getInstance().setClient((ServiceDiscoveryClient)cachingResolver);
        ObjectStore objectStore = new ObjectStore();
        objectStore.setConf(conf);
        TestObjectStore.dropAllStoreObjects((RawStore)objectStore);
        Path db1Path = new Path(warehouseURI, DB1);
        Database db1 = new DatabaseBuilder().setName(DB1).setDescription("description").setLocation(db1Path.toString()).build(conf);
        objectStore.createDatabase(db1);
        Path tbl1Path = new Path("hopsfs://10.0.2.15:8020/warehouse", "testobjectstoredb1/testobjectstoretable1");
        StorageDescriptor sd = this.createFakeSd(tbl1Path.toString(), (List<FieldSchema>)ImmutableList.of((Object)new FieldSchema("pk_col", "double", null)));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("EXTERNAL", "false");
        Table tbl1 = new Table(TABLE1, DB1, "owner", 1, 2, 3, sd, null, params, null, null, "MANAGED_TABLE");
        objectStore.createTable(tbl1);
        Table table1 = objectStore.getTable("hive", DB1, TABLE1);
        URI tableURI = URI.create(table1.getSd().getLocation());
        Assert.assertEquals((Object)"10.0.2.15:8020", (Object)tableURI.getAuthority());
        objectStore.dropDatabase(db1.getCatalogName(), DB1);
    }

    private StorageDescriptor createFakeSd(String location, List<FieldSchema> cols) {
        return new StorageDescriptor(cols, location, null, null, false, 0, new SerDeInfo("SerDeName", "serializationLib", null), null, null, null);
    }

    @Test
    public void testPartitionOps() throws MetaException, InvalidObjectException, NoSuchObjectException, InvalidInputException {
        Path db1Path = new Path(this.wh.getWhRoot(), DB1);
        this.wh.mkdirs(db1Path);
        Database db1 = new DatabaseBuilder().setName(DB1).setDescription("description").setLocation(db1Path.toString()).build(this.conf);
        this.objectStore.createDatabase(db1);
        Path tbl1Path = new Path(db1Path, TABLE1);
        this.wh.mkdirs(tbl1Path);
        StorageDescriptor sd = this.createFakeSd(tbl1Path.toString(), null);
        HashMap<String, String> tableParams = new HashMap<String, String>();
        tableParams.put("EXTERNAL", "false");
        FieldSchema partitionKey1 = new FieldSchema("Country", "string", "");
        FieldSchema partitionKey2 = new FieldSchema("State", "string", "");
        Table tbl1 = new Table(TABLE1, DB1, "owner", 1, 2, 3, sd, Arrays.asList(partitionKey1, partitionKey2), tableParams, null, null, "MANAGED_TABLE");
        this.objectStore.createTable(tbl1);
        HashMap<String, String> partitionParams = new HashMap<String, String>();
        partitionParams.put("PARTITION_LEVEL_PRIVILEGE", "true");
        List<String> value1 = Arrays.asList("US", "CA");
        Path part1Path = new Path(tbl1Path, "US/CA/");
        this.wh.mkdirs(part1Path);
        sd = new StorageDescriptor(null, part1Path.toString(), null, null, false, 0, new SerDeInfo("SerDeName", "serializationLib", null), null, null, null);
        Partition part1 = new Partition(value1, DB1, TABLE1, 111, 111, sd, partitionParams);
        part1.setCatName("hive");
        this.objectStore.addPartition(part1);
        Path part2Path = new Path(tbl1Path, "US/MA");
        this.wh.mkdirs(part2Path);
        sd = new StorageDescriptor(null, part2Path.toString(), null, null, false, 0, new SerDeInfo("SerDeName", "serializationLib", null), null, null, null);
        List<String> value2 = Arrays.asList("US", "MA");
        Partition part2 = new Partition(value2, DB1, TABLE1, 222, 222, sd, partitionParams);
        part2.setCatName("hive");
        this.objectStore.addPartition(part2);
        Deadline.startTimer((String)"getPartition");
        List partitions = this.objectStore.getPartitions("hive", DB1, TABLE1, 10);
        Assert.assertEquals((long)2L, (long)partitions.size());
        Assert.assertEquals((long)111L, (long)((Partition)partitions.get(0)).getCreateTime());
        Assert.assertEquals((long)222L, (long)((Partition)partitions.get(1)).getCreateTime());
        int numPartitions = this.objectStore.getNumPartitionsByFilter("hive", DB1, TABLE1, "");
        Assert.assertEquals((long)partitions.size(), (long)numPartitions);
        numPartitions = this.objectStore.getNumPartitionsByFilter("hive", DB1, TABLE1, "country = \"US\"");
        Assert.assertEquals((long)2L, (long)numPartitions);
        this.objectStore.dropPartition("hive", DB1, TABLE1, value1);
        partitions = this.objectStore.getPartitions("hive", DB1, TABLE1, 10);
        Assert.assertEquals((long)1L, (long)partitions.size());
        Assert.assertEquals((long)222L, (long)((Partition)partitions.get(0)).getCreateTime());
        this.objectStore.dropPartition("hive", DB1, TABLE1, value2);
        this.objectStore.dropTable("hive", DB1, TABLE1);
        this.objectStore.dropDatabase(db1.getCatalogName(), DB1);
    }

    @Test
    public void testPartitionEnforceWHAuthority() throws MetaException, InvalidObjectException, NoSuchObjectException, InvalidInputException {
        String warehouseURI = "hopsfs://namenode.service.consul:8020/warehouse";
        Configuration conf = new Configuration(this.conf);
        conf.setStrings(MetastoreConf.ConfVars.WAREHOUSE.getVarname(), new String[]{warehouseURI});
        conf.setBoolean(MetastoreConf.ConfVars.ENFORCE_WAREHOUSE_AUTHORITY.getVarname(), true);
        ObjectStore objectStore = new ObjectStore();
        objectStore.setConf(conf);
        TestObjectStore.dropAllStoreObjects((RawStore)objectStore);
        Path db1Path = new Path(warehouseURI, DB1);
        Database db1 = new DatabaseBuilder().setName(DB1).setDescription("description").setLocation(db1Path.toString()).build(conf);
        objectStore.createDatabase(db1);
        FieldSchema partitionKey1 = new FieldSchema("Country", "string", "");
        FieldSchema partitionKey2 = new FieldSchema("State", "string", "");
        Path tbl1Path = new Path("hopsfs://10.0.2.15:8020/warehouse", "testobjectstoredb1/testobjectstoretable1");
        StorageDescriptor sd = this.createFakeSd(tbl1Path.toString(), (List<FieldSchema>)ImmutableList.of((Object)new FieldSchema("pk_col", "double", null)));
        HashMap<String, String> tableParams = new HashMap<String, String>();
        tableParams.put("EXTERNAL", "false");
        Table tbl1 = new Table(TABLE1, DB1, "owner", 1, 2, 3, sd, Arrays.asList(partitionKey1, partitionKey2), tableParams, null, null, "MANAGED_TABLE");
        objectStore.createTable(tbl1);
        Path part1Path = new Path(tbl1Path, "US/CA/");
        StorageDescriptor partSd = this.createFakeSd(part1Path.toString(), (List<FieldSchema>)ImmutableList.of((Object)new FieldSchema("pk_col", "double", null)));
        List<String> partVals = Arrays.asList("US", "CA");
        Partition part1 = new Partition(partVals, DB1, TABLE1, 111, 111, partSd, null);
        part1.setCatName("hive");
        objectStore.addPartition(part1);
        Partition partition = objectStore.getPartition("hive", DB1, TABLE1, partVals);
        Assert.assertTrue((boolean)partition.getSd().getLocation().startsWith(warehouseURI));
        objectStore.dropDatabase(db1.getCatalogName(), DB1);
    }

    @Test
    public void testPartitionServiceDiscovery() throws MetaException, InvalidObjectException, NoSuchObjectException, InvalidInputException, ServiceDiscoveryException {
        String warehouseURI = "hopsfs://namenode.service.consul:8020/warehouse";
        Configuration conf = new Configuration(this.conf);
        conf.setStrings(MetastoreConf.ConfVars.WAREHOUSE.getVarname(), new String[]{warehouseURI});
        conf.setBoolean(MetastoreConf.ConfVars.ENFORCE_WAREHOUSE_AUTHORITY.getVarname(), true);
        conf.setBoolean("hops.service-discovery.enabled", true);
        HashSet nns = Sets.newHashSet((Object[])new Service[]{Service.of((String)"namenode.service.consul", (String)"10.0.2.15", (Integer)8020), Service.of((String)"namenode.service.consul", (String)"10.0.2.15", (Integer)8020), Service.of((String)"namenode.service.consul", (String)"10.0.2.15", (Integer)50470)});
        DnsResolver dnsResolver = (DnsResolver)Mockito.mock(DnsResolver.class);
        Mockito.when((Object)dnsResolver.getService((ServiceQuery)Matchers.any(ServiceQuery.class))).thenReturn(nns.stream());
        Builder cachingResolverBuilder = new Builder(Type.CACHING).withServiceDiscoveryClient((ServiceDiscoveryClient)dnsResolver);
        CachingResolver cachingResolver = (CachingResolver)Mockito.mock(CachingResolver.class);
        ((CachingResolver)Mockito.doCallRealMethod().when((Object)cachingResolver)).init((Builder)Matchers.any(Builder.class));
        Mockito.when((Object)cachingResolver.getService((ServiceQuery)Matchers.any(ServiceQuery.class))).thenCallRealMethod();
        cachingResolver.init(cachingResolverBuilder);
        ServiceDiscoveryClientFactory.getInstance().setClient((ServiceDiscoveryClient)cachingResolver);
        ObjectStore objectStore = new ObjectStore();
        objectStore.setConf(conf);
        TestObjectStore.dropAllStoreObjects((RawStore)objectStore);
        Path db1Path = new Path(warehouseURI, DB1);
        Database db1 = new DatabaseBuilder().setName(DB1).setDescription("description").setLocation(db1Path.toString()).build(conf);
        objectStore.createDatabase(db1);
        FieldSchema partitionKey1 = new FieldSchema("Country", "string", "");
        FieldSchema partitionKey2 = new FieldSchema("State", "string", "");
        Path tbl1Path = new Path("hopsfs://10.0.2.15:8020/warehouse", "testobjectstoredb1/testobjectstoretable1");
        StorageDescriptor sd = this.createFakeSd(tbl1Path.toString(), (List<FieldSchema>)ImmutableList.of((Object)new FieldSchema("pk_col", "double", null)));
        HashMap<String, String> tableParams = new HashMap<String, String>();
        tableParams.put("EXTERNAL", "false");
        Table tbl1 = new Table(TABLE1, DB1, "owner", 1, 2, 3, sd, Arrays.asList(partitionKey1, partitionKey2), tableParams, null, null, "MANAGED_TABLE");
        objectStore.createTable(tbl1);
        Path part1Path = new Path(tbl1Path, "US/CA");
        StorageDescriptor partSd = this.createFakeSd(part1Path.toString(), (List<FieldSchema>)ImmutableList.of((Object)new FieldSchema("pk_col", "double", null)));
        List<String> partVals = Arrays.asList("US", "CA");
        Partition part1 = new Partition(partVals, DB1, TABLE1, 111, 111, partSd, new HashMap());
        part1.setCatName("hive");
        objectStore.addPartition(part1);
        Partition partition = objectStore.getPartition("hive", DB1, TABLE1, partVals);
        URI uri = URI.create(partition.getSd().getLocation());
        Assert.assertEquals((Object)"10.0.2.15:8020", (Object)uri.getAuthority());
        objectStore.dropDatabase(db1.getCatalogName(), DB1);
    }

    @Test
    public void testMasterKeyOps() throws MetaException, NoSuchObjectException {
        int id1 = this.objectStore.addMasterKey(KEY1);
        int id2 = this.objectStore.addMasterKey(KEY2);
        String[] keys = this.objectStore.getMasterKeys();
        Assert.assertEquals((long)2L, (long)keys.length);
        Assert.assertTrue((keys[0].equals(KEY1) && keys[1].equals(KEY2) || keys[0].equals(KEY2) && keys[1].equals(KEY1) ? 1 : 0) != 0);
        this.objectStore.updateMasterKey(Integer.valueOf(id1), "newtestobjectstorekey1");
        this.objectStore.updateMasterKey(Integer.valueOf(id2), "newtestobjectstorekey2");
        keys = this.objectStore.getMasterKeys();
        Assert.assertEquals((long)2L, (long)keys.length);
        Assert.assertTrue((keys[0].equals("newtestobjectstorekey1") && keys[1].equals("newtestobjectstorekey2") || keys[0].equals("newtestobjectstorekey2") && keys[1].equals("newtestobjectstorekey1") ? 1 : 0) != 0);
        this.objectStore.removeMasterKey(Integer.valueOf(id1));
        keys = this.objectStore.getMasterKeys();
        Assert.assertEquals((long)1L, (long)keys.length);
        Assert.assertEquals((Object)"newtestobjectstorekey2", (Object)keys[0]);
        this.objectStore.removeMasterKey(Integer.valueOf(id2));
    }

    @Test
    public void testRoleOps() throws InvalidObjectException, MetaException, NoSuchObjectException {
        this.objectStore.addRole(ROLE1, OWNER);
        this.objectStore.addRole(ROLE2, OWNER);
        List roles = this.objectStore.listRoleNames();
        Assert.assertEquals((long)2L, (long)roles.size());
        Assert.assertTrue((((String)roles.get(1)).equals(ROLE1) || ((String)roles.get(1)).equals(ROLE2) ? 1 : 0) != 0);
        Role role1 = this.objectStore.getRole(ROLE1);
        Assert.assertEquals((Object)OWNER, (Object)role1.getOwnerName());
        this.objectStore.grantRole(role1, USER1, PrincipalType.USER, OWNER, PrincipalType.ROLE, true);
        this.objectStore.revokeRole(role1, USER1, PrincipalType.USER, false);
        this.objectStore.removeRole(ROLE1);
    }

    @Test
    public void testDirectSqlErrorMetrics() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_ENABLED, (boolean)true);
        Metrics.initialize((Configuration)conf);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_CODAHALE_METRICS_REPORTER_CLASSES, (String)"org.apache.hadoop.hive.common.metrics.metrics2.JsonFileMetricsReporter, org.apache.hadoop.hive.common.metrics.metrics2.JmxMetricsReporter");
        this.setUp();
        Counter directSqlErrors = (Counter)Metrics.getRegistry().getCounters().get("directsql_errors");
        ObjectStore objectStore = this.objectStore;
        objectStore.getClass();
        new ObjectStore.GetDbHelper(objectStore, "hive", "foo", true, true){
            {
                ObjectStore objectStore = x0;
                objectStore.getClass();
                super(objectStore, x1, x2, x3, x4);
            }

            protected Database getSqlResult(ObjectStore.GetHelper<Database> ctx) throws MetaException {
                return null;
            }

            protected Database getJdoResult(ObjectStore.GetHelper<Database> ctx) throws MetaException, NoSuchObjectException {
                return null;
            }
        }.run(false);
        Assert.assertEquals((long)0L, (long)directSqlErrors.getCount());
        ObjectStore objectStore2 = this.objectStore;
        objectStore2.getClass();
        new ObjectStore.GetDbHelper(objectStore2, "hive", "foo", true, true){
            {
                ObjectStore objectStore = x0;
                objectStore.getClass();
                super(objectStore, x1, x2, x3, x4);
            }

            protected Database getSqlResult(ObjectStore.GetHelper<Database> ctx) throws MetaException {
                throw new RuntimeException();
            }

            protected Database getJdoResult(ObjectStore.GetHelper<Database> ctx) throws MetaException, NoSuchObjectException {
                return null;
            }
        }.run(false);
        Assert.assertEquals((long)1L, (long)directSqlErrors.getCount());
    }

    private static void dropAllStoreObjects(RawStore store) throws MetaException, InvalidObjectException, InvalidInputException {
        try {
            Deadline.registerIfNot((long)100000L);
            List functions = store.getAllFunctions("hive");
            for (Function func : functions) {
                store.dropFunction("hive", func.getDbName(), func.getFunctionName());
            }
            for (String catName : store.getCatalogs()) {
                List dbs = store.getAllDatabases(catName);
                for (String db : dbs) {
                    List tbls = store.getAllTables("hive", db);
                    for (String tbl : tbls) {
                        List fks;
                        Deadline.startTimer((String)"getPartition");
                        List parts = store.getPartitions("hive", db, tbl, 100);
                        for (Partition part : parts) {
                            store.dropPartition("hive", db, tbl, part.getValues());
                        }
                        HashSet<String> constraints = new HashSet<String>();
                        List pk = store.getPrimaryKeys("hive", db, tbl);
                        if (pk != null) {
                            for (SQLPrimaryKey pkcol : pk) {
                                constraints.add(pkcol.getPk_name());
                            }
                        }
                        if ((fks = store.getForeignKeys("hive", null, null, db, tbl)) != null) {
                            for (SQLForeignKey fkcol : fks) {
                                constraints.add(fkcol.getFk_name());
                            }
                        }
                        for (String constraint : constraints) {
                            store.dropConstraint("hive", db, tbl, constraint);
                        }
                        store.dropTable("hive", db, tbl);
                    }
                    store.dropDatabase(catName, db);
                }
                store.dropCatalog(catName);
            }
            List roles = store.listRoleNames();
            for (String role : roles) {
                store.removeRole(role);
            }
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryCloseOnError() throws Exception {
        ObjectStore spy = (ObjectStore)Mockito.spy((Object)this.objectStore);
        spy.getAllDatabases("hive");
        spy.getAllFunctions("hive");
        spy.getAllTables("hive", DB1);
        spy.getPartitionCount();
        ((ObjectStore)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)3))).rollbackAndCleanup(Mockito.anyBoolean(), (Query)Mockito.anyObject());
    }

    @Test
    public void testRetryingExecutorSleep() throws Exception {
        ObjectStore.RetryingExecutor re = new ObjectStore.RetryingExecutor(MetastoreConf.newMetastoreConf(), null);
        Assert.assertTrue((String)"invalid sleep value", (re.getSleepInterval() >= 0L ? 1 : 0) != 0);
    }

    @Ignore
    @Test
    public void testNonConfDatanucleusValueSet() {
        String key = "datanucleus.no.such.key";
        String value = "test_value";
        String key1 = "blabla.no.such.key";
        String value1 = "another_value";
        Assume.assumeTrue((System.getProperty(key) == null ? 1 : 0) != 0);
        Configuration localConf = MetastoreConf.newMetastoreConf();
        MetaStoreTestUtils.setConfForStandloneMode(localConf);
        localConf.set(key, value);
        localConf.set(key1, value1);
        this.objectStore = new ObjectStore();
        this.objectStore.setConf(localConf);
        Assert.assertEquals((Object)value, (Object)this.objectStore.getProp().getProperty(key));
        Assert.assertNull((Object)this.objectStore.getProp().getProperty(key1));
    }

    @Test
    public void testNotificationOps() throws InterruptedException {
        boolean NO_EVENT_ID = false;
        boolean FIRST_EVENT_ID = true;
        int SECOND_EVENT_ID = 2;
        this.objectStore.cleanNotificationEvents(1);
        NotificationEvent event = new NotificationEvent(0L, 0, EventMessage.EventType.CREATE_DATABASE.toString(), "");
        CurrentNotificationEventId eventId = this.objectStore.getCurrentNotificationEventId();
        Assert.assertEquals((long)0L, (long)eventId.getEventId());
        this.objectStore.addNotificationEvent(event);
        Assert.assertEquals((long)1L, (long)event.getEventId());
        this.objectStore.addNotificationEvent(event);
        Assert.assertEquals((long)2L, (long)event.getEventId());
        eventId = this.objectStore.getCurrentNotificationEventId();
        Assert.assertEquals((long)2L, (long)eventId.getEventId());
        NotificationEventResponse eventResponse = this.objectStore.getNextNotification(new NotificationEventRequest());
        Assert.assertEquals((long)2L, (long)eventResponse.getEventsSize());
        Assert.assertEquals((long)1L, (long)((NotificationEvent)eventResponse.getEvents().get(0)).getEventId());
        Assert.assertEquals((long)2L, (long)((NotificationEvent)eventResponse.getEvents().get(1)).getEventId());
        eventResponse = this.objectStore.getNextNotification(new NotificationEventRequest(1L));
        Assert.assertEquals((long)1L, (long)eventResponse.getEventsSize());
        Assert.assertEquals((long)2L, (long)((NotificationEvent)eventResponse.getEvents().get(0)).getEventId());
        eventResponse = this.objectStore.getNextNotification(new NotificationEventRequest(2L));
        Assert.assertEquals((long)0L, (long)eventResponse.getEventsSize());
        Thread.sleep(1L);
        this.objectStore.cleanNotificationEvents(1);
        eventResponse = this.objectStore.getNextNotification(new NotificationEventRequest());
        Assert.assertEquals((long)0L, (long)eventResponse.getEventsSize());
    }

    @Ignore(value="This test is here to allow testing with other databases like mysql / postgres etc\n with  user changes to the code. This cannot be run on apache derby because of\n https://db.apache.org/derby/docs/10.10/devguide/cdevconcepts842385.html")
    @Test
    public void testConcurrentAddNotifications() throws ExecutionException, InterruptedException {
        int NUM_THREADS = 10;
        CyclicBarrier cyclicBarrier = new CyclicBarrier(10, () -> LoggerFactory.getLogger((String)"test").debug("10 threads going to add notification"));
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        this.objectStore.getPersistenceManager().newQuery(MNotificationLog.class, "eventType==''").execute();
        this.objectStore.getPersistenceManager().newQuery(MNotificationNextId.class, "nextEventId==-1").execute();
        this.objectStore.addNotificationEvent(new NotificationEvent(0L, 0, EventMessage.EventType.CREATE_DATABASE.toString(), "CREATE DATABASE DB initial"));
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        int i = 0;
        while (i < 10) {
            int n = i++;
            executorService.execute(() -> {
                ObjectStore store = new ObjectStore();
                store.setConf(conf);
                String eventType = EventMessage.EventType.CREATE_DATABASE.toString();
                NotificationEvent dbEvent = new NotificationEvent(0L, 0, eventType, "CREATE DATABASE DB" + n);
                System.out.println("ADDING NOTIFICATION");
                try {
                    cyclicBarrier.await();
                }
                catch (InterruptedException | BrokenBarrierException e) {
                    throw new RuntimeException(e);
                }
                store.addNotificationEvent(dbEvent);
                System.out.println("FINISH NOTIFICATION");
            });
        }
        executorService.shutdown();
        Assert.assertTrue((boolean)executorService.awaitTermination(15L, TimeUnit.SECONDS));
        ObjectStore store = new ObjectStore();
        store.setConf(conf);
        NotificationEventResponse eventResponse = store.getNextNotification(new NotificationEventRequest());
        Assert.assertEquals((long)11L, (long)eventResponse.getEventsSize());
        long previousId = 0L;
        for (NotificationEvent event : eventResponse.getEvents()) {
            Assert.assertTrue((String)("previous:" + previousId + " current:" + event.getEventId()), (previousId < event.getEventId() ? 1 : 0) != 0);
            Assert.assertTrue((previousId + 1L == event.getEventId() ? 1 : 0) != 0);
            previousId = event.getEventId();
        }
    }

    private void createTestCatalog(String catName) throws MetaException {
        Catalog cat = new CatalogBuilder().setName(catName).setLocation("/tmp").build();
        this.objectStore.createCatalog(cat);
    }

    private static final class LongSupplier
    implements Supplier<Long> {
        public long value = 0L;

        private LongSupplier() {
        }

        public Long get() {
            return this.value;
        }
    }
}

