/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MetastoreCheckinTest.class})
public class TestStats {
    private static final Logger LOG = LoggerFactory.getLogger(TestStats.class);
    private static final String NO_CAT = "DO_NOT_USE_A_CATALOG!";
    private IMetaStoreClient client;
    private Configuration conf;

    @Before
    public void setUp() throws MetaException {
        this.conf = MetastoreConf.newMetastoreConf();
        MetaStoreTestUtils.setConfForStandloneMode(this.conf);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_ENABLED, (boolean)false);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        this.client = new HiveMetaStoreClient(this.conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws TException {
        List catalogs = this.client.getCatalogs();
        for (String catName : catalogs) {
            List databases;
            if (!catName.equalsIgnoreCase("hive")) {
                databases = this.client.getAllDatabases(catName);
                for (String db : databases) {
                    this.client.dropDatabase(catName, db, true, false, true);
                }
                this.client.dropCatalog(catName);
                continue;
            }
            databases = this.client.getAllDatabases(catName);
            for (String db : databases) {
                if (db.equalsIgnoreCase("default")) continue;
                this.client.dropDatabase(catName, db, true, false, true);
            }
        }
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        finally {
            this.client = null;
        }
    }

    private Map<String, Column> buildAllColumns() {
        Column[] cols;
        HashMap<String, Column> colMap = new HashMap<String, Column>(6);
        for (Column c : cols = new Column[]{new BinaryColumn(), new BooleanColumn(), new DateColumn(), new DoubleColumn(), new LongColumn(), new StringColumn()}) {
            colMap.put(c.colName, c);
        }
        return colMap;
    }

    private List<String> createMetadata(String catName, String dbName, String tableName, String partKey, List<String> partVals, Map<String, Column> colMap) throws TException {
        Database db;
        if (!"hive".equals(catName) && !NO_CAT.equals(catName)) {
            Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
            this.client.createCatalog(cat);
        }
        if (!"default".equals(dbName)) {
            DatabaseBuilder dbBuilder = new DatabaseBuilder().setName(dbName);
            if (!NO_CAT.equals(catName)) {
                dbBuilder.setCatalogName(catName);
            }
            db = dbBuilder.create(this.client, this.conf);
        } else {
            db = this.client.getDatabase("hive", "default");
        }
        TableBuilder tb = new TableBuilder().inDb(db).setTableName(tableName);
        for (Column column : colMap.values()) {
            tb.addCol(column.colName, column.colType);
        }
        if (partKey != null) {
            assert (partVals != null && !partVals.isEmpty()) : "Must provide partition values for partitioned table";
            tb.addPartCol(partKey, "string");
        }
        Table table = tb.create(this.client, this.conf);
        if (partKey != null) {
            for (String partVal : partVals) {
                new PartitionBuilder().inTable(table).addValue(partVal).addToTable(this.client, this.conf);
            }
        }
        SetPartitionsStatsRequest setPartitionsStatsRequest = new SetPartitionsStatsRequest();
        ArrayList<String> partNames = new ArrayList<String>();
        if (partKey == null) {
            setPartitionsStatsRequest.addToColStats(this.buildStatsForOneTableOrPartition(catName, dbName, tableName, null, colMap.values()));
        } else {
            for (String partVal : partVals) {
                String partName = partKey + "=" + partVal;
                setPartitionsStatsRequest.addToColStats(this.buildStatsForOneTableOrPartition(catName, dbName, tableName, partName, colMap.values()));
                partNames.add(partName);
            }
        }
        this.client.setPartitionColumnStatistics(setPartitionsStatsRequest);
        return partNames;
    }

    private ColumnStatistics buildStatsForOneTableOrPartition(String catName, String dbName, String tableName, String partName, Collection<Column> cols) {
        ColumnStatisticsDesc desc = new ColumnStatisticsDesc(partName == null, dbName, tableName);
        if (!NO_CAT.equals(catName)) {
            desc.setCatName(catName);
        }
        if (partName != null) {
            desc.setPartName(partName);
        }
        ArrayList<ColumnStatisticsObj> objs = new ArrayList<ColumnStatisticsObj>(cols.size());
        for (Column col : cols) {
            objs.add(col.generate());
        }
        return new ColumnStatistics(desc, objs);
    }

    private void dropStats(String catName, String dbName, String tableName, String partName, Collection<String> colNames) throws TException {
        for (String colName : colNames) {
            if (partName == null) {
                if (NO_CAT.equals(catName)) {
                    this.client.deleteTableColumnStatistics(dbName, tableName, colName);
                    continue;
                }
                this.client.deleteTableColumnStatistics(catName, dbName, tableName, colName);
                continue;
            }
            if (NO_CAT.equals(catName)) {
                this.client.deletePartitionColumnStatistics(dbName, tableName, partName, colName);
                continue;
            }
            this.client.deletePartitionColumnStatistics(catName, dbName, tableName, partName, colName);
        }
    }

    private void compareStatsForTable(String catName, String dbName, String tableName, Map<String, Column> colMap) throws TException {
        List objs = catName.equals(NO_CAT) ? this.client.getTableColumnStatistics(dbName, tableName, new ArrayList<String>(colMap.keySet())) : this.client.getTableColumnStatistics(catName, dbName, tableName, new ArrayList<String>(colMap.keySet()));
        this.compareStatsForOneTableOrPartition(objs, 0, colMap);
    }

    private void compareStatsForPartitions(String catName, String dbName, String tableName, List<String> partNames, Map<String, Column> colMap) throws TException {
        Map partObjs = catName.equals(NO_CAT) ? this.client.getPartitionColumnStatistics(dbName, tableName, partNames, new ArrayList<String>(colMap.keySet())) : this.client.getPartitionColumnStatistics(catName, dbName, tableName, partNames, new ArrayList<String>(colMap.keySet()));
        for (int i = 0; i < partNames.size(); ++i) {
            this.compareStatsForOneTableOrPartition((List)partObjs.get(partNames.get(i)), i, colMap);
        }
        AggrStats aggr = catName.equals(NO_CAT) ? this.client.getAggrColStatsFor(dbName, tableName, new ArrayList<String>(colMap.keySet()), partNames) : this.client.getAggrColStatsFor(catName, dbName, tableName, new ArrayList<String>(colMap.keySet()), partNames);
        Assert.assertEquals((long)partNames.size(), (long)aggr.getPartsFound());
        Assert.assertEquals((long)colMap.size(), (long)aggr.getColStatsSize());
        aggr.getColStats().forEach(cso -> ((Column)colMap.get(cso.getColName())).compareAggr((ColumnStatisticsObj)cso));
    }

    private void compareStatsForOneTableOrPartition(List<ColumnStatisticsObj> objs, int partOffset, Map<String, Column> colMap) throws TException {
        Assert.assertEquals((long)objs.size(), (long)colMap.size());
        objs.forEach(cso -> ((Column)colMap.get(cso.getColName())).compare((ColumnStatisticsObj)cso, partOffset));
    }

    @Test
    public void tableInHiveCatalog() throws TException {
        String dbName = "db_table_stats";
        String tableName = "table_in_default_db_stats";
        Map<String, Column> colMap = this.buildAllColumns();
        this.createMetadata("hive", dbName, tableName, null, null, colMap);
        this.compareStatsForTable("hive", dbName, tableName, colMap);
        this.dropStats("hive", dbName, tableName, null, colMap.keySet());
    }

    @Test
    public void partitionedTableInHiveCatalog() throws TException {
        String dbName = "db_part_stats";
        String tableName = "partitioned_table_in_default_db_stats";
        Map<String, Column> colMap = this.buildAllColumns();
        List<String> partNames = this.createMetadata("hive", dbName, tableName, "pk", Arrays.asList("a1", "a2", "a3"), colMap);
        this.compareStatsForPartitions("hive", dbName, tableName, partNames, colMap);
        for (String partName : partNames) {
            this.dropStats("hive", dbName, tableName, partName, colMap.keySet());
        }
    }

    @Test
    public void tableOtherCatalog() throws TException {
        String catName = "cat_table_stats";
        String dbName = "other_cat_db_table_stats";
        String tableName = "table_in_default_db_stats";
        Map<String, Column> colMap = this.buildAllColumns();
        this.createMetadata(catName, dbName, tableName, null, null, colMap);
        this.compareStatsForTable(catName, dbName, tableName, colMap);
        this.dropStats(catName, dbName, tableName, null, colMap.keySet());
    }

    @Test
    public void partitionedTableOtherCatalog() throws TException {
        String catName = "cat_table_stats";
        String dbName = "other_cat_db_part_stats";
        String tableName = "partitioned_table_in_default_db_stats";
        Map<String, Column> colMap = this.buildAllColumns();
        List<String> partNames = this.createMetadata(catName, dbName, tableName, "pk", Arrays.asList("a1", "a2", "a3"), colMap);
        this.compareStatsForPartitions(catName, dbName, tableName, partNames, colMap);
        for (String partName : partNames) {
            this.dropStats(catName, dbName, tableName, partName, colMap.keySet());
        }
    }

    @Test
    public void tableDeprecatedCalls() throws TException {
        String dbName = "old_db_table_stats";
        String tableName = "table_in_default_db_stats";
        Map<String, Column> colMap = this.buildAllColumns();
        this.createMetadata(NO_CAT, dbName, tableName, null, null, colMap);
        this.compareStatsForTable(NO_CAT, dbName, tableName, colMap);
        this.dropStats(NO_CAT, dbName, tableName, null, colMap.keySet());
    }

    @Test
    public void partitionedTableDeprecatedCalls() throws TException {
        String dbName = "old_db_part_stats";
        String tableName = "partitioned_table_in_default_db_stats";
        Map<String, Column> colMap = this.buildAllColumns();
        List<String> partNames = this.createMetadata(NO_CAT, dbName, tableName, "pk", Arrays.asList("a1", "a2", "a3"), colMap);
        this.compareStatsForPartitions(NO_CAT, dbName, tableName, partNames, colMap);
        for (String partName : partNames) {
            this.dropStats(NO_CAT, dbName, tableName, partName, colMap.keySet());
        }
    }

    private class StringColumn
    extends Column {
        public StringColumn() {
            super("strcol", "string");
        }

        @Override
        ColumnStatisticsObj generate() {
            StringColumnStatsData strData = new StringColumnStatsData(this.genMaxLen(), this.genAvgLens(), this.genNumNulls(), this.genNumDvs());
            ColumnStatisticsData data = new ColumnStatisticsData();
            data.setStringStats(strData);
            return new ColumnStatisticsObj(this.colName, this.colType, data);
        }

        @Override
        void compare(ColumnStatisticsObj obj, int offset) {
            this.compareCommon(obj);
            Assert.assertEquals((String)"str num nulls", this.numNulls.get(offset), (Object)obj.getStatsData().getStringStats().getNumNulls());
            Assert.assertEquals((String)"str num dvs", this.numDvs.get(offset), (Object)obj.getStatsData().getStringStats().getNumDVs());
            Assert.assertEquals((String)"str low val", (long)((Long)this.maxLens.get(offset)), (long)obj.getStatsData().getStringStats().getMaxColLen());
            Assert.assertEquals((String)"str high val", (double)((Double)this.avgLens.get(offset)), (double)obj.getStatsData().getStringStats().getAvgColLen(), (double)0.01);
        }

        @Override
        void compareAggr(ColumnStatisticsObj obj) {
            this.compareCommon(obj);
            Assert.assertEquals((String)"aggr str num nulls", (long)this.getNumNulls(), (long)obj.getStatsData().getStringStats().getNumNulls());
            Assert.assertEquals((String)"aggr str num dvs", (long)this.getNumDvs(), (long)obj.getStatsData().getStringStats().getNumDVs());
            Assert.assertEquals((String)"aggr str low val", (long)this.getMaxLen(), (long)obj.getStatsData().getStringStats().getMaxColLen());
            Assert.assertEquals((String)"aggr str high val", (double)this.getAvgLen(), (double)obj.getStatsData().getStringStats().getAvgColLen(), (double)0.01);
        }
    }

    private class LongColumn
    extends Column {
        List<Long> lowVals;
        List<Long> highVals;

        public LongColumn() {
            super("bigintcol", "bigint");
            this.lowVals = new ArrayList<Long>();
            this.highVals = new ArrayList<Long>();
        }

        @Override
        ColumnStatisticsObj generate() {
            LongColumnStatsData longData = new LongColumnStatsData(this.genNumNulls(), this.genNumDvs());
            longData.setLowValue(this.genLowVal());
            longData.setHighValue(this.genHighVal());
            ColumnStatisticsData data = new ColumnStatisticsData();
            data.setLongStats(longData);
            return new ColumnStatisticsObj(this.colName, this.colType, data);
        }

        @Override
        void compare(ColumnStatisticsObj obj, int offset) {
            this.compareCommon(obj);
            Assert.assertEquals((String)"long num nulls", this.numNulls.get(offset), (Object)obj.getStatsData().getLongStats().getNumNulls());
            Assert.assertEquals((String)"long num dvs", this.numDvs.get(offset), (Object)obj.getStatsData().getLongStats().getNumDVs());
            Assert.assertEquals((String)"long low val", (long)this.lowVals.get(offset), (long)obj.getStatsData().getLongStats().getLowValue());
            Assert.assertEquals((String)"long high val", (long)this.highVals.get(offset), (long)obj.getStatsData().getLongStats().getHighValue());
        }

        @Override
        void compareAggr(ColumnStatisticsObj obj) {
            this.compareCommon(obj);
            Assert.assertEquals((String)"aggr long num nulls", (long)this.getNumNulls(), (long)obj.getStatsData().getLongStats().getNumNulls());
            Assert.assertEquals((String)"aggr long num dvs", (long)this.getNumDvs(), (long)obj.getStatsData().getLongStats().getNumDVs());
            Assert.assertEquals((String)"aggr long low val", (long)this.getLowVal(), (long)obj.getStatsData().getLongStats().getLowValue());
            Assert.assertEquals((String)"aggr long high val", (long)this.getHighVal(), (long)obj.getStatsData().getLongStats().getHighValue());
        }

        private long genLowVal() {
            return this.genNegativeLong(this.lowVals);
        }

        private long genHighVal() {
            return this.genPositiveLong(this.highVals);
        }

        private long getLowVal() {
            long min = Long.MAX_VALUE;
            for (Long val : this.lowVals) {
                min = Math.min(min, val);
            }
            return min;
        }

        private long getHighVal() {
            return this.maxLong(this.highVals);
        }
    }

    private class DoubleColumn
    extends Column {
        List<Double> lowVals;
        List<Double> highVals;

        public DoubleColumn() {
            super("doublecol", "double");
            this.lowVals = new ArrayList<Double>();
            this.highVals = new ArrayList<Double>();
        }

        @Override
        ColumnStatisticsObj generate() {
            DoubleColumnStatsData doubleData = new DoubleColumnStatsData(this.genNumNulls(), this.genNumDvs());
            doubleData.setLowValue(this.genLowVal());
            doubleData.setHighValue(this.genHighVal());
            ColumnStatisticsData data = new ColumnStatisticsData();
            data.setDoubleStats(doubleData);
            return new ColumnStatisticsObj(this.colName, this.colType, data);
        }

        @Override
        void compare(ColumnStatisticsObj obj, int offset) {
            this.compareCommon(obj);
            Assert.assertEquals((String)"double num nulls", this.numNulls.get(offset), (Object)obj.getStatsData().getDoubleStats().getNumNulls());
            Assert.assertEquals((String)"double num dvs", this.numDvs.get(offset), (Object)obj.getStatsData().getDoubleStats().getNumDVs());
            Assert.assertEquals((String)"double low val", (double)this.lowVals.get(offset), (double)obj.getStatsData().getDoubleStats().getLowValue(), (double)0.01);
            Assert.assertEquals((String)"double high val", (double)this.highVals.get(offset), (double)obj.getStatsData().getDoubleStats().getHighValue(), (double)0.01);
        }

        @Override
        void compareAggr(ColumnStatisticsObj obj) {
            this.compareCommon(obj);
            Assert.assertEquals((String)"aggr double num nulls", (long)this.getNumNulls(), (long)obj.getStatsData().getDoubleStats().getNumNulls());
            Assert.assertEquals((String)"aggr double num dvs", (long)this.getNumDvs(), (long)obj.getStatsData().getDoubleStats().getNumDVs());
            Assert.assertEquals((String)"aggr double low val", (double)this.getLowVal(), (double)obj.getStatsData().getDoubleStats().getLowValue(), (double)0.01);
            Assert.assertEquals((String)"aggr double high val", (double)this.getHighVal(), (double)obj.getStatsData().getDoubleStats().getHighValue(), (double)0.01);
        }

        private double genLowVal() {
            return this.genDouble(this.lowVals);
        }

        private double genHighVal() {
            return this.genDouble(this.highVals);
        }

        private double getLowVal() {
            double min = Double.MAX_VALUE;
            for (Double d : this.lowVals) {
                min = Math.min(min, d);
            }
            return min;
        }

        private double getHighVal() {
            return this.maxDouble(this.highVals);
        }
    }

    private class DateColumn
    extends Column {
        private List<Date> lowVals;
        private List<Date> highVals;

        public DateColumn() {
            super("datecol", "date");
            this.lowVals = new ArrayList<Date>();
            this.highVals = new ArrayList<Date>();
        }

        @Override
        ColumnStatisticsObj generate() {
            DateColumnStatsData dateData = new DateColumnStatsData(this.genNumNulls(), this.genNumDvs());
            dateData.setLowValue(this.genLowValue());
            dateData.setHighValue(this.genHighValue());
            ColumnStatisticsData data = new ColumnStatisticsData();
            data.setDateStats(dateData);
            return new ColumnStatisticsObj(this.colName, this.colType, data);
        }

        @Override
        void compare(ColumnStatisticsObj obj, int offset) {
            this.compareCommon(obj);
            Assert.assertEquals((String)"date num nulls", this.numNulls.get(offset), (Object)obj.getStatsData().getDateStats().getNumNulls());
            Assert.assertEquals((String)"date num dvs", this.numDvs.get(offset), (Object)obj.getStatsData().getDateStats().getNumDVs());
            Assert.assertEquals((String)"date low val", (Object)this.lowVals.get(offset), (Object)obj.getStatsData().getDateStats().getLowValue());
            Assert.assertEquals((String)"date high val", (Object)this.highVals.get(offset), (Object)obj.getStatsData().getDateStats().getHighValue());
        }

        @Override
        void compareAggr(ColumnStatisticsObj obj) {
            this.compareCommon(obj);
            Assert.assertEquals((String)"aggr date num nulls", (long)this.getNumNulls(), (long)obj.getStatsData().getDateStats().getNumNulls());
            Assert.assertEquals((String)"aggr date num dvs", (long)this.getNumDvs(), (long)obj.getStatsData().getDateStats().getNumDVs());
            Assert.assertEquals((String)"aggr date low val", (Object)this.getLowVal(), (Object)obj.getStatsData().getDateStats().getLowValue());
            Assert.assertEquals((String)"aggr date high val", (Object)this.getHighVal(), (Object)obj.getStatsData().getDateStats().getHighValue());
        }

        private Date genLowValue() {
            Date d = new Date((long)(this.rand.nextInt(100) * -1));
            this.lowVals.add(d);
            return d;
        }

        private Date genHighValue() {
            Date d = new Date((long)this.rand.nextInt(200));
            this.highVals.add(d);
            return d;
        }

        private Date getLowVal() {
            long min = Long.MAX_VALUE;
            for (Date d : this.lowVals) {
                min = Math.min(min, d.getDaysSinceEpoch());
            }
            return new Date(min);
        }

        private Date getHighVal() {
            long max = Long.MIN_VALUE;
            for (Date d : this.highVals) {
                max = Math.max(max, d.getDaysSinceEpoch());
            }
            return new Date(max);
        }
    }

    private class BooleanColumn
    extends Column {
        private List<Long> numTrues;
        private List<Long> numFalses;

        public BooleanColumn() {
            super("boolcol", "boolean");
            this.numTrues = new ArrayList<Long>();
            this.numFalses = new ArrayList<Long>();
        }

        @Override
        ColumnStatisticsObj generate() {
            BooleanColumnStatsData boolData = new BooleanColumnStatsData(this.genNumTrues(), this.genNumFalses(), this.genNumNulls());
            ColumnStatisticsData data = new ColumnStatisticsData();
            data.setBooleanStats(boolData);
            return new ColumnStatisticsObj(this.colName, this.colType, data);
        }

        @Override
        void compare(ColumnStatisticsObj obj, int offset) {
            this.compareCommon(obj);
            Assert.assertEquals((String)"boolean num trues", (Object)this.numTrues.get(offset), (Object)obj.getStatsData().getBooleanStats().getNumTrues());
            Assert.assertEquals((String)"boolean num falses", (Object)this.numFalses.get(offset), (Object)obj.getStatsData().getBooleanStats().getNumFalses());
            Assert.assertEquals((String)"boolean num nulls", this.numNulls.get(offset), (Object)obj.getStatsData().getBooleanStats().getNumNulls());
        }

        @Override
        void compareAggr(ColumnStatisticsObj obj) {
            this.compareCommon(obj);
            Assert.assertEquals((String)"aggr boolean num trues", (long)this.getNumTrues(), (long)obj.getStatsData().getBooleanStats().getNumTrues());
            Assert.assertEquals((String)"aggr boolean num falses", (long)this.getNumFalses(), (long)obj.getStatsData().getBooleanStats().getNumFalses());
            Assert.assertEquals((String)"aggr boolean num nulls", (long)this.getNumNulls(), (long)obj.getStatsData().getBooleanStats().getNumNulls());
        }

        private long genNumTrues() {
            return this.genPositiveLong(this.numTrues);
        }

        private long genNumFalses() {
            return this.genPositiveLong(this.numFalses);
        }

        private long getNumTrues() {
            return this.sumLong(this.numTrues);
        }

        private long getNumFalses() {
            return this.sumLong(this.numFalses);
        }
    }

    private class BinaryColumn
    extends Column {
        public BinaryColumn() {
            super("bincol", "binary");
        }

        @Override
        ColumnStatisticsObj generate() {
            BinaryColumnStatsData binData = new BinaryColumnStatsData(this.genMaxLen(), this.genAvgLens(), this.genNumNulls());
            ColumnStatisticsData data = new ColumnStatisticsData();
            data.setBinaryStats(binData);
            return new ColumnStatisticsObj(this.colName, this.colType, data);
        }

        @Override
        void compare(ColumnStatisticsObj obj, int offset) {
            this.compareCommon(obj);
            Assert.assertEquals((String)"binary max length", this.maxLens.get(offset), (Object)obj.getStatsData().getBinaryStats().getMaxColLen());
            Assert.assertEquals((String)"binary min length", (double)((Double)this.avgLens.get(offset)), (double)obj.getStatsData().getBinaryStats().getAvgColLen(), (double)0.01);
            Assert.assertEquals((String)"binary num nulls", this.numNulls.get(offset), (Object)obj.getStatsData().getBinaryStats().getNumNulls());
        }

        @Override
        void compareAggr(ColumnStatisticsObj obj) {
            this.compareCommon(obj);
            Assert.assertEquals((String)"aggr binary max length", (long)this.getMaxLen(), (long)obj.getStatsData().getBinaryStats().getMaxColLen());
            Assert.assertEquals((String)"aggr binary min length", (double)this.getAvgLen(), (double)obj.getStatsData().getBinaryStats().getAvgColLen(), (double)0.01);
            Assert.assertEquals((String)"aggr binary num nulls", (long)this.getNumNulls(), (long)obj.getStatsData().getBinaryStats().getNumNulls());
        }
    }

    private abstract class Column {
        final String colName;
        final String colType;
        Random rand = new Random();
        List<Long> maxLens;
        List<Long> numNulls;
        List<Long> numDvs;
        List<Double> avgLens;

        public Column(String colName, String colType) {
            this.colName = colName;
            this.colType = colType;
            this.maxLens = new ArrayList<Long>();
            this.numNulls = new ArrayList<Long>();
            this.avgLens = new ArrayList<Double>();
            this.numDvs = new ArrayList<Long>();
        }

        abstract ColumnStatisticsObj generate();

        abstract void compare(ColumnStatisticsObj var1, int var2);

        abstract void compareAggr(ColumnStatisticsObj var1);

        void compareCommon(ColumnStatisticsObj obj) {
            Assert.assertEquals((Object)this.colName, (Object)obj.getColName());
            Assert.assertEquals((Object)this.colType, (Object)obj.getColType());
        }

        long genMaxLen() {
            return this.genPositiveLong(this.maxLens);
        }

        long getMaxLen() {
            return this.maxLong(this.maxLens);
        }

        long genNumNulls() {
            return this.genPositiveLong(this.numNulls);
        }

        long genNumDvs() {
            return this.genPositiveLong(this.numDvs);
        }

        long getNumNulls() {
            return this.sumLong(this.numNulls);
        }

        long getNumDvs() {
            return this.maxLong(this.numDvs);
        }

        double genAvgLens() {
            return this.genDouble(this.avgLens);
        }

        double getAvgLen() {
            return this.maxDouble(this.avgLens);
        }

        protected long genNegativeLong(List<Long> addTo) {
            long val = this.rand.nextInt(100);
            if (val > 0L) {
                val *= -1L;
            }
            addTo.add(val);
            return val;
        }

        protected long genPositiveLong(List<Long> addTo) {
            long val = this.rand.nextInt(100);
            val = Math.abs(val) + 1L;
            addTo.add(val);
            return val;
        }

        protected long maxLong(List<Long> maxOf) {
            long max = Long.MIN_VALUE;
            for (long maybe : maxOf) {
                max = Math.max(max, maybe);
            }
            return max;
        }

        protected long sumLong(List<Long> sumOf) {
            long sum = 0L;
            for (long element : sumOf) {
                sum += element;
            }
            return sum;
        }

        protected double genDouble(List<Double> addTo) {
            double val = this.rand.nextDouble() * (double)this.rand.nextInt(100);
            addTo.add(val);
            return val;
        }

        protected double maxDouble(List<Double> maxOf) {
            double max = Double.MIN_VALUE;
            for (double maybe : maxOf) {
                max = Math.max(max, maybe);
            }
            return max;
        }
    }
}

