/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.testutils.junit.runners.model;

import com.google.code.tempusfugit.concurrency.ExecutorServiceShutdown;
import com.google.code.tempusfugit.temporal.Duration;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.junit.runners.model.RunnerScheduler;

public class ConcurrentScheduler
implements RunnerScheduler {
    private final ExecutorService executor;
    private final OutputStream outputStream;

    public ConcurrentScheduler(ExecutorService executor) {
        this(executor, System.err);
    }

    public ConcurrentScheduler(ExecutorService executor, OutputStream outputStream) {
        this.executor = executor;
        this.outputStream = outputStream;
    }

    public void schedule(Runnable childStatement) {
        this.executor.submit(childStatement);
    }

    public void finished() {
        if (!this.successful(ExecutorServiceShutdown.shutdown((ExecutorService)this.executor).waitingForCompletion(Duration.days((long)365L))).booleanValue()) {
            this.writeln(this.outputStream, "scheduler shutdown timed out before tests completed, you may have executors hanging around...");
        }
    }

    private Boolean successful(Boolean completed) {
        return Boolean.TRUE.equals(completed);
    }

    private void writeln(OutputStream stream, String string) {
        try {
            stream.write(string.getBytes());
            stream.write(System.getProperty("line.separator").getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

