/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.election.dal.LeDescriptorDataAccess;
import io.hops.metadata.election.entity.LeDescriptor;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.lock.TransactionLocks;
import java.util.ArrayList;
import java.util.Collection;

public abstract class LeSnapshot
extends BaseEntityContext<Long, LeDescriptor> {
    private final LeDescriptorDataAccess<LeDescriptor> dataAccess;
    private boolean allRead = false;

    public LeSnapshot(LeDescriptorDataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void update(LeDescriptor desc) throws TransactionContextException {
        super.update((Object)desc);
        this.log("added-le-desc", new Object[]{"id", desc.getId(), "hostName", desc.getRpcAddresses(), "counter", desc.getCounter()});
    }

    public void remove(LeDescriptor desc) throws TransactionContextException {
        super.remove((Object)desc);
        this.log("removed-le-desc", new Object[]{"id", desc.getId(), "hostName", desc.getRpcAddresses(), "counter", desc.getCounter()});
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getAdded(), this.getModified());
    }

    public void clear() throws TransactionContextException {
        super.clear();
        this.allRead = false;
    }

    Long getKey(LeDescriptor desc) {
        return desc.getId();
    }

    protected LeDescriptor findById(LeDescriptor.LeDescriptorFinder lFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        long id = (Long)params[0];
        int partitionKey = (Integer)params[1];
        LeDescriptor result = null;
        if (this.allRead || this.contains(id)) {
            result = (LeDescriptor)this.get(id);
            this.hit((FinderType)lFinder, result, new Object[]{"id", id});
        } else {
            this.aboutToAccessStorage((FinderType)lFinder, params);
            result = (LeDescriptor)this.dataAccess.findByPkey(id, partitionKey);
            this.gotFromDB(id, result);
            this.miss((FinderType)lFinder, result, new Object[]{"id", id});
        }
        return result;
    }

    protected Collection<LeDescriptor> findAll(LeDescriptor.LeDescriptorFinder lFinder) throws StorageCallPreventedException, StorageException {
        Collection result = null;
        if (this.allRead) {
            result = this.getAll();
            this.hit((FinderType)lFinder, result, new Object[0]);
        } else {
            this.aboutToAccessStorage((FinderType)lFinder);
            result = this.dataAccess.findAll();
            this.allRead = true;
            this.gotFromDB(result);
            this.miss((FinderType)lFinder, result, new Object[0]);
        }
        return new ArrayList<LeDescriptor>(result);
    }

    public static class YarnLESnapshot
    extends LeSnapshot {
        public YarnLESnapshot(LeDescriptorDataAccess dataAccess) {
            super(dataAccess);
        }

        public LeDescriptor find(FinderType<LeDescriptor> finder, Object ... params) throws TransactionContextException, StorageException {
            LeDescriptor.YarnLeDescriptor.Finder lFinder = (LeDescriptor.YarnLeDescriptor.Finder)finder;
            switch (lFinder) {
                case ById: {
                    return this.findById((LeDescriptor.LeDescriptorFinder)lFinder, params);
                }
            }
            throw new RuntimeException(UNSUPPORTED_FINDER);
        }

        public Collection<LeDescriptor> findList(FinderType<LeDescriptor> finder, Object ... params) throws TransactionContextException, StorageException {
            LeDescriptor.YarnLeDescriptor.Finder lFinder = (LeDescriptor.YarnLeDescriptor.Finder)finder;
            switch (lFinder) {
                case All: {
                    return this.findAll((LeDescriptor.LeDescriptorFinder)lFinder);
                }
            }
            throw new RuntimeException(UNSUPPORTED_FINDER);
        }
    }

    public static class HdfsLESnapshot
    extends LeSnapshot {
        public HdfsLESnapshot(LeDescriptorDataAccess dataAccess) {
            super(dataAccess);
        }

        public LeDescriptor find(FinderType<LeDescriptor> finder, Object ... params) throws TransactionContextException, StorageException {
            LeDescriptor.HdfsLeDescriptor.Finder lFinder = (LeDescriptor.HdfsLeDescriptor.Finder)finder;
            switch (lFinder) {
                case ById: {
                    return this.findById((LeDescriptor.LeDescriptorFinder)lFinder, params);
                }
            }
            throw new RuntimeException(UNSUPPORTED_FINDER);
        }

        public Collection<LeDescriptor> findList(FinderType<LeDescriptor> finder, Object ... params) throws TransactionContextException, StorageException {
            LeDescriptor.HdfsLeDescriptor.Finder lFinder = (LeDescriptor.HdfsLeDescriptor.Finder)finder;
            switch (lFinder) {
                case All: {
                    return this.findAll((LeDescriptor.LeDescriptorFinder)lFinder);
                }
            }
            throw new RuntimeException(UNSUPPORTED_FINDER);
        }
    }
}

