/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.metadata.common.entity.Variable;
import io.hops.metadata.election.entity.LeDescriptorFactory;
import io.hops.transaction.lock.LeDescriptorLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.VariablesLock;

public class LeLockFactory {
    private static final LeLockFactory instance = new LeLockFactory();

    private LeLockFactory() {
    }

    public static LeLockFactory getInstance() {
        return instance;
    }

    public Lock getLeVarsLock(Variable.Finder finder, TransactionLockTypes.LockType lockType) {
        VariablesLock lock = new VariablesLock();
        lock.addVariable(finder, lockType);
        return lock;
    }

    public Lock getLeVarsLock(Variable.Finder[] finders, TransactionLockTypes.LockType[] lockTypes) {
        assert (finders.length == lockTypes.length);
        VariablesLock lock = new VariablesLock();
        for (int i = 0; i < finders.length; ++i) {
            lock.addVariable(finders[i], lockTypes[i]);
        }
        return lock;
    }

    public Lock getLeDescriptorLock(LeDescriptorFactory leFactory, TransactionLockTypes.LockType lockType) {
        return new LeDescriptorLock(leFactory, lockType);
    }
}

