/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata;

import io.hops.DalDriver;
import io.hops.DalStorageFactory;
import io.hops.StorageConnector;
import io.hops.exception.StorageException;
import io.hops.exception.StorageInitializtionException;
import io.hops.leaderElection.VarsRegister;
import io.hops.metadata.common.EntityDataAccess;
import io.hops.metadata.common.entity.ArrayVariable;
import io.hops.metadata.common.entity.ByteArrayVariable;
import io.hops.metadata.common.entity.IntVariable;
import io.hops.metadata.common.entity.LongVariable;
import io.hops.metadata.common.entity.StringVariable;
import io.hops.metadata.common.entity.Variable;
import io.hops.metadata.election.dal.HdfsLeDescriptorDataAccess;
import io.hops.metadata.election.dal.LeDescriptorDataAccess;
import io.hops.metadata.election.dal.YarnLeDescriptorDataAccess;
import io.hops.metadata.election.entity.LeDescriptor;
import io.hops.metadata.hdfs.dal.VariableDataAccess;
import io.hops.transaction.EntityManager;
import io.hops.transaction.context.ContextInitializer;
import io.hops.transaction.context.EntityContext;
import io.hops.transaction.context.LeSnapshot;
import io.hops.transaction.context.VariableContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class LEStorageFactory {
    private static boolean isDALInitialized = false;
    private static DalStorageFactory dStorageFactory;
    private static Map<Class, EntityDataAccess> dataAccessAdaptors;

    public static StorageConnector getConnector() {
        return dStorageFactory.getConnector();
    }

    public static void setConfiguration(String driver, String driverClass, String driverConfigFile) throws IOException {
        if (!isDALInitialized) {
            VarsRegister.registerHdfsDefaultValues();
            LEStorageFactory.addToClassPath(driver);
            dStorageFactory = DalDriver.load((String)driverClass);
            dStorageFactory.setConfiguration(LEStorageFactory.getMetadataClusterConfiguration(driverConfigFile));
            LEStorageFactory.initDataAccessWrappers();
            EntityManager.addContextInitializer((ContextInitializer)LEStorageFactory.getContextInitializer());
            isDALInitialized = true;
        }
    }

    public static Properties getMetadataClusterConfiguration(String driver) throws IOException {
        Properties clusterConf = new Properties();
        InputStream inStream = StorageConnector.class.getClassLoader().getResourceAsStream(driver);
        clusterConf.load(inStream);
        return clusterConf;
    }

    private static void addToClassPath(String s) throws StorageInitializtionException {
        try {
            File f = new File(s);
            URL u = f.toURI().toURL();
            URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> urlClass = URLClassLoader.class;
            Method method = urlClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlClassLoader, u);
        }
        catch (MalformedURLException ex) {
            throw new StorageInitializtionException((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new StorageInitializtionException((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new StorageInitializtionException((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new StorageInitializtionException((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            throw new StorageInitializtionException((Throwable)ex);
        }
        catch (SecurityException ex) {
            throw new StorageInitializtionException((Throwable)ex);
        }
    }

    private static void initDataAccessWrappers() {
        dataAccessAdaptors.clear();
    }

    private static ContextInitializer getContextInitializer() {
        return new ContextInitializer(){

            public Map<Class, EntityContext> createEntityContexts() {
                HashMap<Class, EntityContext> entityContexts = new HashMap<Class, EntityContext>();
                VariableContext variableContext = new VariableContext((VariableDataAccess)LEStorageFactory.getDataAccess(VariableDataAccess.class));
                entityContexts.put(Variable.class, (EntityContext)variableContext);
                entityContexts.put(IntVariable.class, (EntityContext)variableContext);
                entityContexts.put(LongVariable.class, (EntityContext)variableContext);
                entityContexts.put(ByteArrayVariable.class, (EntityContext)variableContext);
                entityContexts.put(StringVariable.class, (EntityContext)variableContext);
                entityContexts.put(ArrayVariable.class, (EntityContext)variableContext);
                entityContexts.put(LeDescriptor.HdfsLeDescriptor.class, (EntityContext)new LeSnapshot.HdfsLESnapshot((LeDescriptorDataAccess)LEStorageFactory.getDataAccess(HdfsLeDescriptorDataAccess.class)));
                entityContexts.put(LeDescriptor.YarnLeDescriptor.class, (EntityContext)new LeSnapshot.YarnLESnapshot((LeDescriptorDataAccess)LEStorageFactory.getDataAccess(YarnLeDescriptorDataAccess.class)));
                return entityContexts;
            }

            public StorageConnector getConnector() {
                return dStorageFactory.getConnector();
            }
        };
    }

    public static EntityDataAccess getDataAccess(Class type) {
        if (dataAccessAdaptors.containsKey(type)) {
            return dataAccessAdaptors.get(type);
        }
        return dStorageFactory.getDataAccess(type);
    }

    public static boolean formatStorage() throws StorageException {
        return dStorageFactory.getConnector().formatStorage();
    }

    public static boolean formatAllStorageNonTransactional() throws StorageException {
        return dStorageFactory.getConnector().formatAllStorageNonTransactional();
    }

    public static boolean formatStorage(Class<? extends EntityDataAccess> ... das) throws StorageException {
        return dStorageFactory.getConnector().formatStorage((Class[])das);
    }

    static {
        dataAccessAdaptors = new HashMap<Class, EntityDataAccess>();
    }
}

