/*
 * Decompiled with CFR 0.152.
 */
package io.hops.leaderElection;

import io.hops.exception.StorageException;
import io.hops.exception.TransientStorageException;
import io.hops.leaderElection.LEContext;
import io.hops.leaderElection.LETransaction;
import io.hops.leaderElection.LeaderElectionRole;
import io.hops.leaderElection.exception.LeaderElectionForceAbort;
import io.hops.leader_election.node.ActiveNode;
import io.hops.leader_election.node.SortedActiveNodeList;
import io.hops.metadata.election.entity.LeDescriptor;
import io.hops.metadata.election.entity.LeDescriptorFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.util.Time;
import org.apache.log4j.Logger;

public class LeaderElection
extends Thread {
    private static final Logger LOG = Logger.getLogger(LeaderElection.class);
    public static final long DRIFT_CONSTANT = 100L;
    public static final long LEADER_INITIALIZATION_ID = -1L;
    LEContext context = LEContext.initialContext();
    protected boolean running = true;
    protected boolean stopped = false;
    private long pause_time = 0L;
    private boolean pause_started = false;
    private boolean forceContantTP = false;
    private long forcedTimePerid = 0L;
    private long sucessfulTx = 0L;
    private long failedtx = 0L;
    private boolean relinquishCurrentId = false;
    private final LeDescriptorFactory leFactory;
    private List<LeDescriptor.FailedNodeLeDescriptor> deadNodes;

    public LeaderElection(LeDescriptorFactory leFactory, long time_period, int max_missed_hb_threshold, long time_period_increment, String http_address, String rpc_addresses) throws IOException {
        this(leFactory, time_period, max_missed_hb_threshold, time_period_increment, http_address, rpc_addresses, 0);
    }

    public LeaderElection(LeDescriptorFactory leFactory, long time_period, int max_missed_hb_threshold, long time_period_increment, String http_address, String rpc_addresses, byte locationDomainId) throws IOException {
        this.context.init_phase = true;
        this.context.time_period = time_period;
        this.context.max_missed_hb_threshold = max_missed_hb_threshold;
        this.context.rpc_addresses = rpc_addresses;
        this.context.http_address = http_address;
        this.context.time_period_increment = time_period_increment;
        this.context.locationDomainId = locationDomainId;
        this.leFactory = leFactory;
        this.deadNodes = new ArrayList<LeDescriptor.FailedNodeLeDescriptor>();
        this.initialize();
    }

    private void initialize() throws IOException {
        LETransaction transaction = new LETransaction();
        LEContext newContext = transaction.doTransaction(this.leFactory, this.context, false, this);
        this.swapContexts(newContext);
    }

    @Override
    public void run() {
        Thread.currentThread().setPriority(10);
        while (this.running) {
            long txStartTime = System.currentTimeMillis();
            long sleepDuration = -1L;
            LEContext updatedContext = null;
            boolean txFailed = false;
            try {
                LOG.debug((Object)("LE Status: id " + this.context.id + " Leader Election Start Round. Time period " + this.context.time_period + " Time since last update " + (System.currentTimeMillis() - this.context.last_hb_time)));
                LETransaction transaction = new LETransaction();
                updatedContext = transaction.doTransaction(this.leFactory, this.context, this.relinquishCurrentId, this);
                this.relinquishCurrentId = false;
                ++this.sucessfulTx;
            }
            catch (TransientStorageException te) {
                LOG.error((Object)("LE Status: id " + this.context.id + " LeaderElection thread received TransientStorageException. sucessfulTx " + this.sucessfulTx + " failedTx " + this.failedtx + " time period " + this.context.time_period + " " + te.getMessage()), (Throwable)te);
                sleepDuration = 0L;
                txFailed = true;
                ++this.failedtx;
            }
            catch (StorageException e) {
                LOG.error((Object)("LE Status: id " + this.context.id + " LeaderElection thread received StorageException. sucessfulTx " + this.sucessfulTx + " failedTx " + this.failedtx + " time period " + this.context.time_period + " " + e.getMessage()), (Throwable)e);
                sleepDuration = 0L;
                txFailed = true;
                ++this.failedtx;
            }
            catch (LeaderElectionForceAbort fa) {
                LOG.error((Object)("LE Status: id " + this.context.id + " LeaderElection thread received Forced Abort Exception. sucessfulTx " + this.sucessfulTx + " failedTx " + this.failedtx + " time period " + this.context.time_period + " " + fa.getMessage()), (Throwable)fa);
                sleepDuration = 0L;
                txFailed = true;
                ++this.failedtx;
            }
            catch (Throwable t) {
                LOG.fatal((Object)("LE Status: id " + this.context.id + " LeaderElection thread received non recoverable exception. " + t.getMessage()), t);
                this.running = false;
                txFailed = true;
                throw new Error(t);
            }
            Long txTotalTime = System.currentTimeMillis() - txStartTime;
            if (!txFailed) {
                this.swapContexts(updatedContext);
                if (txTotalTime < this.context.time_period && !this.context.nextTimeTakeStrongerLocks) {
                    sleepDuration = this.context.time_period;
                } else {
                    sleepDuration = 0L;
                    if (txTotalTime > this.context.time_period) {
                        LOG.error((Object)("LE Status: id " + this.context.id + " LeaderElection: Update Tx took very long time to update: " + txTotalTime + ", time_perid is " + this.context.time_period));
                    }
                }
            }
            LOG.debug((Object)("LE Status: id " + this.context.id + " Leader Election End Round. Update time was " + txTotalTime + " ms"));
            if (this.running) {
                this.pauseForTesting();
            }
            if (!this.running || sleepDuration <= 0L) continue;
            this.sleepFor(sleepDuration);
        }
        this.stopped = true;
    }

    public synchronized boolean isLeader() {
        if (this.context.role == LeaderElectionRole.Role.LEADER) {
            long elapsed_time = System.currentTimeMillis() - this.context.last_hb_time;
            return elapsed_time < this.context.time_period * (long)this.context.max_missed_hb_threshold - 100L;
        }
        return false;
    }

    public synchronized boolean isSecond() {
        long elapsed_time;
        List activeNodes = this.context.memberShip.getSortedActiveNodes();
        return (activeNodes.size() < 2 || ((ActiveNode)this.context.memberShip.getSortedActiveNodes().get(1)).getId() == this.context.id) && (elapsed_time = System.currentTimeMillis() - this.context.last_hb_time) < this.context.time_period * (long)this.context.max_missed_hb_threshold - 100L;
    }

    public synchronized boolean isUpToDate() {
        if (this.context.memberShip == null || this.context.memberShip.size() <= 0) {
            return false;
        }
        long elapsed_time = System.currentTimeMillis() - this.context.last_hb_time;
        return elapsed_time < this.context.time_period * (long)this.context.max_missed_hb_threshold - 100L;
    }

    public void stopElectionThread() throws InterruptedException {
        this.running = false;
        this.interrupt();
        this.join();
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void pauseFor(long pause) {
        LOG.debug((Object)("LE Status: id " + this.context.id + " setting pause flag. Time " + pause));
        if (this.pause_time != 0L) {
            throw new UnsupportedOperationException("LE Status: id " + this.context.id + " Application is alredy paused. Remaining pause time " + this.pause_time);
        }
        this.pause_time = pause;
    }

    public void forceResume() {
        if (this.pause_started) {
            LOG.debug((Object)("LE Status: id " + this.context.id + " sending interrupt"));
            this.interrupt();
        } else {
            this.pause_time = 0L;
            this.pause_started = false;
        }
    }

    public boolean isPaused() {
        return this.pause_time > 0L || this.pause_started;
    }

    public void forceFixedTimePeriod(long tp) {
        this.forcedTimePerid = tp;
        this.forceContantTP = true;
    }

    private long pauseForTesting() {
        if (this.pause_time > 0L) {
            LOG.debug((Object)("LE Status: id " + this.context.id + " pausing the leader election for " + this.pause_time + " ms"));
            this.pause_started = true;
            this.sleepFor(this.pause_time);
            this.pause_started = false;
            long retVal = this.pause_time;
            this.pause_time = 0L;
            LOG.debug((Object)("LE Status: id " + this.context.id + " resuming the leader election"));
            return retVal;
        }
        return this.pause_time;
    }

    public boolean isRunning() {
        return this.running;
    }

    private void sleepFor(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException ex) {
            LOG.warn((Object)("LE Status: id " + this.context.id + " got Interrupted " + ex));
        }
    }

    public synchronized long getCurrentId() {
        return this.context.id;
    }

    public synchronized long getCurrentTimePeriod() {
        return this.context.time_period;
    }

    public synchronized SortedActiveNodeList getActiveNamenodes() {
        return this.context.memberShip;
    }

    public synchronized String getRpcAddress() {
        return this.context.rpc_addresses;
    }

    public synchronized String getHttpAddress() {
        return this.context.http_address;
    }

    private synchronized void swapContexts(LEContext newContext) {
        assert (newContext != null);
        this.context = newContext;
        for (LeDescriptor descriptor : newContext.removedNodes) {
            this.deadNodes.add(new LeDescriptor.FailedNodeLeDescriptor(descriptor));
        }
        if (this.forceContantTP) {
            this.context.time_period = this.forcedTimePerid;
        }
    }

    public void relinquishCurrentIdInNextRound() throws InterruptedException {
        this.relinquishCurrentId = true;
        do {
            Thread.sleep(50L);
        } while (this.relinquishCurrentId);
    }

    public void forceLead(long id) throws IOException {
        LETransaction transaction = new LETransaction();
        transaction.forceLead(id);
    }

    public synchronized List<LeDescriptor.FailedNodeLeDescriptor> getDeadNodes() {
        List<LeDescriptor.FailedNodeLeDescriptor> ret = this.deadNodes;
        this.deadNodes = new ArrayList<LeDescriptor.FailedNodeLeDescriptor>();
        return ret;
    }

    public void waitActive() throws InterruptedException {
        long start = -1L;
        while (true) {
            Thread.sleep(100L);
            if (this.context.memberShip == null || this.context.memberShip.size() < 1) continue;
            if (start < 0L) {
                start = Time.now();
            }
            if (this.isLeader() || Time.now() - start > this.context.time_period * (long)(this.context.max_missed_hb_threshold + 1)) break;
        }
    }
}

