/*
 * Decompiled with CFR 0.152.
 */
package io.hops.leaderElection.experiments;

import io.hops.leaderElection.LeaderElection;
import io.hops.leader_election.node.SortedActiveNodeList;
import io.hops.metadata.election.entity.LeDescriptorFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LightWeightNameNode {
    private static final Log LOG = LogFactory.getLog(LightWeightNameNode.class);
    protected LeaderElection leaderElection;

    public LightWeightNameNode(LeDescriptorFactory ldf, long time_period, int max_missed_hb_threshold, long time_period_increment, String http_address, String rpc_address) throws IOException, CloneNotSupportedException {
        this.leaderElection = new LeaderElection(ldf, time_period, max_missed_hb_threshold, time_period_increment, http_address, rpc_address);
        this.leaderElection.start();
        LOG.debug((Object)"NameNode has started");
    }

    public long getLeCurrentId() {
        return this.leaderElection.getCurrentId();
    }

    public boolean isLeader() {
        return this.leaderElection.isLeader();
    }

    public void stop() {
        if (!this.leaderElection.isStopped()) {
            try {
                this.leaderElection.stopElectionThread();
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"LeaderElection stopped", (Throwable)e);
            }
        }
    }

    public LeaderElection getLeaderElectionInstance() {
        return this.leaderElection;
    }

    public InetSocketAddress getNameNodeAddress() {
        Pattern p = Pattern.compile("^\\s*(.*?):(\\d+)\\s*$");
        Matcher m = p.matcher(this.leaderElection.getRpcAddress());
        if (m.matches()) {
            String host = m.group(1);
            int port = Integer.parseInt(m.group(2));
            return new InetSocketAddress(host, port);
        }
        return null;
    }

    public SortedActiveNodeList getActiveNameNodes() {
        return this.leaderElection.getActiveNamenodes();
    }

    public long getLeTimePeriod() {
        return this.leaderElection.getCurrentTimePeriod();
    }
}

