/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class LeaderElectionTransactionLocks
implements TransactionLocks {
    private final Map<Lock.Type, Lock> locks = new EnumMap<Lock.Type, Lock>(Lock.Type.class);

    public TransactionLocks add(Lock lock) {
        if (this.locks.containsKey(lock.getType())) {
            throw new IllegalArgumentException("The same lock cannot be added twice!");
        }
        this.locks.put(lock.getType(), lock);
        return this;
    }

    public TransactionLocks add(Collection<Lock> locks) {
        for (Lock lock : locks) {
            this.add(lock);
        }
        return this;
    }

    public boolean containsLock(Lock.Type lock) {
        return this.locks.containsKey(lock);
    }

    public Lock getLock(Lock.Type type) throws TransactionLocks.LockNotAddedException {
        if (!this.locks.containsKey(type)) {
            throw new TransactionLocks.LockNotAddedException("Trying to get a lock which was not added.");
        }
        return this.locks.get(type);
    }

    public List<Lock> getSortedLocks() {
        ArrayList<Lock> lks = new ArrayList<Lock>(this.locks.values());
        Collections.sort(lks);
        return lks;
    }
}

