/*
 * Decompiled with CFR 0.152.
 */
package avro.shaded.com.google.common.collect;

import avro.shaded.com.google.common.annotations.GwtCompatible;
import avro.shaded.com.google.common.annotations.GwtIncompatible;
import avro.shaded.com.google.common.collect.Platform;
import java.util.Collection;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public final class ObjectArrays {
    private ObjectArrays() {
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    public static <T> T[] newArray(Class<T> type, int length) {
        return Platform.newArray(type, length);
    }

    public static <T> T[] newArray(T[] reference, int length) {
        return Platform.newArray(reference, length);
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    public static <T> T[] concat(T[] first, T[] second, Class<T> type) {
        Object[] result2 = ObjectArrays.newArray(type, first.length + second.length);
        Platform.unsafeArrayCopy(first, 0, result2, 0, first.length);
        Platform.unsafeArrayCopy(second, 0, result2, first.length, second.length);
        return result2;
    }

    public static <T> T[] concat(@Nullable T element, T[] array) {
        Object[] result2 = ObjectArrays.newArray(array, array.length + 1);
        result2[0] = element;
        Platform.unsafeArrayCopy(array, 0, result2, 1, array.length);
        return result2;
    }

    public static <T> T[] concat(T[] array, @Nullable T element) {
        T[] result2 = ObjectArrays.arraysCopyOf(array, array.length + 1);
        result2[array.length] = element;
        return result2;
    }

    static <T> T[] arraysCopyOf(T[] original, int newLength) {
        Object[] copy2 = ObjectArrays.newArray(original, newLength);
        Platform.unsafeArrayCopy(original, 0, copy2, 0, Math.min(original.length, newLength));
        return copy2;
    }

    static <T> T[] toArrayImpl(Collection<?> c, T[] array) {
        int size2 = c.size();
        if (array.length < size2) {
            array = ObjectArrays.newArray(array, size2);
        }
        ObjectArrays.fillArray(c, array);
        if (array.length > size2) {
            array[size2] = null;
        }
        return array;
    }

    static Object[] toArrayImpl(Collection<?> c) {
        return ObjectArrays.fillArray(c, new Object[c.size()]);
    }

    private static Object[] fillArray(Iterable<?> elements, Object[] array) {
        int i = 0;
        for (Object element : elements) {
            array[i++] = element;
        }
        return array;
    }

    static void swap(Object[] array, int i, int j) {
        Object temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }
}

