/*
 * Decompiled with CFR 0.152.
 */
package avro.shaded.com.google.common.primitives;

import avro.shaded.com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;

final class AndroidInteger {
    @CheckForNull
    static Integer tryParse(String string2) {
        return AndroidInteger.tryParse(string2, 10);
    }

    @CheckForNull
    static Integer tryParse(String string2, int radix) {
        boolean negative;
        Preconditions.checkNotNull(string2);
        Preconditions.checkArgument(radix >= 2, "Invalid radix %s, min radix is %s", radix, 2);
        Preconditions.checkArgument(radix <= 36, "Invalid radix %s, max radix is %s", radix, 36);
        int length = string2.length();
        int i = 0;
        if (length == 0) {
            return null;
        }
        boolean bl = negative = string2.charAt(i) == '-';
        if (negative && ++i == length) {
            return null;
        }
        return AndroidInteger.tryParse(string2, i, radix, negative);
    }

    @CheckForNull
    private static Integer tryParse(String string2, int offset2, int radix, boolean negative) {
        int max2 = Integer.MIN_VALUE / radix;
        int result2 = 0;
        int length = string2.length();
        while (offset2 < length) {
            int digit;
            if ((digit = Character.digit(string2.charAt(offset2++), radix)) == -1) {
                return null;
            }
            if (max2 > result2) {
                return null;
            }
            int next2 = result2 * radix - digit;
            if (next2 > result2) {
                return null;
            }
            result2 = next2;
        }
        if (!negative && (result2 = -result2) < 0) {
            return null;
        }
        if (result2 > Integer.MAX_VALUE || result2 < Integer.MIN_VALUE) {
            return null;
        }
        return result2;
    }

    private AndroidInteger() {
    }
}

