/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import javax.annotation.Nullable;

@GwtCompatible
public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, @Nullable Object errorMessage2) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage2));
        }
    }

    public static void checkArgument(boolean expression, @Nullable String errorMessageTemplate, Object ... errorMessageArgs2) {
        if (!expression) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, errorMessageArgs2));
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, @Nullable Object errorMessage2) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage2));
        }
    }

    public static void checkState(boolean expression, @Nullable String errorMessageTemplate, Object ... errorMessageArgs2) {
        if (!expression) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, errorMessageArgs2));
        }
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, @Nullable Object errorMessage2) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage2));
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, @Nullable String errorMessageTemplate, Object ... errorMessageArgs2) {
        if (reference == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, errorMessageArgs2));
        }
        return reference;
    }

    public static int checkElementIndex(int index, int size2) {
        return Preconditions.checkElementIndex(index, size2, "index");
    }

    public static int checkElementIndex(int index, int size2, @Nullable String desc) {
        if (index < 0 || index >= size2) {
            throw new IndexOutOfBoundsException(Preconditions.badElementIndex(index, size2, desc));
        }
        return index;
    }

    private static String badElementIndex(int index, int size2, String desc) {
        if (index < 0) {
            return Preconditions.format("%s (%s) must not be negative", desc, index);
        }
        if (size2 < 0) {
            int n = size2;
            throw new IllegalArgumentException(new StringBuilder(26).append("negative size: ").append(n).toString());
        }
        return Preconditions.format("%s (%s) must be less than size (%s)", desc, index, size2);
    }

    public static int checkPositionIndex(int index, int size2) {
        return Preconditions.checkPositionIndex(index, size2, "index");
    }

    public static int checkPositionIndex(int index, int size2, @Nullable String desc) {
        if (index < 0 || index > size2) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndex(index, size2, desc));
        }
        return index;
    }

    private static String badPositionIndex(int index, int size2, String desc) {
        if (index < 0) {
            return Preconditions.format("%s (%s) must not be negative", desc, index);
        }
        if (size2 < 0) {
            int n = size2;
            throw new IllegalArgumentException(new StringBuilder(26).append("negative size: ").append(n).toString());
        }
        return Preconditions.format("%s (%s) must not be greater than size (%s)", desc, index, size2);
    }

    public static void checkPositionIndexes(int start2, int end, int size2) {
        if (start2 < 0 || end < start2 || end > size2) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndexes(start2, end, size2));
        }
    }

    private static String badPositionIndexes(int start2, int end, int size2) {
        if (start2 < 0 || start2 > size2) {
            return Preconditions.badPositionIndex(start2, size2, "start index");
        }
        if (end < 0 || end > size2) {
            return Preconditions.badPositionIndex(end, size2, "end index");
        }
        return Preconditions.format("end index (%s) must not be less than start index (%s)", end, start2);
    }

    static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

