/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.Escaper;
import com.google.common.escape.Platform;

@Beta
@GwtCompatible
public abstract class UnicodeEscaper
extends Escaper {
    private static final int DEST_PAD = 32;

    protected UnicodeEscaper() {
    }

    protected abstract char[] escape(int var1);

    protected int nextEscapeIndex(CharSequence csq, int start2, int end) {
        int index;
        int cp;
        for (index = start2; index < end && (cp = UnicodeEscaper.codePointAt(csq, index, end)) >= 0 && this.escape(cp) == null; index += Character.isSupplementaryCodePoint(cp) ? 2 : 1) {
        }
        return index;
    }

    @Override
    public String escape(String string2) {
        Preconditions.checkNotNull(string2);
        int end = string2.length();
        int index = this.nextEscapeIndex(string2, 0, end);
        return index == end ? string2 : this.escapeSlow(string2, index);
    }

    protected final String escapeSlow(String s2, int index) {
        int end = s2.length();
        char[] dest = Platform.charBufferFromThreadLocal();
        int destIndex = 0;
        int unescapedChunkStart = 0;
        while (index < end) {
            int cp = UnicodeEscaper.codePointAt(s2, index, end);
            if (cp < 0) {
                throw new IllegalArgumentException("Trailing high surrogate at end of input");
            }
            char[] escaped2 = this.escape(cp);
            int nextIndex = index + (Character.isSupplementaryCodePoint(cp) ? 2 : 1);
            if (escaped2 != null) {
                int charsSkipped = index - unescapedChunkStart;
                int sizeNeeded = destIndex + charsSkipped + escaped2.length;
                if (dest.length < sizeNeeded) {
                    int destLength = sizeNeeded + (end - index) + 32;
                    dest = UnicodeEscaper.growBuffer(dest, destIndex, destLength);
                }
                if (charsSkipped > 0) {
                    s2.getChars(unescapedChunkStart, index, dest, destIndex);
                    destIndex += charsSkipped;
                }
                if (escaped2.length > 0) {
                    System.arraycopy(escaped2, 0, dest, destIndex, escaped2.length);
                    destIndex += escaped2.length;
                }
                unescapedChunkStart = nextIndex;
            }
            index = this.nextEscapeIndex(s2, nextIndex, end);
        }
        int charsSkipped = end - unescapedChunkStart;
        if (charsSkipped > 0) {
            int endIndex = destIndex + charsSkipped;
            if (dest.length < endIndex) {
                dest = UnicodeEscaper.growBuffer(dest, destIndex, endIndex);
            }
            s2.getChars(unescapedChunkStart, end, dest, destIndex);
            destIndex = endIndex;
        }
        return new String(dest, 0, destIndex);
    }

    protected static int codePointAt(CharSequence seq, int index, int end) {
        Preconditions.checkNotNull(seq);
        if (index < end) {
            char c1;
            if ((c1 = seq.charAt(index++)) < '\ud800' || c1 > '\udfff') {
                return c1;
            }
            if (c1 <= '\udbff') {
                if (index == end) {
                    return -c1;
                }
                char c2 = seq.charAt(index);
                if (Character.isLowSurrogate(c2)) {
                    return Character.toCodePoint(c1, c2);
                }
                char c = c2;
                char c3 = c2;
                int n = index;
                String string2 = String.valueOf(String.valueOf(seq));
                throw new IllegalArgumentException(new StringBuilder(89 + string2.length()).append("Expected low surrogate but got char '").append(c).append("' with value ").append((int)c3).append(" at index ").append(n).append(" in '").append(string2).append("'").toString());
            }
            char c = c1;
            char c4 = c1;
            int n = index - 1;
            String string3 = String.valueOf(String.valueOf(seq));
            throw new IllegalArgumentException(new StringBuilder(88 + string3.length()).append("Unexpected low surrogate character '").append(c).append("' with value ").append((int)c4).append(" at index ").append(n).append(" in '").append(string3).append("'").toString());
        }
        throw new IndexOutOfBoundsException("Index exceeds specified range");
    }

    private static char[] growBuffer(char[] dest, int index, int size2) {
        char[] copy2 = new char[size2];
        if (index > 0) {
            System.arraycopy(dest, 0, copy2, 0, index);
        }
        return copy2;
    }
}

