/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import io.hops.util.Hops;
import io.hops.util.HopsworksErrorResponseDTO;
import io.hops.util.exceptions.FeaturegroupCreationError;
import io.hops.util.exceptions.FeaturegroupDeletionError;
import io.hops.util.exceptions.FeaturegroupDoesNotExistError;
import io.hops.util.exceptions.FeaturegroupUpdateStatsError;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.exceptions.FeaturestoresNotFound;
import io.hops.util.exceptions.HTTPSClientInitializationException;
import io.hops.util.exceptions.JWTNotFoundException;
import io.hops.util.exceptions.TrainingDatasetCreationError;
import io.hops.util.exceptions.TrainingDatasetDoesNotExistError;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.FeatureDTO;
import io.hops.util.featurestore.dtos.FeaturestoreMetadataDTO;
import io.hops.util.featurestore.dtos.stats.StatisticsDTO;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBException;
import org.json.JSONObject;

public class FeaturestoreRestClient {
    private static final Logger LOG = Logger.getLogger(FeaturestoreRestClient.class.getName());

    private FeaturestoreRestClient() {
    }

    public static FeaturestoreMetadataDTO getFeaturestoreMetadataRest(String featurestore) throws FeaturestoreNotFound, JAXBException {
        Response response;
        LOG.log(Level.FINE, "Getting featuregroups for featurestore " + featurestore);
        try {
            response = Hops.clientWrapper("/project/" + Hops.getProjectId() + "/" + "featurestores" + "/" + featurestore + "/" + "metadata", "GET");
        }
        catch (HTTPSClientInitializationException | JWTNotFoundException e) {
            throw new FeaturestoreNotFound(e.getMessage());
        }
        LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            throw new FeaturestoreNotFound("Could not fetch featuregroups for featurestore:" + featurestore);
        }
        String responseEntity = response.readEntity(String.class);
        JSONObject featurestoreMetadata = new JSONObject(responseEntity);
        return FeaturestoreHelper.parseFeaturestoreMetadataJson(featurestoreMetadata);
    }

    public static void deleteTableContentsRest(String featurestore, String featuregroup, int featuregroupVersion) throws JWTNotFoundException, FeaturegroupDeletionError, JAXBException, FeaturestoreNotFound, FeaturegroupDoesNotExistError {
        LOG.log(Level.FINE, "Deleting table contents of featuregroup " + featuregroup + "version: " + featuregroupVersion + " in featurestore: " + featurestore);
        try {
            int featurestoreId = FeaturestoreHelper.getFeaturestoreId(featurestore);
            int featuregroupId = FeaturestoreHelper.getFeaturegroupId(featurestore, featuregroup, featuregroupVersion);
            Response response = Hops.clientWrapper("/project/" + Hops.getProjectId() + "/" + "featurestores" + "/" + featurestoreId + "/" + "featuregroups" + "/" + featuregroupId + "/" + "clear", "POST");
            LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
            if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
                throw new FeaturegroupDeletionError("Could not clear the contents of featuregroup:" + featuregroup + " , response code: " + response.getStatusInfo().getStatusCode());
            }
        }
        catch (HTTPSClientInitializationException e) {
            throw new FeaturegroupDeletionError(e.getMessage());
        }
    }

    public static void createFeaturegroupRest(String featurestore, String featuregroup, int featuregroupVersion, String description, String jobName, List<String> dependencies, List<FeatureDTO> featuresSchema, StatisticsDTO statisticsDTO) throws JWTNotFoundException, JAXBException, FeaturegroupCreationError, FeaturestoreNotFound {
        Response response;
        LOG.log(Level.FINE, "Creating featuregroup " + featuregroup + " in featurestore: " + featurestore);
        JSONObject json = new JSONObject();
        json.put("name", featuregroup);
        json.put("version", featuregroupVersion);
        json.put("description", description);
        json.put("jobName", jobName);
        json.put("dependencies", dependencies);
        json.put("features", FeaturestoreHelper.convertFeatureDTOsToJsonObjects(featuresSchema));
        json.put("featureCorrelationMatrix", FeaturestoreHelper.convertFeatureCorrelationMatrixDTOToJsonObject(statisticsDTO.getFeatureCorrelationMatrixDTO()));
        json.put("descriptiveStatistics", FeaturestoreHelper.convertDescriptiveStatsDTOToJsonObject(statisticsDTO.getDescriptiveStatsDTO()));
        json.put("featuresHistogram", FeaturestoreHelper.convertFeatureDistributionsDTOToJsonObject(statisticsDTO.getFeatureDistributionsDTO()));
        json.put("clusterAnalysis", FeaturestoreHelper.convertClusterAnalysisDTOToJsonObject(statisticsDTO.getClusterAnalysisDTO()));
        json.put("updateMetadata", false);
        json.put("updateStats", false);
        try {
            int featurestoreId = FeaturestoreHelper.getFeaturestoreId(featurestore);
            response = Hops.clientWrapper(json, "/project/" + Hops.getProjectId() + "/" + "featurestores" + "/" + featurestoreId + "/" + "featuregroups", "POST");
        }
        catch (HTTPSClientInitializationException e) {
            throw new FeaturegroupCreationError(e.getMessage());
        }
        LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
        if (response.getStatusInfo().getStatusCode() != Response.Status.CREATED.getStatusCode()) {
            HopsworksErrorResponseDTO hopsworksErrorResponseDTO = Hops.parseHopsworksErrorResponse(response);
            throw new FeaturegroupCreationError("Could not create featuregroup:" + featuregroup + " , error code: " + hopsworksErrorResponseDTO.getErrorCode() + " error message: " + hopsworksErrorResponseDTO.getErrorMsg() + ", user message: " + hopsworksErrorResponseDTO.getUserMsg());
        }
    }

    public static Response createTrainingDatasetRest(String featurestore, String trainingDataset, int trainingDatasetVersion, String description, String jobName, String dataFormat, List<String> dependencies, List<FeatureDTO> featuresSchema, StatisticsDTO statisticsDTO) throws JWTNotFoundException, JAXBException, TrainingDatasetCreationError, FeaturestoreNotFound {
        Response response;
        LOG.log(Level.FINE, "Creating Training Dataset " + trainingDataset + " in featurestore: " + featurestore);
        JSONObject json = new JSONObject();
        json.put("name", trainingDataset);
        json.put("version", trainingDatasetVersion);
        json.put("description", description);
        json.put("jobName", jobName);
        json.put("dependencies", dependencies);
        json.put("dataFormat", dataFormat);
        json.put("features", FeaturestoreHelper.convertFeatureDTOsToJsonObjects(featuresSchema));
        json.put("featureCorrelationMatrix", FeaturestoreHelper.convertFeatureCorrelationMatrixDTOToJsonObject(statisticsDTO.getFeatureCorrelationMatrixDTO()));
        json.put("descriptiveStatistics", FeaturestoreHelper.convertDescriptiveStatsDTOToJsonObject(statisticsDTO.getDescriptiveStatsDTO()));
        json.put("featuresHistogram", FeaturestoreHelper.convertFeatureDistributionsDTOToJsonObject(statisticsDTO.getFeatureDistributionsDTO()));
        json.put("clusterAnalysis", FeaturestoreHelper.convertClusterAnalysisDTOToJsonObject(statisticsDTO.getClusterAnalysisDTO()));
        try {
            int featurestoreId = FeaturestoreHelper.getFeaturestoreId(featurestore);
            response = Hops.clientWrapper(json, "/project/" + Hops.getProjectId() + "/" + "featurestores" + "/" + featurestoreId + "/" + "trainingdatasets", "POST");
        }
        catch (HTTPSClientInitializationException e) {
            throw new TrainingDatasetCreationError(e.getMessage());
        }
        LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
        if (response.getStatusInfo().getStatusCode() != Response.Status.CREATED.getStatusCode()) {
            HopsworksErrorResponseDTO hopsworksErrorResponseDTO = Hops.parseHopsworksErrorResponse(response);
            throw new TrainingDatasetCreationError("Could not create trainingDataset:" + trainingDataset + " , error code: " + hopsworksErrorResponseDTO.getErrorCode() + " error message: " + hopsworksErrorResponseDTO.getErrorMsg() + ", user message: " + hopsworksErrorResponseDTO.getUserMsg());
        }
        return response;
    }

    public static Response getFeaturestoresForProjectRest() throws JWTNotFoundException, FeaturestoresNotFound {
        Response response;
        LOG.log(Level.FINE, "Getting featurestores for current project");
        try {
            response = Hops.clientWrapper("/project/" + Hops.getProjectId() + "/" + "featurestores", "GET");
        }
        catch (HTTPSClientInitializationException e) {
            throw new FeaturestoresNotFound(e.getMessage());
        }
        LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            throw new FeaturestoresNotFound("Could not fetch featurestores for the current project");
        }
        return response;
    }

    public static void updateFeaturegroupStatsRest(String featuregroup, String featurestore, int featuregroupVersion, StatisticsDTO statisticsDTO) throws JWTNotFoundException, JAXBException, FeaturegroupUpdateStatsError, FeaturestoreNotFound, FeaturegroupDoesNotExistError {
        Response response;
        LOG.log(Level.FINE, "Updating featuregroup stats for: " + featuregroup + " in featurestore: " + featurestore);
        JSONObject json = new JSONObject();
        json.put("name", featuregroup);
        json.put("version", featuregroupVersion);
        json.put("featureCorrelationMatrix", FeaturestoreHelper.convertFeatureCorrelationMatrixDTOToJsonObject(statisticsDTO.getFeatureCorrelationMatrixDTO()));
        json.put("descriptiveStatistics", FeaturestoreHelper.convertDescriptiveStatsDTOToJsonObject(statisticsDTO.getDescriptiveStatsDTO()));
        json.put("featuresHistogram", FeaturestoreHelper.convertFeatureDistributionsDTOToJsonObject(statisticsDTO.getFeatureDistributionsDTO()));
        json.put("clusterAnalysis", FeaturestoreHelper.convertClusterAnalysisDTOToJsonObject(statisticsDTO.getClusterAnalysisDTO()));
        json.put("updateMetadata", false);
        json.put("updateStats", true);
        try {
            int featurestoreId = FeaturestoreHelper.getFeaturestoreId(featurestore);
            int featuregroupId = FeaturestoreHelper.getFeaturegroupId(featurestore, featuregroup, featuregroupVersion);
            response = Hops.clientWrapper(json, "/project/" + Hops.getProjectId() + "/" + "featurestores" + "/" + featurestoreId + "/" + "featuregroups" + "/" + featuregroupId, "PUT");
        }
        catch (HTTPSClientInitializationException e) {
            throw new FeaturegroupUpdateStatsError(e.getMessage());
        }
        LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            HopsworksErrorResponseDTO hopsworksErrorResponseDTO = Hops.parseHopsworksErrorResponse(response);
            throw new FeaturegroupUpdateStatsError("Could not update statistics for featuregroup:" + featuregroup + " , error code: " + hopsworksErrorResponseDTO.getErrorCode() + " error message: " + hopsworksErrorResponseDTO.getErrorMsg() + ", user message: " + hopsworksErrorResponseDTO.getUserMsg());
        }
    }

    public static Response updateTrainingDatasetStatsRest(String trainingDataset, String featurestore, int trainingDatasetVersion, StatisticsDTO statisticsDTO) throws JWTNotFoundException, JAXBException, FeaturegroupUpdateStatsError, TrainingDatasetDoesNotExistError, FeaturestoreNotFound {
        LOG.log(Level.FINE, "Updating training dataset stats for: " + trainingDataset + " in featurestore: " + featurestore);
        JSONObject json = new JSONObject();
        json.put("name", trainingDataset);
        json.put("version", trainingDatasetVersion);
        json.put("featureCorrelationMatrix", FeaturestoreHelper.convertFeatureCorrelationMatrixDTOToJsonObject(statisticsDTO.getFeatureCorrelationMatrixDTO()));
        json.put("descriptiveStatistics", FeaturestoreHelper.convertDescriptiveStatsDTOToJsonObject(statisticsDTO.getDescriptiveStatsDTO()));
        json.put("featuresHistogram", FeaturestoreHelper.convertFeatureDistributionsDTOToJsonObject(statisticsDTO.getFeatureDistributionsDTO()));
        json.put("clusterAnalysis", FeaturestoreHelper.convertClusterAnalysisDTOToJsonObject(statisticsDTO.getClusterAnalysisDTO()));
        json.put("updateMetadata", false);
        json.put("updateStats", true);
        Response response = null;
        try {
            int featurestoreId = FeaturestoreHelper.getFeaturestoreId(featurestore);
            int trainingDatasetId = FeaturestoreHelper.getTrainingDatasetId(featurestore, trainingDataset, trainingDatasetVersion);
            response = Hops.clientWrapper(json, "/project/" + Hops.getProjectId() + "/" + "featurestores" + "/" + featurestoreId + "/" + "trainingdatasets" + "/" + trainingDatasetId, "PUT");
        }
        catch (HTTPSClientInitializationException e) {
            throw new FeaturegroupUpdateStatsError(e.getMessage());
        }
        LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            HopsworksErrorResponseDTO hopsworksErrorResponseDTO = Hops.parseHopsworksErrorResponse(response);
            throw new FeaturegroupUpdateStatsError("Could not update statistics for trainingDataset:" + trainingDataset + " , error code: " + hopsworksErrorResponseDTO.getErrorCode() + " error message: " + hopsworksErrorResponseDTO.getErrorMsg() + ", user message: " + hopsworksErrorResponseDTO.getUserMsg());
        }
        return response;
    }
}

