/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops;

import io.hops.util.Hops;
import io.hops.util.exceptions.CannotWriteImageDataFrameException;
import io.hops.util.exceptions.DataframeIsEmpty;
import io.hops.util.exceptions.FeaturegroupCreationError;
import io.hops.util.exceptions.FeaturegroupDeletionError;
import io.hops.util.exceptions.FeaturegroupDoesNotExistError;
import io.hops.util.exceptions.FeaturegroupUpdateStatsError;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.exceptions.FeaturestoresNotFound;
import io.hops.util.exceptions.InvalidPrimaryKeyForFeaturegroup;
import io.hops.util.exceptions.JWTNotFoundException;
import io.hops.util.exceptions.SparkDataTypeNotRecognizedError;
import io.hops.util.exceptions.TrainingDatasetCreationError;
import io.hops.util.exceptions.TrainingDatasetDoesNotExistError;
import io.hops.util.exceptions.TrainingDatasetFormatNotSupportedError;
import io.hops.util.featurestore.FeaturestoreHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public abstract class FeaturestoreOp {
    protected String name;
    protected SparkSession spark = Hops.findSpark();
    protected String featurestore = FeaturestoreHelper.featurestoreGetOrDefault(null);
    protected int version = 1;
    protected String featuregroup;
    protected List<String> features;
    protected Map<String, Integer> featuregroupsAndVersions;
    protected String joinKey;
    protected String corrMethod = FeaturestoreHelper.correlationMethodGetOrDefault(null);
    protected int numBins = FeaturestoreHelper.numBinsGetOrDefault(null);
    protected int numClusters = FeaturestoreHelper.numClustersGetOrDefault(null);
    protected String mode;
    protected Dataset<Row> dataframe;
    protected Boolean descriptiveStats = true;
    protected Boolean featureCorr = true;
    protected Boolean featureHistograms = true;
    protected Boolean clusterAnalysis = true;
    protected List<String> statColumns = null;
    protected String jobName = FeaturestoreHelper.jobNameGetOrDefault(null);
    protected String primaryKey;
    protected String description = "";
    protected List<String> dependencies = new ArrayList<String>();
    protected String dataFormat = FeaturestoreHelper.dataFormatGetOrDefault(null);
    protected List<String> partitionBy = new ArrayList<String>();

    public FeaturestoreOp(String name) {
        this.name = name;
    }

    public FeaturestoreOp(List<String> features) {
        this.features = features;
    }

    public String getName() {
        return this.name;
    }

    public SparkSession getSpark() {
        return this.spark;
    }

    public String getFeaturestore() {
        return this.featurestore;
    }

    public int getVersion() {
        return this.version;
    }

    public String getFeaturegroup() {
        return this.featuregroup;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public Map<String, Integer> getFeaturegroupsAndVersions() {
        return this.featuregroupsAndVersions;
    }

    public String getJoinKey() {
        return this.joinKey;
    }

    public String getCorrMethod() {
        return this.corrMethod;
    }

    public int getNumBins() {
        return this.numBins;
    }

    public int getNumClusters() {
        return this.numClusters;
    }

    public String getMode() {
        return this.mode;
    }

    public Dataset<Row> getDataframe() {
        return this.dataframe;
    }

    public Boolean getDescriptiveStats() {
        return this.descriptiveStats;
    }

    public Boolean getFeatureCorr() {
        return this.featureCorr;
    }

    public Boolean getFeatureHistograms() {
        return this.featureHistograms;
    }

    public Boolean getClusterAnalysis() {
        return this.clusterAnalysis;
    }

    public List<String> getStatColumns() {
        return this.statColumns;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public List<String> getPartitionBy() {
        return this.partitionBy;
    }

    public abstract Object read() throws FeaturestoreNotFound, JAXBException, TrainingDatasetFormatNotSupportedError, TrainingDatasetDoesNotExistError, IOException, FeaturestoresNotFound, JWTNotFoundException;

    public abstract void write() throws FeaturegroupDeletionError, DataframeIsEmpty, SparkDataTypeNotRecognizedError, JAXBException, FeaturegroupUpdateStatsError, FeaturestoreNotFound, TrainingDatasetDoesNotExistError, TrainingDatasetFormatNotSupportedError, IOException, InvalidPrimaryKeyForFeaturegroup, FeaturegroupCreationError, TrainingDatasetCreationError, CannotWriteImageDataFrameException, JWTNotFoundException, FeaturegroupDoesNotExistError;
}

