/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.read_ops;

import com.google.common.base.Strings;
import io.hops.util.Hops;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.FeaturegroupDTO;
import io.hops.util.featurestore.dtos.FeaturestoreMetadataDTO;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class FeaturestoreReadFeature
extends FeaturestoreOp {
    public FeaturestoreReadFeature(String name) {
        super(name);
    }

    public Dataset<Row> read() throws FeaturestoreNotFound, JAXBException {
        try {
            return this.doGetFeature(this.spark, this.name, Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read(), this.featurestore);
        }
        catch (Exception e) {
            Hops.updateFeaturestoreMetadataCache().setFeaturestore(this.featurestore).write();
            return this.doGetFeature(this.spark, this.name, Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read(), this.featurestore);
        }
    }

    @Override
    public void write() {
        throw new UnsupportedOperationException("write() is not supported on a read operation");
    }

    private Dataset<Row> doGetFeature(SparkSession sparkSession, String feature, FeaturestoreMetadataDTO featurestoreMetadata, String featurestore) {
        sparkSession = FeaturestoreHelper.sparkGetOrDefault(sparkSession);
        List<FeaturegroupDTO> featuregroupsMetadata = featurestoreMetadata.getFeaturegroups();
        if (Strings.isNullOrEmpty(this.featuregroup)) {
            return FeaturestoreHelper.getFeature(sparkSession, feature, featurestore, featuregroupsMetadata);
        }
        return FeaturestoreHelper.getFeature(sparkSession, feature, featurestore, this.featuregroup, this.version);
    }

    public FeaturestoreReadFeature setSpark(SparkSession spark) {
        this.spark = spark;
        return this;
    }

    public FeaturestoreReadFeature setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    public FeaturestoreReadFeature setVersion(int version) {
        this.version = version;
        return this;
    }

    public FeaturestoreReadFeature setName(String name) {
        this.name = name;
        return this;
    }

    public FeaturestoreReadFeature setFeaturegroup(String featuregroup) {
        this.featuregroup = featuregroup;
        return this;
    }
}

