/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.read_ops;

import io.hops.util.Hops;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.FeaturegroupDTO;
import io.hops.util.featurestore.dtos.FeaturestoreMetadataDTO;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import java.util.List;
import javax.xml.bind.JAXBException;

public class FeaturestoreReadFeaturegroupLatestVersion
extends FeaturestoreOp {
    public FeaturestoreReadFeaturegroupLatestVersion(String name) {
        super(name);
    }

    @Override
    public Integer read() throws FeaturestoreNotFound, JAXBException {
        try {
            return FeaturestoreReadFeaturegroupLatestVersion.doGetLatestFeaturegroupVersion(this.name, Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read());
        }
        catch (Exception e) {
            Hops.updateFeaturestoreMetadataCache().setFeaturestore(this.featurestore).write();
            return FeaturestoreReadFeaturegroupLatestVersion.doGetLatestFeaturegroupVersion(this.name, Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read());
        }
    }

    @Override
    public void write() {
        throw new UnsupportedOperationException("write() is not supported on a read operation");
    }

    public FeaturestoreReadFeaturegroupLatestVersion setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    private static int doGetLatestFeaturegroupVersion(String featuregroupName, FeaturestoreMetadataDTO featurestoreMetadata) {
        List<FeaturegroupDTO> featuregroupDTOList = featurestoreMetadata.getFeaturegroups();
        return FeaturestoreHelper.getLatestFeaturegroupVersion(featuregroupDTOList, featuregroupName);
    }
}

