/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.read_ops;

import com.google.common.base.Strings;
import io.hops.util.Hops;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.FeaturegroupDTO;
import io.hops.util.featurestore.dtos.FeaturestoreMetadataDTO;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class FeaturestoreReadFeatures
extends FeaturestoreOp {
    public FeaturestoreReadFeatures(List<String> features) {
        super(features);
    }

    public Dataset<Row> read() throws FeaturestoreNotFound, JAXBException {
        if (this.features.isEmpty()) {
            throw new IllegalArgumentException("Feature List Cannot be Empty");
        }
        try {
            return this.doGetFeatures();
        }
        catch (Exception e) {
            Hops.updateFeaturestoreMetadataCache().setFeaturestore(this.featurestore).write();
            return this.doGetFeatures();
        }
    }

    private Dataset<Row> doGetFeatures() throws FeaturestoreNotFound, JAXBException {
        if (!Strings.isNullOrEmpty(this.joinKey) && this.featuregroupsAndVersions != null) {
            return FeaturestoreHelper.getFeatures(this.spark, (List<String>)this.features, this.featurestore, this.featuregroupsAndVersions, this.joinKey);
        }
        if (!Strings.isNullOrEmpty(this.joinKey) && this.featuregroupsAndVersions == null) {
            return this.doGetFeatures(this.spark, (List<String>)this.features, this.featurestore, Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read(), this.joinKey);
        }
        if (Strings.isNullOrEmpty(this.joinKey) && this.featuregroupsAndVersions != null) {
            return this.doGetFeatures(this.spark, (List<String>)this.features, this.featurestore, Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read(), this.featuregroupsAndVersions);
        }
        return FeaturestoreReadFeatures.doGetFeatures(this.spark, this.features, this.featurestore, Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read());
    }

    @Override
    public void write() {
        throw new UnsupportedOperationException("write() is not supported on a read operation");
    }

    private Dataset<Row> doGetFeatures(SparkSession sparkSession, List<String> features, String featurestore, FeaturestoreMetadataDTO featurestoreMetadata, Map<String, Integer> featuregroupsAndVersions) {
        List<FeaturegroupDTO> featuregroupsMetadata = featurestoreMetadata.getFeaturegroups();
        List<FeaturegroupDTO> filteredFeaturegroupsMetadata = FeaturestoreHelper.filterFeaturegroupsBasedOnMap(featuregroupsAndVersions, featuregroupsMetadata);
        String joinKey = FeaturestoreHelper.getJoinColumn(filteredFeaturegroupsMetadata);
        return FeaturestoreHelper.getFeatures(sparkSession, features, featurestore, featuregroupsAndVersions, joinKey);
    }

    private Dataset<Row> doGetFeatures(SparkSession sparkSession, List<String> features, String featurestore, FeaturestoreMetadataDTO featurestoreMetadata, String joinKey) {
        List<FeaturegroupDTO> featuregroupsMetadata = featurestoreMetadata.getFeaturegroups();
        return FeaturestoreHelper.getFeatures(sparkSession, features, featurestore, featuregroupsMetadata, joinKey);
    }

    private static Dataset<Row> doGetFeatures(SparkSession sparkSession, List<String> features, String featurestore, FeaturestoreMetadataDTO featurestoreMetadata) {
        List<FeaturegroupDTO> featuregroupsMetadata = featurestoreMetadata.getFeaturegroups();
        List<FeaturegroupDTO> featuregroupsMatching = FeaturestoreHelper.findFeaturegroupsThatContainsFeatures(featuregroupsMetadata, features, featurestore);
        String joinKey = FeaturestoreHelper.getJoinColumn(featuregroupsMatching);
        return FeaturestoreHelper.getFeatures(sparkSession, features, featurestore, featuregroupsMatching, joinKey);
    }

    public FeaturestoreReadFeatures setFeatures(List<String> features) {
        this.features = features;
        return this;
    }

    public FeaturestoreReadFeatures setSpark(SparkSession spark) {
        this.spark = spark;
        return this;
    }

    public FeaturestoreReadFeatures setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    public FeaturestoreReadFeatures setFeaturegroupsAndVersions(Map<String, Integer> featuregroupsAndVersions) {
        this.featuregroupsAndVersions = featuregroupsAndVersions;
        return this;
    }

    public FeaturestoreReadFeatures setJoinKey(String joinKey) {
        this.joinKey = joinKey;
        return this;
    }
}

