/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.read_ops;

import io.hops.util.Hops;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.exceptions.TrainingDatasetDoesNotExistError;
import io.hops.util.exceptions.TrainingDatasetFormatNotSupportedError;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.FeaturestoreMetadataDTO;
import io.hops.util.featurestore.dtos.TrainingDatasetDTO;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import java.io.IOException;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class FeaturestoreReadTrainingDataset
extends FeaturestoreOp {
    public FeaturestoreReadTrainingDataset(String name) {
        super(name);
    }

    public Dataset<Row> read() throws FeaturestoreNotFound, JAXBException, TrainingDatasetFormatNotSupportedError, TrainingDatasetDoesNotExistError, IOException {
        try {
            return this.doGetTrainingDataset(this.spark, this.name, Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read(), this.version);
        }
        catch (Exception e) {
            Hops.updateFeaturestoreMetadataCache().setFeaturestore(this.featurestore).write();
            return this.doGetTrainingDataset(this.spark, this.name, Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read(), this.version);
        }
    }

    @Override
    public void write() {
        throw new UnsupportedOperationException("write() is not supported on a read operation");
    }

    private Dataset<Row> doGetTrainingDataset(SparkSession sparkSession, String trainingDataset, FeaturestoreMetadataDTO featurestoreMetadata, int trainingDatasetVersion) throws TrainingDatasetDoesNotExistError, TrainingDatasetFormatNotSupportedError, IOException {
        sparkSession = FeaturestoreHelper.sparkGetOrDefault(sparkSession);
        List<TrainingDatasetDTO> trainingDatasetDTOList = featurestoreMetadata.getTrainingDatasets();
        TrainingDatasetDTO trainingDatasetDTO = FeaturestoreHelper.findTrainingDataset(trainingDatasetDTOList, trainingDataset, trainingDatasetVersion);
        String hdfsPath = "hdfs://default" + trainingDatasetDTO.getHdfsStorePath() + "/" + trainingDatasetDTO.getName();
        return FeaturestoreHelper.getTrainingDataset(sparkSession, trainingDatasetDTO.getDataFormat(), hdfsPath);
    }

    public FeaturestoreReadTrainingDataset setName(String name) {
        this.name = name;
        return this;
    }

    public FeaturestoreReadTrainingDataset setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    public FeaturestoreReadTrainingDataset setSpark(SparkSession spark) {
        this.spark = spark;
        return this;
    }

    public FeaturestoreReadTrainingDataset setVersion(int version) {
        this.version = version;
        return this;
    }
}

