/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.read_ops;

import io.hops.util.Hops;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.FeaturestoreMetadataDTO;
import io.hops.util.featurestore.dtos.TrainingDatasetDTO;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import java.util.List;
import javax.xml.bind.JAXBException;

public class FeaturestoreReadTrainingDatasetLatestVersion
extends FeaturestoreOp {
    public FeaturestoreReadTrainingDatasetLatestVersion(String name) {
        super(name);
    }

    @Override
    public Integer read() throws FeaturestoreNotFound, JAXBException {
        try {
            return FeaturestoreReadTrainingDatasetLatestVersion.doGetLatestTrainingDatasetVersion(this.name, Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read());
        }
        catch (Exception e) {
            Hops.updateFeaturestoreMetadataCache().setFeaturestore(this.featurestore).write();
            return FeaturestoreReadTrainingDatasetLatestVersion.doGetLatestTrainingDatasetVersion(this.name, Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read());
        }
    }

    @Override
    public void write() {
        throw new UnsupportedOperationException("write() is not supported on a read operation");
    }

    public FeaturestoreReadTrainingDatasetLatestVersion setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    private static int doGetLatestTrainingDatasetVersion(String trainingDatasetName, FeaturestoreMetadataDTO featurestoreMetadata) {
        List<TrainingDatasetDTO> trainingDatasetDTOS = featurestoreMetadata.getTrainingDatasets();
        return FeaturestoreHelper.getLatestTrainingDatasetVersion(trainingDatasetDTOS, trainingDatasetName);
    }
}

