/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.write_ops;

import io.hops.util.FeaturestoreRestClient;
import io.hops.util.Hops;
import io.hops.util.exceptions.DataframeIsEmpty;
import io.hops.util.exceptions.FeaturegroupCreationError;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.exceptions.InvalidPrimaryKeyForFeaturegroup;
import io.hops.util.exceptions.JWTNotFoundException;
import io.hops.util.exceptions.SparkDataTypeNotRecognizedError;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.FeatureDTO;
import io.hops.util.featurestore.dtos.stats.StatisticsDTO;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class FeaturestoreCreateFeaturegroup
extends FeaturestoreOp {
    public FeaturestoreCreateFeaturegroup(String name) {
        super(name);
    }

    @Override
    public Object read() {
        throw new UnsupportedOperationException("read() is not supported on a write operation");
    }

    @Override
    public void write() throws DataframeIsEmpty, SparkDataTypeNotRecognizedError, JAXBException, InvalidPrimaryKeyForFeaturegroup, FeaturegroupCreationError, FeaturestoreNotFound, JWTNotFoundException {
        if (this.dataframe == null) {
            throw new IllegalArgumentException("Dataframe to create featuregroup from cannot be null, specify dataframe with .setDataframe(df)");
        }
        this.primaryKey = FeaturestoreHelper.primaryKeyGetOrDefault(this.primaryKey, (Dataset<Row>)this.dataframe);
        FeaturestoreHelper.validatePrimaryKey((Dataset<Row>)this.dataframe, this.primaryKey);
        FeaturestoreHelper.validateMetadata(this.name, this.dataframe.dtypes(), this.dependencies, this.description);
        StatisticsDTO statisticsDTO = FeaturestoreHelper.computeDataFrameStats(this.name, this.spark, (Dataset<Row>)this.dataframe, this.featurestore, this.version, this.descriptiveStats, this.featureCorr, this.featureHistograms, this.clusterAnalysis, this.statColumns, this.numBins, this.numClusters, this.corrMethod);
        List<FeatureDTO> featuresSchema = FeaturestoreHelper.parseSparkFeaturesSchema(this.dataframe.schema(), this.primaryKey, this.partitionBy);
        FeaturestoreRestClient.createFeaturegroupRest(this.featurestore, this.name, this.version, this.description, this.jobName, this.dependencies, featuresSchema, statisticsDTO);
        FeaturestoreHelper.insertIntoFeaturegroup((Dataset<Row>)this.dataframe, this.spark, this.name, this.featurestore, this.version);
        Hops.updateFeaturestoreMetadataCache().setFeaturestore(this.featurestore).write();
    }

    public FeaturestoreCreateFeaturegroup setName(String name) {
        this.name = name;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setSpark(SparkSession spark) {
        this.spark = spark;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setVersion(int version) {
        this.version = version;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setCorrMethod(String corrMethod) {
        this.corrMethod = corrMethod;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setNumBins(int numBins) {
        this.numBins = numBins;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setNumClusters(int numClusters) {
        this.numClusters = numClusters;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setMode(String mode) {
        this.mode = mode;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setDataframe(Dataset<Row> dataframe) {
        this.dataframe = dataframe;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setDescriptiveStats(Boolean descriptiveStats) {
        this.descriptiveStats = descriptiveStats;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setFeatureCorr(Boolean featureCorr) {
        this.featureCorr = featureCorr;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setFeatureHistograms(Boolean featureHistograms) {
        this.featureHistograms = featureHistograms;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setClusterAnalysis(Boolean clusterAnalysis) {
        this.clusterAnalysis = clusterAnalysis;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setStatColumns(List<String> statColumns) {
        this.statColumns = statColumns;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setJobName(String jobName) {
        this.jobName = jobName;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setDescription(String description) {
        this.description = description;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setPartitionBy(List<String> partitionBy) {
        this.partitionBy = partitionBy;
        return this;
    }
}

