/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.write_ops;

import io.hops.util.FeaturestoreRestClient;
import io.hops.util.Hops;
import io.hops.util.exceptions.CannotWriteImageDataFrameException;
import io.hops.util.exceptions.DataframeIsEmpty;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.exceptions.JWTNotFoundException;
import io.hops.util.exceptions.SparkDataTypeNotRecognizedError;
import io.hops.util.exceptions.TrainingDatasetCreationError;
import io.hops.util.exceptions.TrainingDatasetFormatNotSupportedError;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.FeatureDTO;
import io.hops.util.featurestore.dtos.TrainingDatasetDTO;
import io.hops.util.featurestore.dtos.stats.StatisticsDTO;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.json.JSONObject;

public class FeaturestoreCreateTrainingDataset
extends FeaturestoreOp {
    private static final Logger LOG = Logger.getLogger(FeaturestoreCreateTrainingDataset.class.getName());

    public FeaturestoreCreateTrainingDataset(String name) {
        super(name);
    }

    @Override
    public Object read() {
        throw new UnsupportedOperationException("read() is not supported on a write operation");
    }

    @Override
    public void write() throws DataframeIsEmpty, SparkDataTypeNotRecognizedError, JAXBException, FeaturestoreNotFound, TrainingDatasetCreationError, TrainingDatasetFormatNotSupportedError, CannotWriteImageDataFrameException, JWTNotFoundException {
        if (this.dataframe == null) {
            throw new IllegalArgumentException("Dataframe to create featuregroup from cannot be null, specify dataframe with .setDataframe(df)");
        }
        StatisticsDTO statisticsDTO = FeaturestoreHelper.computeDataFrameStats(this.name, this.spark, (Dataset<Row>)this.dataframe, this.featurestore, this.version, this.descriptiveStats, this.featureCorr, this.featureHistograms, this.clusterAnalysis, this.statColumns, this.numBins, this.numClusters, this.corrMethod);
        List<FeatureDTO> featuresSchema = FeaturestoreHelper.parseSparkFeaturesSchema(this.dataframe.schema(), null, null);
        Response response = FeaturestoreRestClient.createTrainingDatasetRest(this.featurestore, this.name, this.version, this.description, this.jobName, this.dataFormat, this.dependencies, featuresSchema, statisticsDTO);
        String jsonStrResponse = response.readEntity(String.class);
        JSONObject jsonObjResponse = new JSONObject(jsonStrResponse);
        TrainingDatasetDTO trainingDatasetDTO = FeaturestoreHelper.parseTrainingDatasetJson(jsonObjResponse);
        String hdfsPath = trainingDatasetDTO.getHdfsStorePath() + "/" + this.name;
        FeaturestoreHelper.writeTrainingDatasetHdfs(this.spark, (Dataset<Row>)this.dataframe, hdfsPath, this.dataFormat, "overwrite");
        if (this.dataFormat == "tfrecords") {
            try {
                JSONObject tfRecordSchemaJson = FeaturestoreHelper.getDataframeTfRecordSchemaJson((Dataset<Row>)this.dataframe);
                FeaturestoreHelper.writeTfRecordSchemaJson(trainingDatasetDTO.getHdfsStorePath() + "/" + "tf_record_schema.txt", tfRecordSchemaJson.toString());
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Could not save tf record schema json to HDFS for training dataset: " + this.name, e);
            }
        }
        Hops.updateFeaturestoreMetadataCache().setFeaturestore(this.featurestore).write();
    }

    public FeaturestoreCreateTrainingDataset setName(String name) {
        this.name = name;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setSpark(SparkSession spark) {
        this.spark = spark;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setVersion(int version) {
        this.version = version;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setCorrMethod(String corrMethod) {
        this.corrMethod = corrMethod;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setNumBins(int numBins) {
        this.numBins = numBins;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setNumClusters(int numClusters) {
        this.numClusters = numClusters;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setMode(String mode) {
        this.mode = mode;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setDataframe(Dataset<Row> dataframe) {
        this.dataframe = dataframe;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setDescriptiveStats(Boolean descriptiveStats) {
        this.descriptiveStats = descriptiveStats;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setFeatureCorr(Boolean featureCorr) {
        this.featureCorr = featureCorr;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setFeatureHistograms(Boolean featureHistograms) {
        this.featureHistograms = featureHistograms;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setClusterAnalysis(Boolean clusterAnalysis) {
        this.clusterAnalysis = clusterAnalysis;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setStatColumns(List<String> statColumns) {
        this.statColumns = statColumns;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setJobName(String jobName) {
        this.jobName = jobName;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setDescription(String description) {
        this.description = description;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
        return this;
    }
}

