/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.write_ops;

import io.hops.util.FeaturestoreRestClient;
import io.hops.util.exceptions.DataframeIsEmpty;
import io.hops.util.exceptions.FeaturegroupDeletionError;
import io.hops.util.exceptions.FeaturegroupDoesNotExistError;
import io.hops.util.exceptions.FeaturegroupUpdateStatsError;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.exceptions.JWTNotFoundException;
import io.hops.util.exceptions.SparkDataTypeNotRecognizedError;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.stats.StatisticsDTO;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import io.hops.util.featurestore.ops.write_ops.FeaturestoreUpdateMetadataCache;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class FeaturestoreInsertIntoFeaturegroup
extends FeaturestoreOp {
    public FeaturestoreInsertIntoFeaturegroup(String name) {
        super(name);
    }

    @Override
    public Object read() {
        throw new UnsupportedOperationException("read() is not supported on a write operation");
    }

    @Override
    public void write() throws DataframeIsEmpty, SparkDataTypeNotRecognizedError, JAXBException, FeaturegroupUpdateStatsError, FeaturestoreNotFound, JWTNotFoundException, FeaturegroupDeletionError, FeaturegroupDoesNotExistError {
        if (this.dataframe == null) {
            throw new IllegalArgumentException("Dataframe to insert cannot be null, specify dataframe with .setDataframe(df)");
        }
        this.spark.sparkContext().setJobGroup("Inserting dataframe into featuregroup", "Inserting into featuregroup:" + this.name + " in the featurestore:" + this.featurestore, true);
        if (this.mode == null || !this.mode.equalsIgnoreCase("append") && !this.mode.equalsIgnoreCase("overwrite")) {
            throw new IllegalArgumentException("The supplied write mode: " + this.mode + " does not match any of the supported modes: overwrite, append");
        }
        if (this.mode.equalsIgnoreCase("overwrite")) {
            FeaturestoreRestClient.deleteTableContentsRest(this.featurestore, this.name, this.version);
            new FeaturestoreUpdateMetadataCache().setFeaturestore(this.featurestore).write();
        }
        this.spark.sparkContext().setJobGroup("", "", true);
        FeaturestoreHelper.insertIntoFeaturegroup((Dataset<Row>)this.dataframe, this.spark, this.name, this.featurestore, this.version);
        StatisticsDTO statisticsDTO = FeaturestoreHelper.computeDataFrameStats(this.name, this.spark, (Dataset<Row>)this.dataframe, this.featurestore, this.version, this.descriptiveStats, this.featureCorr, this.featureHistograms, this.clusterAnalysis, this.statColumns, this.numBins, this.numClusters, this.corrMethod);
        FeaturestoreRestClient.updateFeaturegroupStatsRest(this.name, this.featurestore, this.version, statisticsDTO);
        this.spark.sparkContext().setJobGroup("", "", true);
    }

    public FeaturestoreInsertIntoFeaturegroup setName(String name) {
        this.name = name;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setSpark(SparkSession spark) {
        this.spark = spark;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setVersion(int version) {
        this.version = version;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setCorrMethod(String corrMethod) {
        this.corrMethod = corrMethod;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setNumBins(int numBins) {
        this.numBins = numBins;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setNumClusters(int numClusters) {
        this.numClusters = numClusters;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setMode(String mode) {
        this.mode = mode;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setDataframe(Dataset<Row> dataframe) {
        this.dataframe = dataframe;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setDescriptiveStats(Boolean descriptiveStats) {
        this.descriptiveStats = descriptiveStats;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setFeatureCorr(Boolean featureCorr) {
        this.featureCorr = featureCorr;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setFeatureHistograms(Boolean featureHistograms) {
        this.featureHistograms = featureHistograms;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setClusterAnalysis(Boolean clusterAnalysis) {
        this.clusterAnalysis = clusterAnalysis;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setStatColumns(List<String> statColumns) {
        this.statColumns = statColumns;
        return this;
    }
}

