/*
 * Decompiled with CFR 0.152.
 */
package jersey.repackaged.com.google.common.cache;

import java.util.Map;
import javax.annotation.Nullable;
import jersey.repackaged.com.google.common.base.Objects;
import jersey.repackaged.com.google.common.base.Preconditions;
import jersey.repackaged.com.google.common.cache.RemovalCause;

public final class RemovalNotification<K, V>
implements Map.Entry<K, V> {
    @Nullable
    private final K key;
    @Nullable
    private final V value;
    private final RemovalCause cause;

    RemovalNotification(@Nullable K key, @Nullable V value2, RemovalCause cause) {
        this.key = key;
        this.value = value2;
        this.cause = Preconditions.checkNotNull(cause);
    }

    @Override
    @Nullable
    public K getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public V getValue() {
        return this.value;
    }

    @Override
    public final V setValue(V value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry that = (Map.Entry)object;
            return Objects.equal(this.getKey(), that.getKey()) && Objects.equal(this.getValue(), that.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        K k = this.getKey();
        V v = this.getValue();
        return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
    }

    public String toString() {
        String string2 = String.valueOf(String.valueOf(this.getKey()));
        String string3 = String.valueOf(String.valueOf(this.getValue()));
        return new StringBuilder(1 + string2.length() + string3.length()).append(string2).append("=").append(string3).toString();
    }
}

