/*
 * Decompiled with CFR 0.152.
 */
package jersey.repackaged.com.google.common.collect;

import javax.annotation.Nullable;
import jersey.repackaged.com.google.common.collect.CollectPreconditions;
import jersey.repackaged.com.google.common.collect.ImmutableEntry;

abstract class ImmutableMapEntry<K, V>
extends ImmutableEntry<K, V> {
    ImmutableMapEntry(K key, V value2) {
        super(key, value2);
        CollectPreconditions.checkEntryNotNull(key, value2);
    }

    ImmutableMapEntry(ImmutableMapEntry<K, V> contents) {
        super(contents.getKey(), contents.getValue());
    }

    @Nullable
    abstract ImmutableMapEntry<K, V> getNextInKeyBucket();

    static final class TerminalEntry<K, V>
    extends ImmutableMapEntry<K, V> {
        TerminalEntry(K key, V value2) {
            super(key, value2);
        }

        @Override
        @Nullable
        ImmutableMapEntry<K, V> getNextInKeyBucket() {
            return null;
        }
    }
}

