/*
 * Decompiled with CFR 0.152.
 */
package jersey.repackaged.com.google.common.collect;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import jersey.repackaged.com.google.common.base.Ascii;
import jersey.repackaged.com.google.common.base.Equivalence;
import jersey.repackaged.com.google.common.base.MoreObjects;
import jersey.repackaged.com.google.common.base.Preconditions;
import jersey.repackaged.com.google.common.base.Ticker;
import jersey.repackaged.com.google.common.collect.GenericMapMaker;
import jersey.repackaged.com.google.common.collect.ImmutableEntry;
import jersey.repackaged.com.google.common.collect.MapMakerInternalMap;

public final class MapMaker
extends GenericMapMaker<Object, Object> {
    boolean useCustomMap;
    int initialCapacity = -1;
    int concurrencyLevel = -1;
    int maximumSize = -1;
    MapMakerInternalMap.Strength keyStrength;
    MapMakerInternalMap.Strength valueStrength;
    long expireAfterWriteNanos = -1L;
    long expireAfterAccessNanos = -1L;
    RemovalCause nullRemovalCause;
    Equivalence<Object> keyEquivalence;
    Ticker ticker;

    Equivalence<Object> getKeyEquivalence() {
        return MoreObjects.firstNonNull(this.keyEquivalence, this.getKeyStrength().defaultEquivalence());
    }

    int getInitialCapacity() {
        return this.initialCapacity == -1 ? 16 : this.initialCapacity;
    }

    int getConcurrencyLevel() {
        return this.concurrencyLevel == -1 ? 4 : this.concurrencyLevel;
    }

    MapMakerInternalMap.Strength getKeyStrength() {
        return MoreObjects.firstNonNull(this.keyStrength, MapMakerInternalMap.Strength.STRONG);
    }

    MapMakerInternalMap.Strength getValueStrength() {
        return MoreObjects.firstNonNull(this.valueStrength, MapMakerInternalMap.Strength.STRONG);
    }

    long getExpireAfterWriteNanos() {
        return this.expireAfterWriteNanos == -1L ? 0L : this.expireAfterWriteNanos;
    }

    long getExpireAfterAccessNanos() {
        return this.expireAfterAccessNanos == -1L ? 0L : this.expireAfterAccessNanos;
    }

    Ticker getTicker() {
        return MoreObjects.firstNonNull(this.ticker, Ticker.systemTicker());
    }

    public <K, V> ConcurrentMap<K, V> makeMap() {
        if (!this.useCustomMap) {
            return new ConcurrentHashMap(this.getInitialCapacity(), 0.75f, this.getConcurrencyLevel());
        }
        return (ConcurrentMap)((Object)(this.nullRemovalCause == null ? new MapMakerInternalMap(this) : new NullConcurrentMap(this)));
    }

    public String toString() {
        long l;
        MoreObjects.ToStringHelper s2 = MoreObjects.toStringHelper(this);
        if (this.initialCapacity != -1) {
            s2.add("initialCapacity", this.initialCapacity);
        }
        if (this.concurrencyLevel != -1) {
            s2.add("concurrencyLevel", this.concurrencyLevel);
        }
        if (this.maximumSize != -1) {
            s2.add("maximumSize", this.maximumSize);
        }
        if (this.expireAfterWriteNanos != -1L) {
            l = this.expireAfterWriteNanos;
            s2.add("expireAfterWrite", new StringBuilder(22).append(l).append("ns").toString());
        }
        if (this.expireAfterAccessNanos != -1L) {
            l = this.expireAfterAccessNanos;
            s2.add("expireAfterAccess", new StringBuilder(22).append(l).append("ns").toString());
        }
        if (this.keyStrength != null) {
            s2.add("keyStrength", Ascii.toLowerCase(this.keyStrength.toString()));
        }
        if (this.valueStrength != null) {
            s2.add("valueStrength", Ascii.toLowerCase(this.valueStrength.toString()));
        }
        if (this.keyEquivalence != null) {
            s2.addValue("keyEquivalence");
        }
        if (this.removalListener != null) {
            s2.addValue("removalListener");
        }
        return s2.toString();
    }

    static class NullConcurrentMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable,
    ConcurrentMap<K, V> {
        private final RemovalListener<K, V> removalListener;
        private final RemovalCause removalCause;

        NullConcurrentMap(MapMaker mapMaker) {
            this.removalListener = mapMaker.getRemovalListener();
            this.removalCause = mapMaker.nullRemovalCause;
        }

        @Override
        public boolean containsKey(@Nullable Object key) {
            return false;
        }

        @Override
        public boolean containsValue(@Nullable Object value2) {
            return false;
        }

        @Override
        public V get(@Nullable Object key) {
            return null;
        }

        void notifyRemoval(K key, V value2) {
            RemovalNotification<K, V> notification = new RemovalNotification<K, V>(key, value2, this.removalCause);
            this.removalListener.onRemoval(notification);
        }

        @Override
        public V put(K key, V value2) {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(value2);
            this.notifyRemoval(key, value2);
            return null;
        }

        @Override
        public V putIfAbsent(K key, V value2) {
            return this.put(key, value2);
        }

        @Override
        public V remove(@Nullable Object key) {
            return null;
        }

        @Override
        public boolean remove(@Nullable Object key, @Nullable Object value2) {
            return false;
        }

        @Override
        public V replace(K key, V value2) {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(value2);
            return null;
        }

        @Override
        public boolean replace(K key, @Nullable V oldValue, V newValue) {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(newValue);
            return false;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.emptySet();
        }
    }

    static abstract class RemovalCause
    extends Enum<RemovalCause> {
        public static final /* enum */ RemovalCause EXPLICIT = new RemovalCause(){};
        public static final /* enum */ RemovalCause REPLACED = new RemovalCause(){};
        public static final /* enum */ RemovalCause COLLECTED = new RemovalCause(){};
        public static final /* enum */ RemovalCause EXPIRED = new RemovalCause(){};
        public static final /* enum */ RemovalCause SIZE = new RemovalCause(){};
        private static final /* synthetic */ RemovalCause[] $VALUES;

        static {
            $VALUES = new RemovalCause[]{EXPLICIT, REPLACED, COLLECTED, EXPIRED, SIZE};
        }
    }

    static final class RemovalNotification<K, V>
    extends ImmutableEntry<K, V> {
        private final RemovalCause cause;

        RemovalNotification(@Nullable K key, @Nullable V value2, RemovalCause cause) {
            super(key, value2);
            this.cause = cause;
        }
    }

    static interface RemovalListener<K, V> {
        public void onRemoval(RemovalNotification<K, V> var1);
    }
}

