/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.AdminOperationException;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class PreferredReplicaLeaderElectionCommand$
implements Logging {
    public static final PreferredReplicaLeaderElectionCommand$ MODULE$;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new PreferredReplicaLeaderElectionCommand$();
    }

    private Logger logger$lzycompute() {
        PreferredReplicaLeaderElectionCommand$ preferredReplicaLeaderElectionCommand$ = this;
        synchronized (preferredReplicaLeaderElectionCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec<String> jsonFileOpt = parser.accepts("path-to-json-file", "The JSON file with the list of partitions for which preferred replica leader election should be done, in the following format - \n{\"partitions\":\n\t[{\"topic\": \"foo\", \"partition\": 1},\n\t {\"topic\": \"foobar\", \"partition\": 2}]\n}\nDefaults to all existing partitions").withRequiredArg().describedAs("list of partitions for which preferred replica leader election needs to be triggered").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> zkConnectOpt = parser.accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "This tool causes leadership for each partition to be transferred back to the 'preferred replica', it can be used to balance leadership among the servers.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{zkConnectOpt}));
        String zkConnect = options.valueOf(zkConnectOpt);
        KafkaZkClient zkClient = null;
        try {
            try {
                Time time = Time.SYSTEM;
                zkClient = KafkaZkClient$.MODULE$.apply(zkConnect, JaasUtils.isZkSecurityEnabled(), 30000, 30000, Integer.MAX_VALUE, time, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8());
                scala.collection.immutable.Set<TopicPartition> partitionsForPreferredReplicaElection = options.has(jsonFileOpt) ? this.parsePreferredReplicaElectionData(Utils.readFileAsString(options.valueOf(jsonFileOpt))) : zkClient.getAllPartitions();
                PreferredReplicaLeaderElectionCommand preferredReplicaElectionCommand = new PreferredReplicaLeaderElectionCommand(zkClient, partitionsForPreferredReplicaElection);
                preferredReplicaElectionCommand.moveLeaderToPreferredReplica();
            }
            catch (Throwable throwable) {
                Predef$.MODULE$.println("Failed to start preferred replica election");
                Predef$.MODULE$.println(Utils.stackTrace(throwable));
            }
        }
        finally {
            if (zkClient != null) {
                zkClient.close();
            }
        }
    }

    public scala.collection.immutable.Set<TopicPartition> parsePreferredReplicaElectionData(String jsonString) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonString);
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonValue js = (JsonValue)some.x();
            Option<JsonValue> option2 = js.asJsonObject().get("partitions");
            if (option2 instanceof Some) {
                scala.collection.immutable.Set<TopicPartition> set2;
                Some some2 = (Some)option2;
                JsonValue partitionsList = (JsonValue)some2.x();
                Iterator<JsonObject> partitionsRaw = partitionsList.asJsonArray().iterator().map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final JsonObject apply(JsonValue x$1) {
                        return x$1.asJsonObject();
                    }
                });
                Buffer partitions2 = partitionsRaw.map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final TopicPartition apply(JsonObject p) {
                        String topic = p.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                        int partition2 = BoxesRunTime.unboxToInt(p.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
                        return new TopicPartition(topic, partition2);
                    }
                }).toBuffer();
                Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates(partitions2);
                if (duplicatePartitions.nonEmpty()) {
                    throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Preferred replica election data contains duplicate partitions: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{duplicatePartitions.mkString(",")})));
                }
                scala.collection.immutable.Set<TopicPartition> set3 = set2 = partitions2.toSet();
                return set3;
            }
            if (None$.MODULE$.equals(option2)) {
                throw new AdminOperationException("Preferred replica election data is empty");
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            throw new AdminOperationException("Preferred replica election data is empty");
        }
        throw new MatchError(option);
    }

    public void writePreferredReplicaElectionData(KafkaZkClient zkClient, Set<TopicPartition> partitionsUndergoingPreferredReplicaElection) {
        try {
            zkClient.createPreferredReplicaElection(partitionsUndergoingPreferredReplicaElection.toSet());
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Created preferred replica election path with %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{partitionsUndergoingPreferredReplicaElection.mkString(",")})));
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable.toString());
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new AdminOperationException(new StringBuilder().append((Object)"Preferred replica leader election currently in progress for ").append((Object)new StringOps(Predef$.MODULE$.augmentString("%s. Aborting operation")).format(Predef$.MODULE$.genericWrapArray(new Object[]{zkClient.getPreferredReplicaElection().mkString(",")}))).toString());
        }
    }

    private PreferredReplicaLeaderElectionCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

